/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public abstract class AbstractSchemaRule
implements SchemaRule {
    private final int label;
    private final SchemaRule.Kind kind;
    private final long id;

    public AbstractSchemaRule(long id, int label, SchemaRule.Kind kind) {
        this.id = id;
        this.label = label;
        this.kind = kind;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public final int getLabel() {
        return this.label;
    }

    @Override
    public final SchemaRule.Kind getKind() {
        return this.kind;
    }

    @Override
    public int length() {
        return 5;
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.label);
        target.put(this.kind.id());
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.kind.hashCode();
        return 31 * result + this.label;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSchemaRule other = (AbstractSchemaRule)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return this.label == other.label;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", label=" + this.label + ", kind=" + (Object)((Object)this.kind) + this.innerToString() + "]";
    }

    protected abstract String innerToString();
}

