/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipIterator;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.CombinedRelIdIterator;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class NodeImpl
extends ArrayBasedPrimitive {
    private static final RelIdArray[] NO_RELATIONSHIPS = new RelIdArray[0];
    private volatile RelIdArray[] relationships;
    private volatile int[] labels;
    private volatile long relChainPosition = Record.NO_NEXT_RELATIONSHIP.intValue();
    private final long id;
    private static final Comparator<RelIdArray> RELATIONSHIP_TYPE_COMPARATOR_FOR_SORTING = new Comparator<RelIdArray>(){

        @Override
        public int compare(RelIdArray o1, RelIdArray o2) {
            return o1.getType() - o2.getType();
        }
    };
    private static final Comparator RELATIONSHIP_TYPE_COMPARATOR_FOR_BINARY_SEARCH = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((RelIdArray)o1).getType() - (Integer)o2;
        }
    };

    public NodeImpl(long id) {
        this(id, false);
    }

    public NodeImpl(long id, boolean newNode) {
        super(newNode);
        this.id = id;
        if (newNode) {
            this.relationships = NO_RELATIONSHIPS;
        }
    }

    @Override
    protected Iterator<DefinedProperty> loadProperties(NodeManager nodeManager) {
        return nodeManager.loadProperties(this, false);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        int size = super.sizeOfObjectInBytesIncludingOverhead() + 8 + 8 + 8 + 8;
        if (this.relationships != null && this.relationships.length > 0) {
            size = SizeOfs.withArrayOverheadIncludingReferences(size, this.relationships.length);
            for (RelIdArray array : this.relationships) {
                size += array.sizeOfObjectInBytesIncludingOverhead();
            }
        }
        if (this.labels != null && this.labels.length > 0) {
            size += SizeOfs.sizeOfArray(this.labels);
        }
        return size;
    }

    @Override
    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeImpl && ((NodeImpl)obj).getId() == this.getId();
    }

    Iterable<Relationship> getAllRelationships(final NodeManager nodeManager, final RelIdArray.DirectionWrapper direction) {
        this.ensureRelationshipMapNotNull(nodeManager);
        final NodeImpl nodeImpl = this;
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                RelIdIterator[] result;
                boolean hasMore = NodeImpl.this.hasMoreRelationshipsToLoad();
                RelIdArray[] localRelationships = NodeImpl.this.relationships;
                RelIdIterator[] relIdIterators = new RelIdIterator[localRelationships.length];
                TransactionState tx = nodeManager.getTransactionState();
                ArrayMap<Integer, RelIdArray> addMap = null;
                ArrayMap<Integer, Collection<Long>> skipMap = null;
                if (tx.hasChanges()) {
                    addMap = tx.getCowRelationshipAddMap(nodeImpl);
                    skipMap = tx.getCowRelationshipRemoveMap(nodeImpl);
                }
                for (int i = 0; i < localRelationships.length; ++i) {
                    RelIdArray src = localRelationships[i];
                    int type = src.getType();
                    RelIdIterator iterator = addMap != null || skipMap != null ? new CombinedRelIdIterator(type, direction, src, addMap != null ? addMap.get(type) : null, skipMap != null ? skipMap.get(type) : null) : src.iterator(direction);
                    relIdIterators[i] = iterator;
                }
                if (addMap != null) {
                    RelIdIterator[] additional = new RelIdIterator[addMap.size()];
                    int additionalSize = 0;
                    for (int type : addMap.keySet()) {
                        if (NodeImpl.this.getRelIdArray(type) != null) continue;
                        RelIdArray add = addMap.get(type);
                        additional[additionalSize++] = new CombinedRelIdIterator(type, direction, null, add, skipMap != null ? skipMap.get(type) : null);
                    }
                    RelIdIterator[] newResult = new RelIdIterator[relIdIterators.length + additionalSize];
                    System.arraycopy(relIdIterators, 0, newResult, 0, relIdIterators.length);
                    System.arraycopy(additional, 0, newResult, relIdIterators.length, additionalSize);
                    result = newResult;
                } else {
                    result = relIdIterators;
                }
                if (result.length == 0) {
                    return Collections.emptyIterator();
                }
                return new RelationshipIterator(result, nodeImpl, direction, nodeManager, hasMore, true);
            }
        };
    }

    Iterable<Relationship> getAllRelationshipsOfType(final NodeManager nodeManager, final RelIdArray.DirectionWrapper direction, RelationshipType ... initialTypes) {
        final RelationshipType[] types = NodeImpl.deduplicate(initialTypes);
        this.ensureRelationshipMapNotNull(nodeManager);
        final NodeImpl nodeImpl = this;
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                RelIdIterator[] result;
                boolean hasMore = NodeImpl.this.hasMoreRelationshipsToLoad();
                RelIdIterator[] relIdIterators = new RelIdIterator[types.length];
                TransactionState tx = nodeManager.getTransactionState();
                ArrayMap<Integer, RelIdArray> addMap = null;
                ArrayMap<Integer, Collection<Long>> skipMap = null;
                if (tx.hasChanges()) {
                    addMap = tx.getCowRelationshipAddMap(nodeImpl);
                    skipMap = tx.getCowRelationshipRemoveMap(nodeImpl);
                }
                int actualLength = 0;
                for (RelationshipType type : types) {
                    int typeId = nodeManager.getRelationshipTypeIdFor(type);
                    if (typeId == -1) continue;
                    relIdIterators[actualLength++] = NodeImpl.this.getRelationshipsIterator(direction, addMap != null ? addMap.get(typeId) : null, skipMap != null ? skipMap.get(typeId) : null, typeId);
                }
                if (actualLength < relIdIterators.length) {
                    RelIdIterator[] compacted = new RelIdIterator[actualLength];
                    System.arraycopy(relIdIterators, 0, compacted, 0, actualLength);
                    result = compacted;
                } else {
                    result = relIdIterators;
                }
                if (result.length == 0) {
                    return Collections.emptyIterator();
                }
                return new RelationshipIterator(result, nodeImpl, direction, nodeManager, hasMore, false);
            }
        };
    }

    private static RelationshipType[] deduplicate(RelationshipType[] types) {
        int unique = 0;
        for (int i = 0; i < types.length; ++i) {
            String name = types[i].name();
            for (int j = 0; j < unique; ++j) {
                if (!name.equals(types[j].name())) continue;
                name = null;
                break;
            }
            if (name == null) continue;
            types[unique++] = types[i];
        }
        if (unique < types.length) {
            types = Arrays.copyOf(types, unique);
        }
        return types;
    }

    private RelIdIterator getRelationshipsIterator(RelIdArray.DirectionWrapper direction, RelIdArray add, Collection<Long> remove, int type) {
        RelIdArray src = this.getRelIdArray(type);
        if (add != null || remove != null) {
            return new CombinedRelIdIterator(type, direction, src, add, remove);
        }
        return src != null ? src.iterator(direction) : RelIdArray.empty(type).iterator(direction);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager) {
        return this.getAllRelationships(nodeManager, RelIdArray.DirectionWrapper.BOTH);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction dir) {
        return this.getAllRelationships(nodeManager, RelIdArray.wrap(dir));
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.DirectionWrapper.BOTH, type);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType ... types) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.DirectionWrapper.BOTH, types);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction direction, RelationshipType ... types) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.wrap(direction), types);
    }

    public Relationship getSingleRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        Iterator<Relationship> rels = this.getAllRelationshipsOfType(nodeManager, RelIdArray.wrap(dir), type).iterator();
        if (!rels.hasNext()) {
            return null;
        }
        Relationship rel = rels.next();
        while (rels.hasNext()) {
            Relationship other = rels.next();
            if (other.equals(rel)) continue;
            throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
        }
        return rel;
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type, Direction dir) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.wrap(dir), type);
    }

    public String toString() {
        return "NodeImpl#" + this.getId();
    }

    private void ensureRelationshipMapNotNull(NodeManager nodeManager) {
        if (this.relationships == null) {
            this.loadInitialRelationships(nodeManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialRelationships(NodeManager nodeManager) {
        Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> rels = null;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (this.relationships == null) {
                try {
                    this.relChainPosition = nodeManager.getRelationshipChainPosition(this);
                }
                catch (InvalidRecordException e) {
                    throw new NotFoundException(this.asProxy(nodeManager) + " concurrently deleted while loading its relationships?", e);
                }
                ArrayMap<Integer, RelIdArray> tmpRelMap = new ArrayMap<Integer, RelIdArray>();
                rels = this.getMoreRelationships(nodeManager, tmpRelMap);
                this.relationships = this.toRelIdArray(tmpRelMap);
                if (rels != null) {
                    this.setRelChainPosition(rels.third());
                }
                this.updateSize(nodeManager);
            }
        }
        if (rels != null) {
            nodeManager.putAllInRelCache((Collection)rels.second());
        }
    }

    protected void updateSize(NodeManager nodeManager) {
        nodeManager.updateCacheSize(this, this.sizeOfObjectInBytesIncludingOverhead());
    }

    private RelIdArray[] toRelIdArray(ArrayMap<Integer, RelIdArray> tmpRelMap) {
        RelIdArray[] result = new RelIdArray[tmpRelMap.size()];
        int i = 0;
        for (RelIdArray array : tmpRelMap.values()) {
            result[i++] = array;
        }
        NodeImpl.sort(result);
        return result;
    }

    private static void sort(RelIdArray[] array) {
        Arrays.sort(array, RELATIONSHIP_TYPE_COMPARATOR_FOR_SORTING);
    }

    private Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> getMoreRelationships(NodeManager nodeManager, ArrayMap<Integer, RelIdArray> tmpRelMap) {
        if (!this.hasMoreRelationshipsToLoad()) {
            return null;
        }
        Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> rels = this.loadMoreRelationshipsFromNodeManager(nodeManager);
        ArrayMap<Integer, RelIdArray> addMap = rels.first();
        if (addMap.size() == 0) {
            return null;
        }
        for (Integer type : addMap.keySet()) {
            RelIdArray addRels = addMap.get(type);
            RelIdArray srcRels = tmpRelMap.get(type);
            if (srcRels == null) {
                tmpRelMap.put(type, addRels);
                continue;
            }
            RelIdArray newSrcRels = srcRels.addAll(addRels);
            if (newSrcRels == srcRels) continue;
            tmpRelMap.put(type, newSrcRels);
        }
        return rels;
    }

    boolean hasMoreRelationshipsToLoad() {
        return this.getRelChainPosition() != (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadStatus getMoreRelationships(NodeManager nodeManager) {
        boolean more;
        Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> rels;
        if (!this.hasMoreRelationshipsToLoad()) {
            return LoadStatus.NOTHING;
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (!this.hasMoreRelationshipsToLoad()) {
                return LoadStatus.NOTHING;
            }
            rels = this.loadMoreRelationshipsFromNodeManager(nodeManager);
            ArrayMap<Integer, RelIdArray> addMap = rels.first();
            if (addMap.size() == 0) {
                return LoadStatus.NOTHING;
            }
            for (int type : addMap.keySet()) {
                RelIdArray addRels = addMap.get(type);
                RelIdArray srcRels = this.getRelIdArray(type);
                if (srcRels == null) {
                    this.putRelIdArray(addRels);
                    continue;
                }
                RelIdArray newSrcRels = srcRels.addAll(addRels);
                if (newSrcRels == srcRels) continue;
                this.putRelIdArray(newSrcRels);
            }
            this.setRelChainPosition(rels.third());
            more = this.hasMoreRelationshipsToLoad();
            this.updateSize(nodeManager);
        }
        nodeManager.putAllInRelCache((Collection<RelationshipImpl>)rels.second());
        return more ? LoadStatus.LOADED_MORE : LoadStatus.LOADED_END;
    }

    private Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> loadMoreRelationshipsFromNodeManager(NodeManager nodeManager) {
        try {
            return nodeManager.getMoreRelationships(this);
        }
        catch (InvalidRecordException e) {
            throw new NotFoundException("Unable to load one or more relationships from " + this.asProxy(nodeManager) + ". This usually happens when relationships are deleted by someone else just as we are about to " + "load them. Please try again.", e);
        }
    }

    private RelIdArray getRelIdArray(int type) {
        RelIdArray[] localRelationships = this.relationships;
        int index = Arrays.binarySearch(localRelationships, type, RELATIONSHIP_TYPE_COMPARATOR_FOR_BINARY_SEARCH);
        return index < 0 ? null : localRelationships[index];
    }

    private void putRelIdArray(RelIdArray addRels) {
        RelIdArray[] array = this.relationships;
        int expectedType = addRels.getType();
        for (int i = 0; i < array.length; ++i) {
            if (array[i].getType() != expectedType) continue;
            array[i] = addRels;
            return;
        }
        array = Arrays.copyOf(array, array.length + 1);
        array[array.length - 1] = addRels;
        NodeImpl.sort(array);
        this.relationships = array;
    }

    public boolean hasRelationship(NodeManager nodeManager) {
        return this.getRelationships(nodeManager).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType ... types) {
        return this.getRelationships(nodeManager, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction direction, RelationshipType ... types) {
        return this.getRelationships(nodeManager, direction, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction dir) {
        return this.getRelationships(nodeManager, dir).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        return this.getRelationships(nodeManager, type, dir).iterator().hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitRelationshipMaps(ArrayMap<Integer, RelIdArray> cowRelationshipAddMap, ArrayMap<Integer, Collection<Long>> cowRelationshipRemoveMap) {
        if (this.relationships == null) {
            return;
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            Collection<Long> remove;
            if (cowRelationshipAddMap != null) {
                for (int type : cowRelationshipAddMap.keySet()) {
                    RelIdArray add = cowRelationshipAddMap.get(type);
                    remove = null;
                    if (cowRelationshipRemoveMap != null) {
                        remove = cowRelationshipRemoveMap.get(type);
                    }
                    RelIdArray src = this.getRelIdArray(type);
                    this.putRelIdArray(RelIdArray.from(src, add, remove));
                }
            }
            if (cowRelationshipRemoveMap != null) {
                for (int type : cowRelationshipRemoveMap.keySet()) {
                    RelIdArray src;
                    if (cowRelationshipAddMap != null && cowRelationshipAddMap.get(type) != null || (src = this.getRelIdArray(type)) == null) continue;
                    remove = cowRelationshipRemoveMap.get(type);
                    this.putRelIdArray(RelIdArray.from(src, null, remove));
                }
            }
        }
    }

    long getRelChainPosition() {
        return this.relChainPosition;
    }

    void setRelChainPosition(long position) {
        this.relChainPosition = position;
        RelIdArray[] array = this.relationships;
        if (!this.hasMoreRelationshipsToLoad() && array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = array[i].shrink();
            }
        }
    }

    RelIdArray getRelationshipIds(int type) {
        return this.getRelIdArray(type);
    }

    RelIdArray[] getRelationshipIds() {
        return this.relationships;
    }

    @Override
    public WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement element, boolean create) {
        return element.nodeElement(this.getId(), create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return nm.newNodeProxyById(this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLabels(KernelStatement state, CacheLoader<int[]> loader) throws EntityNotFoundException {
        if (this.labels == null) {
            NodeImpl nodeImpl = this;
            synchronized (nodeImpl) {
                if (this.labels == null) {
                    this.labels = loader.load(this.getId());
                }
            }
        }
        return this.labels;
    }

    public boolean hasLabel(KernelStatement state, int labelId, CacheLoader<int[]> loader) throws EntityNotFoundException {
        int[] labels = this.getLabels(state, loader);
        return Arrays.binarySearch(labels, labelId) >= 0;
    }

    public synchronized void commitLabels(int[] labels) {
        this.labels = labels;
    }

    @Override
    protected Property noProperty(int key) {
        return Property.noNodeProperty(this.getId(), key);
    }

    static enum LoadStatus {
        NOTHING(false, false),
        LOADED_END(true, false),
        LOADED_MORE(true, true);

        private final boolean loaded;
        private final boolean more;

        private LoadStatus(boolean loaded, boolean more) {
            this.loaded = loaded;
            this.more = more;
        }

        public boolean loaded() {
            return this.loaded;
        }

        public boolean hasMoreToLoad() {
            return this.more;
        }
    }
}

