/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

final class ByteProperty
extends DefinedProperty {
    private final byte value;

    ByteProperty(int propertyKeyId, byte value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Byte) {
            return (Byte)other == this.value;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return this.value == ((ByteProperty)that).value;
    }

    @Override
    public Byte value() {
        return this.value;
    }

    @Override
    int valueHash() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(8);
    }
}

