/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.CommitNotificationFailedException;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerificationException;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInfo;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class XaResourceManager {
    private final ArrayMap<XAResource, ResourceTransaction> xaResourceMap = new ArrayMap();
    private final ArrayMap<Xid, XidStatus> xidMap = new ArrayMap();
    private final TransactionMonitor transactionMonitor;
    private int recoveredTxCount = 0;
    private final Map<Integer, TransactionInfo> recoveredTransactions = new HashMap<Integer, TransactionInfo>();
    private XaLogicalLog log = null;
    private final XaTransactionFactory tf;
    private final String name;
    private final TxIdGenerator txIdGenerator;
    private final XaDataSource dataSource;
    private StringLogger msgLog;
    private final AbstractTransactionManager transactionManager;
    private final RecoveryVerifier recoveryVerifier;
    private int nextTxOrder = 0;

    public XaResourceManager(XaDataSource dataSource, XaTransactionFactory tf, TxIdGenerator txIdGenerator, AbstractTransactionManager transactionManager, RecoveryVerifier recoveryVerifier, String name, Monitors monitors) {
        this.dataSource = dataSource;
        this.tf = tf;
        this.txIdGenerator = txIdGenerator;
        this.transactionManager = transactionManager;
        this.recoveryVerifier = recoveryVerifier;
        this.name = name;
        this.transactionMonitor = monitors.newMonitor(TransactionMonitor.class, this.getClass(), dataSource.getName());
    }

    public synchronized void setLogicalLog(XaLogicalLog log) {
        this.log = log;
        this.msgLog = log.getStringLogger();
    }

    synchronized XaTransaction createTransaction(XAResource xaResource) throws XAException {
        if (this.xaResourceMap.get(xaResource) != null) {
            throw new XAException("Resource[" + xaResource + "] already enlisted or suspended");
        }
        XaTransaction xaTx = this.tf.create(this.dataSource.getLastCommittedTxId(), this.transactionManager.getTransactionState());
        this.xaResourceMap.put(xaResource, new ResourceTransaction(xaTx));
        return xaTx;
    }

    synchronized XaTransaction getXaTransaction(XAResource xaRes) throws XAException {
        XidStatus status = this.xidMap.get(this.xaResourceMap.get(xaRes).xid);
        if (status == null) {
            throw new XAException("Resource[" + xaRes + "] not enlisted");
        }
        return status.getTransactionStatus().getTransaction();
    }

    synchronized void start(XAResource xaResource, Xid xid) throws XAException {
        ResourceTransaction tx = this.xaResourceMap.get(xaResource);
        if (tx == null) {
            this.createTransaction(xaResource);
            tx = this.xaResourceMap.get(xaResource);
        }
        if (this.xidMap.get(xid) == null) {
            int identifier = this.log.start(xid, this.txIdGenerator.getCurrentMasterId(), this.txIdGenerator.getMyId(), this.dataSource.getLastCommittedTxId());
            tx.xaTx.setIdentifier(identifier);
            this.xidMap.put(xid, new XidStatus(tx.xaTx));
            tx.xid = xid;
        }
    }

    synchronized void injectStart(Xid xid, XaTransaction tx) throws IOException {
        if (this.xidMap.get(xid) != null) {
            throw new IOException("Inject start failed, xid: " + xid + " already injected");
        }
        this.xidMap.put(xid, new XidStatus(tx));
        ++this.recoveredTxCount;
    }

    synchronized void resume(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (status.getActive()) {
            throw new XAException("Xid [" + xid + "] not suspended");
        }
        status.setActive(true);
    }

    synchronized void join(XAResource xaResource, Xid xid) throws XAException {
        if (this.xidMap.get(xid) == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (this.xaResourceMap.get(xaResource) != null) {
            throw new XAException("Resource[" + xaResource + "] already enlisted");
        }
        ResourceTransaction tx = new ResourceTransaction(null);
        tx.xid = xid;
        this.xaResourceMap.put(xaResource, tx);
    }

    synchronized void end(XAResource xaResource, Xid xid) throws XAException {
        if (this.xaResourceMap.remove(xaResource) == null) {
            throw new XAException("Resource[" + xaResource + "] not enlisted");
        }
    }

    synchronized void suspend(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (!status.getActive()) {
            throw new XAException("Xid[" + xid + "] already suspended");
        }
        status.setActive(false);
    }

    synchronized void fail(XAResource xaResource, Xid xid) throws XAException {
        XidStatus xidStatus = this.xidMap.get(xid);
        if (xidStatus == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (this.xaResourceMap.remove(xaResource) == null) {
            throw new XAException("Resource[" + xaResource + "] not enlisted");
        }
        xidStatus.getTransactionStatus().markAsRollback();
    }

    synchronized void validate(XAResource xaResource) throws XAException {
        ResourceTransaction tx = this.xaResourceMap.get(xaResource);
        XidStatus status = null;
        if (tx == null || (status = this.xidMap.get(tx.xid)) == null) {
            throw new XAException("Resource[" + xaResource + "] not enlisted");
        }
        if (!status.getActive()) {
            throw new XAException("Resource[" + xaResource + "] suspended");
        }
    }

    synchronized void destroy(XAResource xaResource) {
        this.xaResourceMap.remove(xaResource);
    }

    private void checkStartWritten(TransactionStatus status, XaTransaction tx) throws XAException {
        if (!status.startWritten() && !tx.isRecovered()) {
            this.log.writeStartEntry(tx.getIdentifier());
            status.markStartWritten();
        }
    }

    synchronized int prepare(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        this.checkStartWritten(txStatus, xaTransaction);
        if (xaTransaction.isReadOnly()) {
            this.commitKernelTx(xaTransaction);
            this.log.done(xaTransaction.getIdentifier());
            this.xidMap.remove(xid);
            if (xaTransaction.isRecovered()) {
                this.oneMoreTransactionRecovered();
            }
            return 3;
        }
        xaTransaction.prepare();
        this.log.prepare(xaTransaction.getIdentifier());
        txStatus.markAsPrepared();
        return 0;
    }

    private void oneMoreTransactionRecovered() {
        --this.recoveredTxCount;
        this.checkIfRecoveryComplete();
    }

    synchronized boolean injectPrepare(Xid xid) throws IOException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new IOException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        if (xaTransaction.isReadOnly()) {
            this.xidMap.remove(xid);
            if (xaTransaction.isRecovered()) {
                this.oneMoreTransactionRecovered();
            }
            return true;
        }
        txStatus.setSequenceNumber(this.nextTxOrder++);
        txStatus.markAsPrepared();
        return false;
    }

    synchronized void injectOnePhaseCommit(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        txStatus.setSequenceNumber(this.nextTxOrder++);
        txStatus.markAsPrepared();
        txStatus.markCommitStarted();
        XaTransaction xaTransaction = txStatus.getTransaction();
        xaTransaction.commit();
        this.transactionMonitor.injectOnePhaseCommit(xid);
    }

    synchronized void injectTwoPhaseCommit(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        txStatus.setSequenceNumber(this.nextTxOrder++);
        txStatus.markAsPrepared();
        txStatus.markCommitStarted();
        XaTransaction xaTransaction = txStatus.getTransaction();
        xaTransaction.commit();
        this.transactionMonitor.injectTwoPhaseCommit(xid);
    }

    synchronized XaTransaction getXaTransaction(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        return xaTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XaTransaction commit(Xid xid, boolean onePhase) throws XAException {
        boolean isReadOnly;
        XaTransaction xaTransaction;
        XaResourceManager xaResourceManager = this;
        synchronized (xaResourceManager) {
            XidStatus status = this.xidMap.get(xid);
            if (status == null) {
                throw new XAException("Unknown xid[" + xid + "]");
            }
            TransactionStatus txStatus = status.getTransactionStatus();
            xaTransaction = txStatus.getTransaction();
            TxIdGenerator txIdGenerator = xaTransaction.getTxIdGenerator();
            isReadOnly = xaTransaction.isReadOnly();
            if (isReadOnly) {
                this.commitReadTx(xid, onePhase, xaTransaction, txStatus);
            } else {
                this.commitWriteTx(xid, onePhase, xaTransaction, txStatus, txIdGenerator);
            }
        }
        this.commitKernelTx(xaTransaction);
        if (!xaTransaction.isRecovered() && !isReadOnly) {
            try {
                this.txIdGenerator.committed(this.dataSource, xaTransaction.getIdentifier(), xaTransaction.getCommitTxId(), null);
            }
            catch (Exception e) {
                throw new CommitNotificationFailedException(e);
            }
        }
        return xaTransaction;
    }

    private void commitReadTx(Xid xid, boolean onePhase, XaTransaction xaTransaction, TransactionStatus txStatus) throws XAException {
        if (onePhase) {
            txStatus.markAsPrepared();
        }
        if (!txStatus.prepared() || txStatus.rollback()) {
            throw new XAException("Transaction not prepared or (marked as) rolledbacked");
        }
        if (!xaTransaction.isRecovered()) {
            this.log.forget(xaTransaction.getIdentifier());
        }
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            this.oneMoreTransactionRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWriteTx(Xid xid, boolean onePhase, XaTransaction xaTransaction, TransactionStatus txStatus, TxIdGenerator txIdGenerator) throws XAException {
        long txId;
        this.checkStartWritten(txStatus, xaTransaction);
        if (onePhase) {
            txStatus.markAsPrepared();
            if (!xaTransaction.isRecovered()) {
                xaTransaction.prepare();
                txId = txIdGenerator.generate(this.dataSource, xaTransaction.getIdentifier());
                xaTransaction.setCommitTxId(txId);
                this.log.commitOnePhase(xaTransaction.getIdentifier(), xaTransaction.getCommitTxId(), this.getForceMode());
            }
        }
        if (!txStatus.prepared() || txStatus.rollback()) {
            throw new XAException("Transaction not prepared or (marked as) rolledbacked");
        }
        if (!onePhase && !xaTransaction.isRecovered()) {
            txId = txIdGenerator.generate(this.dataSource, xaTransaction.getIdentifier());
            xaTransaction.setCommitTxId(txId);
            this.log.commitTwoPhase(xaTransaction.getIdentifier(), xaTransaction.getCommitTxId(), this.getForceMode());
        }
        txStatus.markCommitStarted();
        if (xaTransaction.isRecovered() && xaTransaction.getCommitTxId() == -1L) {
            boolean previousRecoveredValue = this.dataSource.setRecovered(true);
            try {
                xaTransaction.setCommitTxId(this.dataSource.getLastCommittedTxId() + 1L);
            }
            finally {
                this.dataSource.setRecovered(previousRecoveredValue);
            }
        }
        xaTransaction.commit();
        if (!xaTransaction.isRecovered()) {
            this.log.done(xaTransaction.getIdentifier());
        } else if (!this.log.scanIsComplete() || this.recoveredTxCount > 0) {
            int identifier = xaTransaction.getIdentifier();
            LogEntry.Start startEntry = this.log.getStartEntry(identifier);
            this.recoveredTransactions.put(identifier, new TransactionInfo(identifier, onePhase, xaTransaction.getCommitTxId(), startEntry.getMasterId(), startEntry.getChecksum()));
        }
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            this.oneMoreTransactionRecovered();
        }
        this.transactionMonitor.transactionCommitted(xid, xaTransaction.isRecovered());
    }

    private ForceMode getForceMode() {
        return this.transactionManager.getForceMode();
    }

    synchronized XaTransaction rollback(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        this.checkStartWritten(txStatus, xaTransaction);
        if (txStatus.commitStarted()) {
            throw new XAException("Transaction already started commit");
        }
        txStatus.markAsRollback();
        xaTransaction.rollback();
        this.rollbackKernelTx(xaTransaction);
        this.log.done(xaTransaction.getIdentifier());
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            this.oneMoreTransactionRecovered();
        }
        return txStatus.getTransaction();
    }

    synchronized XaTransaction forget(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            return null;
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        if (!xaTransaction.isReadOnly()) {
            this.checkStartWritten(txStatus, xaTransaction);
            this.log.done(xaTransaction.getIdentifier());
        }
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            this.oneMoreTransactionRecovered();
        }
        return xaTransaction;
    }

    synchronized Xid[] recover(int flag) throws XAException {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        Iterator<Xid> keyIterator = this.xidMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            xids.add(keyIterator.next());
        }
        return xids.toArray(new Xid[xids.size()]);
    }

    synchronized void pruneXid(Xid xid) throws IOException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new IOException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            this.recoveredTransactions.remove(xaTransaction.getIdentifier());
            this.oneMoreTransactionRecovered();
        }
    }

    synchronized void checkXids() throws IOException {
        this.msgLog.logMessage("XaResourceManager[" + this.name + "] sorting " + this.xidMap.size() + " xids");
        Iterator<Xid> keyIterator = this.xidMap.keySet().iterator();
        LinkedList<Xid> xids = new LinkedList<Xid>();
        while (keyIterator.hasNext()) {
            xids.add(keyIterator.next());
        }
        Collections.sort(xids, new Comparator<Xid>(){

            @Override
            public int compare(Xid o1, Xid o2) {
                TransactionStatus a = ((XidStatus)XaResourceManager.this.xidMap.get(o1)).txStatus;
                TransactionStatus b = ((XidStatus)XaResourceManager.this.xidMap.get(o2)).txStatus;
                return a.compareTo(b);
            }
        });
        while (!xids.isEmpty()) {
            Xid xid = (Xid)xids.removeFirst();
            XidStatus status = this.xidMap.get(xid);
            TransactionStatus txStatus = status.getTransactionStatus();
            XaTransaction xaTransaction = txStatus.getTransaction();
            int identifier = xaTransaction.getIdentifier();
            if (!xaTransaction.isRecovered()) continue;
            if (txStatus.commitStarted()) {
                this.msgLog.debug("Marking 1PC [" + this.name + "] tx " + identifier + " as done");
                this.log.doneInternal(identifier);
                this.xidMap.remove(xid);
                --this.recoveredTxCount;
                continue;
            }
            if (!txStatus.prepared()) {
                this.msgLog.debug("Rolling back non prepared tx [" + this.name + "]" + "txIdent[" + identifier + "]");
                this.log.doneInternal(xaTransaction.getIdentifier());
                this.xidMap.remove(xid);
                --this.recoveredTxCount;
                continue;
            }
            this.msgLog.debug("2PC tx [" + this.name + "] " + txStatus + " txIdent[" + identifier + "]");
        }
        this.checkIfRecoveryComplete();
    }

    private void checkIfRecoveryComplete() {
        if (this.log.scanIsComplete() && this.recoveredTxCount == 0) {
            this.msgLog.logMessage("XaResourceManager[" + this.name + "] checkRecoveryComplete " + this.xidMap.size() + " xids");
            this.tf.recoveryComplete();
            try {
                for (TransactionInfo recoveredTx : this.sortByTxId(this.recoveredTransactions.values())) {
                    if (this.recoveryVerifier != null && !this.recoveryVerifier.isValid(recoveredTx)) {
                        throw new RecoveryVerificationException(recoveredTx.getIdentifier(), recoveredTx.getTxId());
                    }
                    if (!recoveredTx.isOnePhase()) {
                        this.log.commitTwoPhase(recoveredTx.getIdentifier(), recoveredTx.getTxId(), ForceMode.forced);
                    }
                    this.log.doneInternal(recoveredTx.getIdentifier());
                }
                this.recoveredTransactions.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (XAException e) {
                e.printStackTrace();
            }
            this.msgLog.logMessage("XaResourceManager[" + this.name + "] recovery completed.");
        }
    }

    private Iterable<TransactionInfo> sortByTxId(Collection<TransactionInfo> set) {
        ArrayList<TransactionInfo> list = new ArrayList<TransactionInfo>(set);
        Collections.sort(list);
        return list;
    }

    synchronized void reset() {
        this.xaResourceMap.clear();
        this.xidMap.clear();
        this.log.reset();
    }

    public boolean hasRecoveredTransactions() {
        return this.recoveredTxCount > 0;
    }

    public synchronized void applyCommittedTransaction(ReadableByteChannel transaction, long txId) throws IOException {
        long lastCommittedTxId = this.dataSource.getLastCommittedTxId();
        if (lastCommittedTxId + 1L == txId) {
            this.log.applyTransaction(transaction);
        } else if (lastCommittedTxId + 1L < txId) {
            throw new IOException("Tried to apply transaction with txId=" + txId + " but last committed txId=" + lastCommittedTxId);
        }
    }

    public synchronized long applyPreparedTransaction(ReadableByteChannel transaction) throws IOException {
        try {
            long txId = TxIdGenerator.DEFAULT.generate(this.dataSource, 0);
            this.log.applyTransactionWithoutTxId(transaction, txId, this.getForceMode());
            return txId;
        }
        catch (XAException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized long rotateLogicalLog() throws IOException {
        return this.log.rotate();
    }

    XaDataSource getDataSource() {
        return this.dataSource;
    }

    private void commitKernelTx(XaTransaction xaTransaction) throws XAException {
        if (!(xaTransaction instanceof NeoStoreTransaction)) {
            return;
        }
        try {
            NeoStoreTransaction neoStoreTransaction = (NeoStoreTransaction)xaTransaction;
            neoStoreTransaction.commitChangesToCache();
            neoStoreTransaction.kernelTransaction().commit();
        }
        catch (TransactionFailureException e) {
            throw e.unBoxedForCommit();
        }
    }

    private void rollbackKernelTx(XaTransaction xaTransaction) throws XAException {
        if (!(xaTransaction instanceof NeoStoreTransaction)) {
            return;
        }
        try {
            ((NeoStoreTransaction)xaTransaction).kernelTransaction().rollback();
        }
        catch (TransactionFailureException e) {
            throw e.unBoxedForCommit();
        }
    }

    private static class TransactionStatus
    implements Comparable<TransactionStatus> {
        private boolean prepared = false;
        private boolean commitStarted = false;
        private boolean rollback = false;
        private boolean startWritten = false;
        private final XaTransaction xaTransaction;
        private int sequenceNumber;

        TransactionStatus(XaTransaction xaTransaction) {
            this.xaTransaction = xaTransaction;
        }

        void markAsPrepared() {
            this.prepared = true;
        }

        void markAsRollback() {
            this.rollback = true;
        }

        void markCommitStarted() {
            this.commitStarted = true;
        }

        boolean prepared() {
            return this.prepared;
        }

        boolean rollback() {
            return this.rollback;
        }

        boolean commitStarted() {
            return this.commitStarted;
        }

        boolean startWritten() {
            return this.startWritten;
        }

        void markStartWritten() {
            this.startWritten = true;
        }

        XaTransaction getTransaction() {
            return this.xaTransaction;
        }

        public String toString() {
            return "TransactionStatus[" + this.xaTransaction.getIdentifier() + ", prepared=" + this.prepared + ", commitStarted=" + this.commitStarted + ", rolledback=" + this.rollback + "]";
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public int compareTo(TransactionStatus that) {
            return this.sequenceNumber > that.sequenceNumber ? 1 : (this.sequenceNumber < that.sequenceNumber ? -1 : 0);
        }
    }

    private static class XidStatus {
        private boolean active = true;
        private final TransactionStatus txStatus;

        XidStatus(XaTransaction xaTransaction) {
            this.txStatus = new TransactionStatus(xaTransaction);
        }

        void setActive(boolean active) {
            this.active = active;
        }

        boolean getActive() {
            return this.active;
        }

        TransactionStatus getTransactionStatus() {
            return this.txStatus;
        }
    }

    private static class ResourceTransaction {
        private Xid xid;
        private final XaTransaction xaTx;

        ResourceTransaction(XaTransaction xaTx) {
            this.xaTx = xaTx;
        }
    }
}

