/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;

public class StoreMigrator {
    private final MigrationProgressMonitor progressMonitor;

    public StoreMigrator(MigrationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void migrate(LegacyStore legacyStore, NeoStore neoStore) throws IOException {
        this.progressMonitor.started();
        new Migration(legacyStore, neoStore).migrate();
        this.progressMonitor.finished();
    }

    protected class Migration {
        private final LegacyStore legacyStore;
        private final NeoStore neoStore;
        private final long totalEntities;
        private int percentComplete;

        public Migration(LegacyStore legacyStore, NeoStore neoStore) {
            this.legacyStore = legacyStore;
            this.neoStore = neoStore;
            this.totalEntities = legacyStore.getNodeStoreReader().getMaxId();
        }

        private void migrate() throws IOException {
            this.migrateNeoStore(this.neoStore);
            this.migrateNodes(this.neoStore.getNodeStore());
            this.migratePropertyIndexes(this.neoStore.getPropertyStore());
            this.neoStore.close();
            this.legacyStore.close();
            this.legacyStore.copyRelationshipStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeTokenStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeTokenNameStore(this.neoStore);
            this.legacyStore.copyDynamicStringPropertyStore(this.neoStore);
            this.legacyStore.copyDynamicArrayPropertyStore(this.neoStore);
            this.legacyStore.copyLegacyIndexStoreFile(this.neoStore.getStorageFileName().getParentFile());
        }

        private void migratePropertyIndexes(PropertyStore propertyStore) throws IOException {
            Token[] tokens = this.legacyStore.getPropertyIndexReader().readTokens();
            Map<Integer, Integer> propertyKeyTranslation = this.dedupAndWritePropertyKeyTokenStore(propertyStore, tokens);
            this.migratePropertyStore(propertyKeyTranslation, propertyStore);
        }

        private void migrateNeoStore(NeoStore neoStore) throws IOException {
            this.legacyStore.copyNeoStore(neoStore);
            neoStore.setStoreVersion(NeoStore.versionStringToLong("v0.A.1"));
        }

        private Map<Integer, Integer> dedupAndWritePropertyKeyTokenStore(PropertyStore propertyStore, Token[] tokens) {
            PropertyKeyTokenStore keyTokenStore = propertyStore.getPropertyKeyTokenStore();
            HashMap<Integer, Integer> translations = new HashMap<Integer, Integer>();
            HashMap<String, Integer> createdTokens = new HashMap<String, Integer>();
            for (Token token : tokens) {
                Integer id = (Integer)createdTokens.get(token.name());
                if (id == null) {
                    id = (int)keyTokenStore.nextId();
                    PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
                    Collection<DynamicRecord> nameRecords = keyTokenStore.allocateNameRecords(UTF8.encode(token.name()));
                    record.setNameId((int)IteratorUtil.first(nameRecords).getId());
                    record.addNameRecords(nameRecords);
                    record.setInUse(true);
                    record.setCreated();
                    keyTokenStore.updateRecord(record);
                    createdTokens.put(token.name(), id);
                }
                translations.put(token.id(), id);
            }
            return translations;
        }

        private void migratePropertyStore(Map<Integer, Integer> propertyKeyTranslation, PropertyStore propertyStore) throws IOException {
            long lastInUseId = -1L;
            for (PropertyRecord propertyRecord : IteratorUtil.loop(this.legacyStore.getPropertyStoreReader().readPropertyStore())) {
                for (PropertyBlock block : propertyRecord.getPropertyBlocks()) {
                    int key = block.getKeyIndexId();
                    Integer translation = propertyKeyTranslation.get(key);
                    if (translation == null) continue;
                    block.setKeyIndexId(translation);
                }
                propertyStore.setHighId(propertyRecord.getId() + 1L);
                propertyStore.updateRecord(propertyRecord);
                for (long id = lastInUseId + 1L; id < propertyRecord.getId(); ++id) {
                    propertyStore.freeId(id);
                }
                lastInUseId = propertyRecord.getId();
            }
        }

        private void migrateNodes(NodeStore nodeStore) throws IOException {
            for (NodeRecord nodeRecord : IteratorUtil.loop(this.legacyStore.getNodeStoreReader().readNodeStore())) {
                this.reportProgress(nodeRecord.getId());
                nodeStore.setHighId(nodeRecord.getId() + 1L);
                if (nodeRecord.inUse()) {
                    nodeStore.updateRecord(nodeRecord);
                    continue;
                }
                nodeStore.freeId(nodeRecord.getId());
            }
            this.legacyStore.getNodeStoreReader().close();
        }

        private void reportProgress(long id) {
            int newPercent = (int)(id * 100L / this.totalEntities);
            if (newPercent > this.percentComplete) {
                this.percentComplete = newPercent;
                StoreMigrator.this.progressMonitor.percentComplete(this.percentComplete);
            }
        }
    }
}

