/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IdSequence;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreIdIterator;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public interface RecordStore<R extends AbstractBaseRecord>
extends IdSequence {
    public static final Predicate<AbstractBaseRecord> IN_USE = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean accept(AbstractBaseRecord item) {
            return item.inUse();
        }
    };

    public File getStorageFileName();

    public WindowPoolStats getWindowPoolStats();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public R getRecord(long var1);

    public Long getNextRecordReference(R var1);

    public Collection<R> getRecords(long var1);

    public void updateRecord(R var1);

    public R forceGetRecord(long var1);

    public R forceGetRaw(R var1);

    public R forceGetRaw(long var1);

    public void forceUpdateRecord(R var1);

    public <FAILURE extends Exception> void accept(Processor<FAILURE> var1, R var2) throws FAILURE;

    public int getRecordSize();

    public int getRecordHeaderSize();

    public void close();

    public static abstract class Processor<FAILURE extends Exception> {
        private volatile boolean continueScanning = true;

        public void stopScanning() {
            this.continueScanning = false;
        }

        public void processSchema(RecordStore<DynamicRecord> store, DynamicRecord schema) throws FAILURE {
            this.processRecord(DynamicRecord.class, store, schema);
        }

        public void processNode(RecordStore<NodeRecord> store, NodeRecord node) throws FAILURE {
            this.processRecord(NodeRecord.class, store, node);
        }

        public void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) throws FAILURE {
            this.processRecord(RelationshipRecord.class, store, rel);
        }

        public void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) throws FAILURE {
            this.processRecord(PropertyRecord.class, store, property);
        }

        public void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) throws FAILURE {
            this.processDynamic(store, string);
        }

        public void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) throws FAILURE {
            this.processDynamic(store, array);
        }

        public void processLabelArrayWithOwner(RecordStore<DynamicRecord> store, DynamicRecord labelArray) throws FAILURE {
            this.processDynamic(store, labelArray);
        }

        protected void processDynamic(RecordStore<DynamicRecord> store, DynamicRecord record) throws FAILURE {
            this.processRecord(DynamicRecord.class, store, record);
        }

        public void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord record) throws FAILURE {
            this.processRecord(RelationshipTypeTokenRecord.class, store, record);
        }

        public void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord record) throws FAILURE {
            this.processRecord(PropertyKeyTokenRecord.class, store, record);
        }

        public void processLabelToken(RecordStore<LabelTokenRecord> store, LabelTokenRecord record) throws FAILURE {
            this.processRecord(LabelTokenRecord.class, store, record);
        }

        protected <R extends AbstractBaseRecord> void processRecord(Class<R> type, RecordStore<R> store, R record) throws FAILURE {
            throw new UnsupportedOperationException(this + " does not process " + type.getSimpleName().replace("Record", "") + " records");
        }

        @SafeVarargs
        public final <R extends AbstractBaseRecord> Iterable<R> scan(final RecordStore<R> store, final Predicate<? super R> ... filters) {
            return new Iterable<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new PrefetchingIterator<R>(){
                        final PrimitiveLongIterator ids;
                        {
                            this.ids = new StoreIdIterator(store);
                        }

                        @Override
                        protected R fetchNextOrNull() {
                            block0: while (this.ids.hasNext() && Processor.this.continueScanning) {
                                Object record = Processor.this.getRecord(store, this.ids.next());
                                for (Predicate filter : filters) {
                                    if (!filter.accept(record)) continue block0;
                                }
                                return record;
                            }
                            return null;
                        }
                    };
                }
            };
        }

        protected <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id) {
            return store.forceGetRecord(id);
        }

        public static <R extends AbstractBaseRecord> Iterable<R> scanById(final RecordStore<R> store, Iterable<Long> ids) {
            return new IterableWrapper<R, Long>(ids){

                @Override
                protected R underlyingObjectToObject(Long id) {
                    return store.forceGetRecord(id);
                }
            };
        }

        public <R extends AbstractBaseRecord> void applyById(RecordStore<R> store, Iterable<Long> ids) throws FAILURE {
            for (AbstractBaseRecord record : Processor.scanById(store, ids)) {
                store.accept(this, record);
            }
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, ProgressListener.NONE, filters);
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, progressListener, filters);
        }

        private <R extends AbstractBaseRecord> void apply(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            for (AbstractBaseRecord record : this.scan(store, filters)) {
                store.accept(this, record);
                progressListener.set(record.getLongId());
            }
            progressListener.done();
        }
    }
}

