/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.MappedMemException;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

class MappedPersistenceWindow
extends LockableWindow {
    private long position = -1L;
    private Buffer buffer = null;
    private int windowSize = -1;
    private int recordSize = -1;
    private int totalSize = -1;
    private volatile int hashCode = 0;

    MappedPersistenceWindow(long position, int recordSize, int totalSize, StoreChannel channel, FileChannel.MapMode mapMode) {
        super(channel);
        assert (recordSize > 0) : "Record size[" + recordSize + "] must be greater then zero";
        assert (totalSize >= recordSize) : "Total size[" + totalSize + "] cannot be less than record size[" + recordSize + "]";
        assert (totalSize >= recordSize) : "Total size[" + totalSize + "] must mod to zero with record size[" + recordSize + "]";
        this.totalSize = totalSize;
        this.windowSize = totalSize / recordSize;
        this.recordSize = recordSize;
        this.position = position;
        try {
            this.buffer = new Buffer(this, channel.map(mapMode, position * (long)recordSize, totalSize));
        }
        catch (IOException e) {
            this.position = -1L;
            throw new MappedMemException("Unable to map pos=" + position + " recordSize=" + recordSize + " totalSize=" + totalSize, e);
        }
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public int size() {
        return this.windowSize;
    }

    @Override
    public void force() {
        ((MappedByteBuffer)this.buffer.getBuffer()).force();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MappedPersistenceWindow)) {
            return false;
        }
        return this.position() == ((MappedPersistenceWindow)o).position();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.position();
        }
        return this.hashCode;
    }

    public String toString() {
        return "MappedPersistenceWindow[p=" + this.position + ",rs=" + this.recordSize + ",ws=" + this.windowSize + ",ts=" + this.totalSize + "]";
    }

    @Override
    public synchronized void close() {
        this.buffer.close();
        this.position = -1L;
        this.closed = true;
    }

    @Override
    public Buffer getOffsettedBuffer(long id) {
        int offset = (int)(id - this.buffer.position()) * this.recordSize;
        try {
            this.buffer.setOffset(offset);
            return this.buffer;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to set offset. id:" + id + ", position:" + this.buffer.position() + ", recordSize:" + this.recordSize, e);
        }
    }
}

