/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.AbstractUniquenessFilter;
import org.neo4j.graphdb.traversal.PrimitiveTypeFetcher;
import org.neo4j.graphdb.traversal.TraversalBranch;

class LevelUnique
extends AbstractUniquenessFilter {
    private final Map<Integer, Set<Long>> idsPerLevel = new HashMap<Integer, Set<Long>>();

    LevelUnique(PrimitiveTypeFetcher type) {
        super(type);
    }

    @Override
    public boolean check(TraversalBranch branch) {
        Integer level = branch.length();
        Set<Long> levelIds = this.idsPerLevel.get(level);
        if (levelIds == null) {
            levelIds = new HashSet<Long>();
            this.idsPerLevel.put(level, levelIds);
        }
        return levelIds.add(this.type.getId(branch));
    }

    @Override
    public boolean checkFull(Path path) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

