/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class NodeRecord
extends PrimitiveRecord {
    private final long committedNextRel;
    private long nextRel;
    private long labels;
    private Collection<DynamicRecord> dynamicLabelRecords = Collections.emptyList();
    private boolean isLight = true;
    public static final Predicate<DynamicRecord> RECORD_IN_USE = new Predicate<DynamicRecord>(){

        @Override
        public boolean accept(DynamicRecord item) {
            return item.inUse();
        }
    };

    public NodeRecord(long id, long nextRel, long nextProp) {
        super(id, nextProp);
        this.committedNextRel = this.nextRel = nextRel;
    }

    public long getNextRel() {
        return this.nextRel;
    }

    public void setNextRel(long nextRel) {
        this.nextRel = nextRel;
    }

    public long getCommittedNextRel() {
        return this.isCreated() ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : this.committedNextRel;
    }

    public void setLabelField(long labels, Collection<DynamicRecord> dynamicRecords) {
        this.labels = labels;
        this.dynamicLabelRecords = dynamicRecords;
        this.isLight = dynamicRecords.isEmpty();
    }

    public long getLabelField() {
        return this.labels;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public Collection<DynamicRecord> getDynamicLabelRecords() {
        return this.dynamicLabelRecords;
    }

    public Iterable<DynamicRecord> getUsedDynamicLabelRecords() {
        return Iterables.filter(RECORD_IN_USE, this.dynamicLabelRecords);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Node[").append(this.getId()).append(",used=").append(this.inUse()).append(",rel=").append(this.nextRel).append(",prop=").append(this.getNextProp()).append(",labels=").append(NodeLabelsField.parseLabelsField(this)).append(",").append(this.isLight ? "light" : "heavy");
        if (!this.isLight && !this.dynamicLabelRecords.isEmpty()) {
            builder.append(",dynlabels=").append(this.dynamicLabelRecords);
        }
        return builder.append("]").toString();
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setNodeId(this.getId());
    }

    @Override
    public NodeRecord clone() {
        NodeRecord clone = new NodeRecord(this.getId(), this.getCommittedNextRel(), this.getCommittedNextProp());
        clone.setNextProp(this.getNextProp());
        clone.nextRel = this.nextRel;
        clone.labels = this.labels;
        clone.isLight = this.isLight;
        clone.setInUse(this.inUse());
        if (this.dynamicLabelRecords.size() > 0) {
            ArrayList<DynamicRecord> clonedLabelRecords = new ArrayList<DynamicRecord>(this.dynamicLabelRecords.size());
            for (DynamicRecord labelRecord : this.dynamicLabelRecords) {
                clonedLabelRecords.add(labelRecord.clone());
            }
            clone.dynamicLabelRecords = clonedLabelRecords;
        }
        return clone;
    }
}

