/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.FunctionFromPrimitiveLong;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.coreapi.schema.BaseConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.PropertyUniqueConstraintDefinition;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.nioneo.xa.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreProvider;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.BatchTokenHolder;

public class BatchInserterImpl
implements BatchInserter {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private final LifeSupport life;
    private final NeoStore neoStore;
    private final IndexStore indexStore;
    private final File storeDir;
    private final BatchTokenHolder propertyKeyTokens;
    private final BatchTokenHolder relationshipTypeTokens;
    private final BatchTokenHolder labelTokens;
    private final IdGeneratorFactory idGeneratorFactory;
    private final SchemaIndexProviderMap schemaIndexProviders;
    private final LabelScanStore labelScanStore;
    private final StringLogger msgLog;
    private final Logging logging;
    private final FileSystemAbstraction fileSystem;
    private final SchemaCache schemaCache;
    private final Config config;
    private final BatchSchemaActions actions;
    private final StoreLocker storeLocker;
    private final FunctionFromPrimitiveLong<Label> labelIdToLabelFunction = new FunctionFromPrimitiveLong<Label>(){

        @Override
        public Label apply(long from) {
            return DynamicLabel.label(BatchInserterImpl.this.labelTokens.nameOf(IoPrimitiveUtils.safeCastLongToInt(from)));
        }
    };
    private boolean isShutdown = false;
    private Set<PropertyRecord> updatedRecords = new HashSet<PropertyRecord>();

    BatchInserterImpl(String storeDir, Map<String, String> stringParams) {
        this(storeDir, new DefaultFileSystemAbstraction(), stringParams, Collections.emptyList());
    }

    BatchInserterImpl(String storeDir, FileSystemAbstraction fileSystem, Map<String, String> stringParams, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this.life = new LifeSupport();
        this.fileSystem = fileSystem;
        this.storeDir = new File(FileUtils.fixSeparatorsInPath(storeDir));
        this.rejectAutoUpgrade(stringParams);
        this.msgLog = StringLogger.loggerDirectory(fileSystem, this.storeDir);
        this.logging = new SingleLoggingService(this.msgLog);
        Map<String, String> params = this.getDefaultParams();
        params.put(GraphDatabaseSettings.use_memory_mapped_buffers.name(), "false");
        params.put(InternalAbstractGraphDatabase.Configuration.store_dir.name(), storeDir);
        params.putAll(stringParams);
        this.storeLocker = new StoreLocker(fileSystem);
        this.storeLocker.checkLock(this.storeDir);
        this.config = new Config(params, GraphDatabaseSettings.class);
        boolean dump = this.config.get(GraphDatabaseSettings.dump_configuration);
        this.idGeneratorFactory = new DefaultIdGeneratorFactory();
        StoreFactory sf = new StoreFactory(this.config, this.idGeneratorFactory, new DefaultWindowPoolFactory(), fileSystem, this.msgLog, null);
        File store = this.fixPath(this.storeDir, sf);
        if (dump) {
            this.dumpConfiguration(params);
        }
        this.msgLog.logMessage(Thread.currentThread() + " Starting BatchInserter(" + this + ")");
        this.neoStore = sf.newNeoStore(store);
        if (!this.neoStore.isStoreOk()) {
            throw new IllegalStateException(storeDir + " store is not cleanly shutdown.");
        }
        this.neoStore.makeStoreOk();
        Token[] indexes = this.getPropertyKeyTokenStore().getTokens(10000);
        this.propertyKeyTokens = new BatchTokenHolder(indexes);
        this.labelTokens = new BatchTokenHolder(this.neoStore.getLabelTokenStore().getTokens(Integer.MAX_VALUE));
        Token[] types = this.getRelationshipTypeStore().getTokens(Integer.MAX_VALUE);
        this.relationshipTypeTokens = new BatchTokenHolder(types);
        this.indexStore = this.life.add(new IndexStore(this.storeDir, fileSystem));
        this.schemaCache = new SchemaCache(this.neoStore.getSchemaStore());
        KernelExtensions extensions = this.life.add(new KernelExtensions(kernelExtensions, this.config, new DependencyResolverImpl(), UnsatisfiedDependencyStrategies.ignore()));
        this.life.start();
        SchemaIndexProvider provider = extensions.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        this.schemaIndexProviders = new DefaultSchemaIndexProviderMap(provider);
        this.labelScanStore = this.life.add(extensions.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
        this.actions = new BatchSchemaActions();
    }

    private Map<String, String> getDefaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("neostore.nodestore.db.mapped_memory", "20M");
        params.put("neostore.propertystore.db.mapped_memory", "90M");
        params.put("neostore.propertystore.db.index.mapped_memory", "1M");
        params.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        params.put("neostore.propertystore.db.strings.mapped_memory", "130M");
        params.put("neostore.propertystore.db.arrays.mapped_memory", "130M");
        params.put("neostore.relationshipstore.db.mapped_memory", "50M");
        return params;
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty(this.getNodeRecord(node), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty(this.getRelationshipRecord(relationship), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object newValue) {
        NodeRecord nodeRec = this.getNodeRecord(node);
        if (this.setPrimitiveProperty(nodeRec, propertyName, newValue)) {
            this.getNodeStore().updateRecord(nodeRec);
        }
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RelationshipRecord relRec = this.getRelationshipRecord(relationship);
        if (this.setPrimitiveProperty(relRec, propertyName, propertyValue)) {
            this.getRelationshipStore().updateRecord(relRec);
        }
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        NodeRecord nodeRec = this.getNodeRecord(node);
        if (this.removePrimitiveProperty(nodeRec, propertyName)) {
            this.getNodeStore().updateRecord(nodeRec);
        }
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        RelationshipRecord relationshipRec = this.getRelationshipRecord(relationship);
        if (this.removePrimitiveProperty(relationshipRec, propertyName)) {
            this.getRelationshipStore().updateRecord(relationshipRec);
        }
    }

    @Override
    public IndexCreator createDeferredSchemaIndex(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    private void createIndexRule(Label label, String propertyKey) {
        SchemaStore schemaStore = this.getSchemaStore();
        IndexRule schemaRule = IndexRule.indexRule(schemaStore.nextId(), this.getOrCreateLabelId(label.name()), this.getOrCreatePropertyKeyId(propertyKey), this.schemaIndexProviders.getDefaultProvider().getProviderDescriptor());
        for (DynamicRecord record : schemaStore.allocateFrom(schemaRule)) {
            schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(schemaRule);
    }

    private void repopulateAllIndexes() throws IOException {
        final IndexRule[] rules = this.getIndexesNeedingPopulation();
        final IndexPopulator[] populators = new IndexPopulator[rules.length];
        ReentrantLockService locks = new ReentrantLockService();
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(locks, this.neoStore);
        final int[] labelIds = new int[rules.length];
        final int[] propertyKeyIds = new int[rules.length];
        for (int i = 0; i < labelIds.length; ++i) {
            IndexRule rule = rules[i];
            labelIds[i] = rule.getLabel();
            propertyKeyIds[i] = rule.getPropertyKey();
            populators[i] = this.schemaIndexProviders.apply(rule.getProviderDescriptor()).getPopulator(rule.getId(), new IndexConfiguration(rule.isConstraintIndex()));
            populators[i].create();
        }
        Visitor<NodePropertyUpdate, IOException> propertyUpdateVisitor = new Visitor<NodePropertyUpdate, IOException>(){

            @Override
            public boolean visit(NodePropertyUpdate update) throws IOException {
                int propertyKeyInQuestion = update.getPropertyKeyId();
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    if (propertyKeyIds[i] != propertyKeyInQuestion || !update.forLabel(labelIds[i])) continue;
                    try {
                        populators[i].add(update.getNodeId(), update.getValueAfter());
                        continue;
                    }
                    catch (IndexEntryConflictException conflict) {
                        throw conflict.notAllowed(rules[i].getLabel(), rules[i].getPropertyKey());
                    }
                }
                return true;
            }
        };
        NodeLabelUpdateVisitor labelUpdateVisitor = new NodeLabelUpdateVisitor();
        StoreScan<IOException> storeScan = storeView.visitNodes(labelIds, propertyKeyIds, propertyUpdateVisitor, labelUpdateVisitor);
        storeScan.run();
        for (IndexPopulator populator : populators) {
            populator.close(true);
        }
        labelUpdateVisitor.close();
    }

    private IndexRule[] getIndexesNeedingPopulation() {
        ArrayList<IndexRule> indexesNeedingPopulation = new ArrayList<IndexRule>();
        for (SchemaRule rule : this.schemaCache.schemaRules()) {
            IndexRule indexRule;
            SchemaIndexProvider provider;
            if (!rule.getKind().isIndex() || (provider = this.schemaIndexProviders.apply((indexRule = (IndexRule)rule).getProviderDescriptor())).getInitialState(indexRule.getId()) == InternalIndexState.FAILED) continue;
            indexesNeedingPopulation.add(indexRule);
        }
        return indexesNeedingPopulation.toArray(new IndexRule[indexesNeedingPopulation.size()]);
    }

    @Override
    public ConstraintCreator createDeferredConstraint(Label label) {
        return new BaseConstraintCreator(new BatchSchemaActions(), label);
    }

    private void createConstraintRule(UniquenessConstraint constraint) {
        SchemaStore schemaStore = this.getSchemaStore();
        long indexRuleId = schemaStore.nextId();
        long constraintRuleId = schemaStore.nextId();
        IndexRule indexRule = IndexRule.constraintIndexRule(indexRuleId, constraint.label(), constraint.propertyKeyId(), this.schemaIndexProviders.getDefaultProvider().getProviderDescriptor(), constraintRuleId);
        UniquenessConstraintRule constraintRule = UniquenessConstraintRule.uniquenessConstraintRule(schemaStore.nextId(), constraint.label(), constraint.propertyKeyId(), indexRuleId);
        for (DynamicRecord record : schemaStore.allocateFrom(constraintRule)) {
            schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(constraintRule);
        for (DynamicRecord record : schemaStore.allocateFrom(indexRule)) {
            schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(indexRule);
    }

    private boolean removePrimitiveProperty(PrimitiveRecord primitive, String property) {
        PropertyRecord current = null;
        long nextProp = primitive.getNextProp();
        int propIndex = this.propertyKeyTokens.idOf(property);
        if (nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() || propIndex == -1) {
            return false;
        }
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            current = this.getPropertyStore().getRecord(nextProp);
            PropertyBlock target = current.removePropertyBlock(propIndex);
            if (target != null) {
                this.getPropertyStore().ensureHeavy(target);
                for (DynamicRecord dynRec : target.getValueRecords()) {
                    dynRec.setInUse(false);
                    current.addDeletedRecord(dynRec);
                }
                break;
            }
            nextProp = current.getNextProp();
        }
        assert (current != null) : "the if statement above prevents it";
        if (current.size() > 0) {
            this.getPropertyStore().updateRecord(current);
            return false;
        }
        current.setInUse(false);
        return this.unlinkPropertyRecord(current, primitive);
    }

    private boolean unlinkPropertyRecord(PropertyRecord propRecord, PrimitiveRecord primitive) {
        assert (propRecord.size() == 0);
        boolean primitiveChanged = false;
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            primitive.setNextProp(nextProp);
            primitiveChanged = true;
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.getPropertyStore().getRecord(prevProp);
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            this.getPropertyStore().updateRecord(prevPropRecord);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.getPropertyStore().getRecord(nextProp);
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            this.getPropertyStore().updateRecord(nextPropRecord);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        this.getPropertyStore().updateRecord(propRecord);
        return primitiveChanged;
    }

    private boolean setPrimitiveProperty(PrimitiveRecord primitive, String name, Object value) {
        PropertyBlock removed;
        boolean result = false;
        long nextProp = primitive.getNextProp();
        int index = this.getOrCreatePropertyKeyId(name);
        PropertyBlock block = new PropertyBlock();
        this.getPropertyStore().encodeValue(block, index, value);
        int size = block.getSize();
        PropertyRecord current = null;
        PropertyRecord thatFits = null;
        PropertyRecord thatHas = null;
        this.updatedRecords.clear();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue() && (thatHas == null || thatFits == null)) {
            current = this.getPropertyStore().getRecord(nextProp);
            if (thatHas == null && current.getPropertyBlock(index) != null) {
                thatHas = current;
                removed = thatHas.removePropertyBlock(index);
                if (removed.isLight()) {
                    this.getPropertyStore().makeHeavyIfLight(removed);
                }
                for (DynamicRecord dynRec : removed.getValueRecords()) {
                    dynRec.setInUse(false);
                    thatHas.addDeletedRecord(dynRec);
                }
                this.updatedRecords.add(thatHas);
            }
            if (thatFits == null && PropertyType.getPayloadSize() - current.size() >= size) {
                thatFits = current;
            }
            nextProp = current.getNextProp();
        }
        if (thatHas != null && thatFits != thatHas) {
            removed = thatHas.removePropertyBlock(index);
            this.getPropertyStore().ensureHeavy(removed);
            for (DynamicRecord dynRec : removed.getValueRecords()) {
                dynRec.setInUse(false);
                thatHas.addDeletedRecord(dynRec);
            }
            this.getPropertyStore().updateRecord(thatHas);
        }
        if (thatFits == null) {
            thatFits = new PropertyRecord(this.getPropertyStore().nextId());
            thatFits.setInUse(true);
            result = true;
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord first = this.getPropertyStore().getRecord(primitive.getNextProp());
                thatFits.setNextProp(first.getId());
                first.setPrevProp(thatFits.getId());
                this.getPropertyStore().updateRecord(first);
            }
            primitive.setNextProp(thatFits.getId());
        }
        thatFits.addPropertyBlock(block);
        this.updatedRecords.add(thatFits);
        for (PropertyRecord updatedRecord : this.updatedRecords) {
            this.getPropertyStore().updateRecord(thatFits);
        }
        return result;
    }

    private int getOrCreatePropertyKeyId(String name) {
        int propertyKeyId = this.getPropertyKeyId(name);
        if (propertyKeyId == -1) {
            propertyKeyId = this.createNewPropertyKeyId(name);
        }
        return propertyKeyId;
    }

    private int getPropertyKeyId(String name) {
        return this.propertyKeyTokens.idOf(name);
    }

    private int getOrCreateLabelId(String name) {
        int labelId = this.getLabelId(name);
        if (labelId == -1) {
            labelId = this.createNewLabelId(name);
        }
        return labelId;
    }

    private int getLabelId(String name) {
        return this.labelTokens.idOf(name);
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        long nextProp = record.getNextProp();
        int propertyKeyId = this.propertyKeyTokens.idOf(propertyName);
        if (nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() || propertyKeyId == -1) {
            return false;
        }
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord current = this.getPropertyStore().getRecord(nextProp);
            if (current.getPropertyBlock(propertyKeyId) != null) {
                return true;
            }
            nextProp = current.getNextProp();
        }
        return false;
    }

    private void rejectAutoUpgrade(Map<String, String> params) {
        if (Boolean.parseBoolean(params.get(GraphDatabaseSettings.allow_store_upgrade.name()))) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store, use " + EmbeddedGraphDatabase.class.getSimpleName() + " instead");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.internalCreateNode(this.getNodeStore().nextId(), properties, labels);
    }

    private long internalCreateNode(long nodeId, Map<String, Object> properties, Label ... labels) {
        NodeRecord nodeRecord = new NodeRecord(nodeId, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.createPropertyChain(properties));
        this.setNodeLabels(nodeRecord, labels);
        this.getNodeStore().updateRecord(nodeRecord);
        return nodeId;
    }

    private void setNodeLabels(NodeRecord nodeRecord, Label ... labels) {
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField(nodeRecord);
        this.getNodeStore().updateDynamicLabelRecords(nodeLabels.put(this.getOrCreateLabelIds(labels), this.getNodeStore()));
    }

    private long[] getOrCreateLabelIds(Label[] labels) {
        long[] ids = new long[labels.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.getOrCreateLabelId(labels[i].name());
        }
        return ids;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new IllegalArgumentException("id=" + id);
        }
        if (id == 0xFFFFFFFFL) {
            throw new IllegalArgumentException("id " + id + " is reserved for internal use");
        }
        NodeStore nodeStore = this.neoStore.getNodeStore();
        if (this.neoStore.getNodeStore().loadLightNode(id) != null) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = nodeStore.getHighId();
        if (highId <= id) {
            nodeStore.setHighId(id + 1L);
        }
        this.internalCreateNode(id, properties, labels);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        NodeRecord record = this.getNodeRecord(node);
        this.setNodeLabels(record, labels);
        this.getNodeStore().updateRecord(record);
    }

    @Override
    public Iterable<Label> getNodeLabels(final long node) {
        return new Iterable<Label>(){

            @Override
            public Iterator<Label> iterator() {
                NodeStore nodeStore = BatchInserterImpl.this.neoStore.getNodeStore();
                long[] labels = NodeLabelsField.parseLabelsField(nodeStore.getRecord(node)).get(BatchInserterImpl.this.getNodeStore());
                return Iterables.map(BatchInserterImpl.this.labelIdToLabelFunction, IteratorUtil.asPrimitiveIterator(labels));
            }
        };
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        int labelId = this.getLabelId(label.name());
        return labelId != -1 && this.nodeHasLabel(node, labelId);
    }

    private boolean nodeHasLabel(long node, int labelId) {
        NodeStore nodeStore = this.neoStore.getNodeStore();
        for (long label : NodeLabelsField.parseLabelsField(nodeStore.getRecord(node)).get(this.getNodeStore())) {
            if (label != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        NodeRecord firstNode = this.getNodeRecord(node1);
        NodeRecord secondNode = this.getNodeRecord(node2);
        int typeId = this.relationshipTypeTokens.idOf(type.name());
        if (typeId == -1) {
            typeId = this.createNewRelationshipType(type.name());
        }
        long id = this.getRelationshipStore().nextId();
        RelationshipRecord record = new RelationshipRecord(id, node1, node2, typeId);
        record.setInUse(true);
        record.setCreated();
        this.connectRelationship(firstNode, secondNode, record);
        this.getNodeStore().updateRecord(firstNode);
        this.getNodeStore().updateRecord(secondNode);
        record.setNextProp(this.createPropertyChain(properties));
        this.getRelationshipStore().updateRecord(record);
        return id;
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel) {
        assert (firstNode.getNextRel() != rel.getId());
        assert (secondNode.getNextRel() != rel.getId());
        rel.setFirstNextRel(firstNode.getNextRel());
        rel.setSecondNextRel(secondNode.getNextRel());
        this.connect(firstNode, rel);
        this.connect(secondNode, rel);
        firstNode.setNextRel(rel.getId());
        secondNode.setNextRel(rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel) {
        if (node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord nextRel = this.getRelationshipStore().getRecord(node.getNextRel());
            boolean changed = false;
            if (nextRel.getFirstNode() == node.getId()) {
                nextRel.setFirstPrevRel(rel.getId());
                changed = true;
            }
            if (nextRel.getSecondNode() == node.getId()) {
                nextRel.setSecondPrevRel(rel.getId());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(node + " dont match " + nextRel);
            }
            this.getRelationshipStore().updateRecord(nextRel);
        }
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = this.getNodeRecord(node);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.deletePropertyChain(record.getNextProp());
            record.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
            this.getNodeStore().updateRecord(record);
        }
        record.setNextProp(this.createPropertyChain(properties));
        this.getNodeStore().updateRecord(record);
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = this.getRelationshipRecord(rel);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.deletePropertyChain(record.getNextProp());
            record.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
            this.getRelationshipStore().updateRecord(record);
        }
        record.setNextProp(this.createPropertyChain(properties));
        this.getRelationshipStore().updateRecord(record);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        return this.neoStore.getNodeStore().loadLightNode(nodeId) != null;
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = this.getNodeRecord(nodeId);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        long nextRel = nodeRecord.getNextRel();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (nextRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord relRecord = this.getRelationshipRecord(nextRel);
            ids.add(relRecord.getId());
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (firstNode == nodeId) {
                nextRel = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                nextRel = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] not part of firstNode[" + firstNode + "] or secondNode[" + secondNode + "]");
        }
        return ids;
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        long nextRel = nodeRecord.getNextRel();
        ArrayList<BatchRelationship> rels = new ArrayList<BatchRelationship>();
        while (nextRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord relRecord = this.getRelationshipRecord(nextRel);
            RelationshipTypeImpl type = new RelationshipTypeImpl(this.relationshipTypeTokens.nameOf(relRecord.getType()));
            rels.add(new BatchRelationship(relRecord.getId(), relRecord.getFirstNode(), relRecord.getSecondNode(), type));
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (firstNode == nodeId) {
                nextRel = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                nextRel = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] not part of firstNode[" + firstNode + "] or secondNode[" + secondNode + "]");
        }
        return rels;
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId);
        RelationshipTypeImpl type = new RelationshipTypeImpl(this.relationshipTypeTokens.nameOf(record.getType()));
        return new BatchRelationship(record.getId(), record.getFirstNode(), record.getSecondNode(), type);
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Batch inserter already has shutdown");
        }
        this.isShutdown = true;
        try {
            this.repopulateAllIndexes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.neoStore.close();
        try {
            this.storeLocker.release();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Could not release store lock", e);
        }
        this.msgLog.logMessage(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")", true);
        this.msgLog.close();
        this.life.shutdown();
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + this.storeDir + "]";
    }

    private long createPropertyChain(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return Record.NO_NEXT_PROPERTY.intValue();
        }
        PropertyStore propStore = this.getPropertyStore();
        ArrayList<PropertyRecord> propRecords = new ArrayList<PropertyRecord>();
        PropertyRecord currentRecord = new PropertyRecord(propStore.nextId());
        currentRecord.setInUse(true);
        currentRecord.setCreated();
        propRecords.add(currentRecord);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            int keyId = this.propertyKeyTokens.idOf(entry.getKey());
            if (keyId == -1) {
                keyId = this.createNewPropertyKeyId(entry.getKey());
            }
            PropertyBlock block = new PropertyBlock();
            propStore.encodeValue(block, keyId, entry.getValue());
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                PropertyRecord prevRecord = currentRecord;
                long propertyId = propStore.nextId();
                currentRecord = new PropertyRecord(propertyId);
                currentRecord.setInUse(true);
                currentRecord.setCreated();
                prevRecord.setNextProp(propertyId);
                currentRecord.setPrevProp(prevRecord.getId());
                propRecords.add(currentRecord);
            }
            currentRecord.addPropertyBlock(block);
        }
        for (int i = propRecords.size() - 1; i >= 0; --i) {
            propStore.updateRecord((PropertyRecord)propRecords.get(i));
        }
        return ((PropertyRecord)propRecords.get(0)).getId();
    }

    private void deletePropertyChain(long nextProp) {
        PropertyStore propStore = this.getPropertyStore();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propStore.getRecord(nextProp);
            for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                propStore.ensureHeavy(propBlock);
                for (DynamicRecord rec : propBlock.getValueRecords()) {
                    rec.setInUse(false);
                    propRecord.addDeletedRecord(rec);
                }
            }
            propRecord.setInUse(false);
            nextProp = propRecord.getNextProp();
            propStore.updateRecord(propRecord);
        }
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        PropertyStore propStore = this.getPropertyStore();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propStore.getRecord(nextProp);
            for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                String key = this.propertyKeyTokens.nameOf(propBlock.getKeyIndexId());
                DefinedProperty propertyData = propBlock.newPropertyData(propStore);
                Object value = propertyData.value() != null ? propertyData.value() : propBlock.getType().getValue(propBlock, this.getPropertyStore());
                properties.put(key, value);
            }
            nextProp = propRecord.getNextProp();
        }
        return properties;
    }

    private int createNewPropertyKeyId(String stringKey) {
        PropertyKeyTokenStore idxStore = this.getPropertyKeyTokenStore();
        int keyId = (int)idxStore.nextId();
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = idxStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)IteratorUtil.first(keyRecords).getId());
        record.addNameRecords(keyRecords);
        idxStore.updateRecord(record);
        this.propertyKeyTokens.addToken(stringKey, keyId);
        return keyId;
    }

    private int createNewLabelId(String stringKey) {
        LabelTokenStore labelTokenStore = this.neoStore.getLabelTokenStore();
        int keyId = (int)labelTokenStore.nextId();
        LabelTokenRecord record = new LabelTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = labelTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)IteratorUtil.first(keyRecords).getId());
        record.addNameRecords(keyRecords);
        labelTokenStore.updateRecord(record);
        this.labelTokens.addToken(stringKey, keyId);
        return keyId;
    }

    private int createNewRelationshipType(String name) {
        RelationshipTypeTokenStore typeStore = this.getRelationshipTypeStore();
        int id = (int)typeStore.nextId();
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = typeStore.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)IteratorUtil.first(nameRecords).getId());
        record.addNameRecords(nameRecords);
        typeStore.updateRecord(record);
        this.relationshipTypeTokens.addToken(name, id);
        return id;
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    private PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.getPropertyStore().getPropertyKeyTokenStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private RelationshipTypeTokenStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private SchemaStore getSchemaStore() {
        return this.neoStore.getSchemaStore();
    }

    private NodeRecord getNodeRecord(long id) {
        if (id < 0L || id >= this.getNodeStore().getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.getNodeStore().getRecord(id);
    }

    private RelationshipRecord getRelationshipRecord(long id) {
        if (id < 0L || id >= this.getRelationshipStore().getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.getRelationshipStore().getRecord(id);
    }

    private File fixPath(File dir, StoreFactory sf) {
        try {
            this.fileSystem.mkdirs(dir);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create directory path[" + this.storeDir + "] for Neo4j kernel store.");
        }
        File store = new File(dir, "neostore");
        if (!this.fileSystem.fileExists(store)) {
            sf.createNeoStore(store).close();
        }
        return store;
    }

    @Override
    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    private void dumpConfiguration(Map<String, String> config) {
        for (String key : config.keySet()) {
            String value = config.get(key);
            if (value == null) continue;
            System.out.println(key + "=" + value);
        }
    }

    private class DependencyResolverImpl
    extends DependencyResolver.Adapter {
        private DependencyResolverImpl() {
        }

        @Override
        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
            if (type.isInstance(BatchInserterImpl.this.fileSystem)) {
                return type.cast(BatchInserterImpl.this.fileSystem);
            }
            if (type.isInstance(BatchInserterImpl.this.config)) {
                return type.cast(BatchInserterImpl.this.config);
            }
            if (type.isInstance(BatchInserterImpl.this.logging)) {
                return type.cast(BatchInserterImpl.this.logging);
            }
            if (NeoStoreProvider.class.isAssignableFrom(type)) {
                return type.cast(new NeoStoreProvider(){

                    @Override
                    public NeoStore evaluate() {
                        return BatchInserterImpl.this.neoStore;
                    }
                });
            }
            throw new IllegalArgumentException("Unknown dependency " + type);
        }
    }

    private class BatchSchemaActions
    implements InternalSchemaActions {
        private BatchSchemaActions() {
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            BatchInserterImpl.this.createIndexRule(label, propertyKey);
            return new IndexDefinitionImpl(this, label, propertyKey, false);
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.createConstraintRule(new UniquenessConstraint(labelId, propertyKeyId));
            return new PropertyUniqueConstraintDefinition(this, label, propertyKey);
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public String getUserMessage(KernelException e) {
            throw this.unsupportedException();
        }

        @Override
        public void assertInTransaction() {
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Batch inserter doesn't support this");
        }
    }

    private static class RelationshipTypeImpl
    implements RelationshipType {
        private final String name;

        RelationshipTypeImpl(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    private class NodeLabelUpdateVisitor
    implements Visitor<NodeLabelUpdate, IOException> {
        private final NodeLabelUpdate[] updateBatch = new NodeLabelUpdate[10000];
        private int cursor;

        private NodeLabelUpdateVisitor() {
        }

        @Override
        public boolean visit(NodeLabelUpdate update) throws IOException {
            if (this.cursor >= this.updateBatch.length) {
                this.writeAndResetBatch();
            }
            this.updateBatch[this.cursor++] = update;
            return true;
        }

        private void writeAndResetBatch() throws IOException {
            BatchInserterImpl.this.labelScanStore.updateAndCommit(IteratorUtil.iterator(this.cursor, this.updateBatch));
            this.cursor = 0;
        }

        void close() throws IOException {
            this.writeAndResetBatch();
        }
    }
}

