/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.persistence;

import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.persistence.ResourceAcquisitionFailedException;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.StringLogger;

public class PersistenceManager {
    private final PersistenceSource persistenceSource;
    private final StringLogger msgLog;
    private final AbstractTransactionManager transactionManager;
    private final ArrayMap<Transaction, NeoStoreTransaction> txConnectionMap = new ArrayMap(5, true, true);
    private final TxEventSyncHookFactory syncHookFactory;

    public PersistenceManager(StringLogger msgLog, AbstractTransactionManager transactionManager, PersistenceSource persistenceSource, TxEventSyncHookFactory syncHookFactory) {
        this.msgLog = msgLog;
        this.transactionManager = transactionManager;
        this.persistenceSource = persistenceSource;
        this.syncHookFactory = syncHookFactory;
    }

    public KernelTransaction currentKernelTransaction() {
        return this.getResource().kernelTransaction();
    }

    public void ensureKernelIsEnlisted() {
        this.getResource();
    }

    public NodeRecord loadLightNode(long id) {
        return this.getResource().nodeLoadLight(id);
    }

    public long getRelationshipChainPosition(long nodeId) {
        return this.getResource().getRelationshipChainPosition(nodeId);
    }

    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return this.getResource().getMoreRelationships(nodeId, position);
    }

    public void loadNodeProperties(long nodeId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        this.getResource().nodeLoadProperties(nodeId, light, receiver);
    }

    public void loadRelProperties(long relId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        this.getResource().relLoadProperties(relId, light, receiver);
    }

    public RelationshipRecord loadLightRelationship(long id) {
        return this.getResource().relLoadLight(id);
    }

    public ArrayMap<Integer, DefinedProperty> nodeDelete(long nodeId) {
        return this.getResource().nodeDelete(nodeId);
    }

    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        return this.getResource().nodeAddProperty(nodeId, propertyKey, value);
    }

    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        return this.getResource().nodeChangeProperty(nodeId, propertyKey, value);
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        this.getResource().nodeRemoveProperty(nodeId, propertyKey);
    }

    public void nodeCreate(long id) {
        this.getResource().nodeCreate(id);
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.getResource().relationshipCreate(id, typeId, startNodeId, endNodeId);
    }

    public ArrayMap<Integer, DefinedProperty> relDelete(long relId) {
        return this.getResource().relDelete(relId);
    }

    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        return this.getResource().relAddProperty(relId, propertyKey, value);
    }

    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        return this.getResource().relChangeProperty(relId, propertyKey, value);
    }

    public void relRemoveProperty(long relId, int propertyKey) {
        this.getResource().relRemoveProperty(relId, propertyKey);
    }

    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        return this.getResource().graphAddProperty(propertyKey, value);
    }

    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        return this.getResource().graphChangeProperty(propertyKey, value);
    }

    public void graphRemoveProperty(int propertyKey) {
        this.getResource().graphRemoveProperty(propertyKey);
    }

    public void graphLoadProperties(boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        this.getResource().graphLoadProperties(light, receiver);
    }

    public void createPropertyKeyToken(String key, int id) {
        this.getResource().createPropertyKeyToken(key, id);
    }

    public void createLabelId(String name, int id) {
        this.getResource().createLabelToken(name, id);
    }

    public void createRelationshipType(int id, String name) {
        this.getResource().createRelationshipTypeToken(id, name);
    }

    private NeoStoreTransaction getResource() {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        NeoStoreTransaction con = this.txConnectionMap.get(tx);
        if (con == null) {
            try {
                XaConnection xaConnection = this.persistenceSource.getXaDataSource().getXaConnection();
                XAResource xaResource = xaConnection.getXaResource();
                if (!tx.enlistResource(xaResource)) {
                    throw new ResourceAcquisitionFailedException("Unable to enlist '" + xaResource + "' in " + "transaction");
                }
                con = this.persistenceSource.createTransaction(xaConnection);
                TransactionState state = this.transactionManager.getTransactionState();
                tx.registerSynchronization((Synchronization)new TxCommitHook(tx, state));
                this.registerTransactionEventHookIfNeeded(tx);
                this.txConnectionMap.put(tx, con);
            }
            catch (RollbackException re) {
                String msg = "The transaction is marked for rollback only.";
                throw new ResourceAcquisitionFailedException(msg, re);
            }
            catch (SystemException se) {
                String msg = "TM encountered an unexpected error condition.";
                throw new ResourceAcquisitionFailedException(msg, se);
            }
        }
        return con;
    }

    private void registerTransactionEventHookIfNeeded(Transaction tx) throws SystemException, RollbackException {
        TransactionEventsSyncHook hook = this.syncHookFactory.create();
        if (hook != null) {
            tx.registerSynchronization((Synchronization)hook);
        }
    }

    private Transaction getCurrentTransaction() throws NotInTransactionException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException se) {
            throw new TransactionFailureException("Error fetching transaction for current thread", se);
        }
    }

    public void dropSchemaRule(SchemaRule rule) {
        this.getResource().dropSchemaRule(rule);
    }

    public void setConstraintIndexOwner(IndexRule constraintIndex, long constraintId) {
        this.getResource().setConstraintIndexOwner(constraintIndex, constraintId);
    }

    void delistResourcesForTransaction() throws NotInTransactionException {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        NeoStoreTransaction con = this.txConnectionMap.get(tx);
        if (con != null) {
            try {
                con.delistResource(tx, 0x4000000);
            }
            catch (SystemException e) {
                throw new TransactionFailureException("Failed to delist resource '" + con + "' from current transaction.", e);
            }
        }
    }

    void releaseResourceConnectionsForTransaction(Transaction tx) throws NotInTransactionException {
        NeoStoreTransaction con = this.txConnectionMap.remove(tx);
        if (con != null) {
            con.destroy();
        }
    }

    public void createSchemaRule(SchemaRule rule) {
        this.getResource().createSchemaRule(rule);
    }

    public void addLabelToNode(int labelId, long nodeId) {
        this.getResource().addLabelToNode(labelId, nodeId);
    }

    public void removeLabelFromNode(int labelId, long nodeId) {
        this.getResource().removeLabelFromNode(labelId, nodeId);
    }

    public PrimitiveLongIterator getLabelsForNode(long nodeId) {
        return this.getResource().getLabelsForNode(nodeId);
    }

    private class TxCommitHook
    implements Synchronization {
        private final Transaction tx;
        private final TransactionState state;

        TxCommitHook(Transaction tx, TransactionState state) {
            this.tx = tx;
            this.state = state;
        }

        public void afterCompletion(int param) {
            this.releaseConnections(this.tx);
            if (param == 3) {
                this.state.commit();
            } else {
                this.state.rollback();
            }
        }

        public void beforeCompletion() {
            PersistenceManager.this.delistResourcesForTransaction();
        }

        private void releaseConnections(Transaction tx) {
            try {
                PersistenceManager.this.releaseResourceConnectionsForTransaction(tx);
            }
            catch (Throwable t) {
                PersistenceManager.this.msgLog.error("Error releasing resources for " + tx, t);
            }
        }
    }
}

