/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;

public class PropertyBlock
implements Cloneable {
    private static final long KEY_BITMASK = 0xFFFFFFL;
    private static final int MAX_ARRAY_TOSTRING_SIZE = 4;
    private final List<DynamicRecord> valueRecords = new LinkedList<DynamicRecord>();
    private long[] valueBlocks;

    public PropertyType getType() {
        return this.getType(false);
    }

    public PropertyType forceGetType() {
        return this.getType(true);
    }

    private PropertyType getType(boolean force) {
        return this.valueBlocks == null ? null : PropertyType.getPropertyType(this.valueBlocks[0], force);
    }

    public int getKeyIndexId() {
        return (int)(this.valueBlocks[0] & 0xFFFFFFL);
    }

    public void setKeyIndexId(int key) {
        this.valueBlocks[0] = this.valueBlocks[0] & 0xFFFFFFFFFF000000L;
        this.valueBlocks[0] = this.valueBlocks[0] | (long)key;
    }

    public void setSingleBlock(long value) {
        this.valueBlocks = new long[1];
        this.valueBlocks[0] = value;
        this.valueRecords.clear();
    }

    public void addValueRecord(DynamicRecord record) {
        this.valueRecords.add(record);
    }

    public List<DynamicRecord> getValueRecords() {
        return this.valueRecords;
    }

    public long getSingleValueBlock() {
        return this.valueBlocks[0];
    }

    public long getSingleValueLong() {
        return (this.valueBlocks[0] & 0xFFFFFFFFF0000000L) >>> 28;
    }

    public int getSingleValueInt() {
        return (int)((this.valueBlocks[0] & 0xFFFFFFFF0000000L) >>> 28);
    }

    public short getSingleValueShort() {
        return (short)((this.valueBlocks[0] & 0xFFFF0000000L) >>> 28);
    }

    public byte getSingleValueByte() {
        return (byte)((this.valueBlocks[0] & 0xFF0000000L) >>> 28);
    }

    public long[] getValueBlocks() {
        return this.valueBlocks;
    }

    public boolean isLight() {
        return this.valueRecords.isEmpty();
    }

    public void setValueBlocks(long[] blocks) {
        int expectedPayloadSize = PropertyType.getPayloadSizeLongs();
        assert (blocks == null || blocks.length <= expectedPayloadSize) : "I was given an array of size " + blocks.length + ", but I wanted it to be " + expectedPayloadSize;
        this.valueBlocks = blocks;
        this.valueRecords.clear();
    }

    public int getSize() {
        return this.valueBlocks == null ? 0 : this.valueBlocks.length * 8;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("PropertyBlock[");
        PropertyType type = this.getType();
        if (this.valueBlocks != null) {
            result.append("blocks=").append(this.valueBlocks.length).append(",");
        }
        result.append(type == null ? "<unknown type>" : type.name()).append(',');
        result.append("key=").append(this.valueBlocks == null ? "?" : Integer.toString(this.getKeyIndexId()));
        if (type != null) {
            switch (type) {
                case STRING: 
                case ARRAY: {
                    result.append(",firstDynamic=").append(this.getSingleValueLong());
                    break;
                }
                default: {
                    Object value = type.getValue(this, null);
                    if (value != null && value.getClass().isArray()) {
                        int length = Array.getLength(value);
                        StringBuilder buf = new StringBuilder(value.getClass().getComponentType().getSimpleName()).append("[");
                        for (int i = 0; i < length && i <= 4; ++i) {
                            if (i != 0) {
                                buf.append(",");
                            }
                            buf.append(Array.get(value, i));
                        }
                        if (length > 4) {
                            buf.append(",...");
                        }
                        value = buf.append("]");
                    }
                    result.append(",value=").append(value);
                }
            }
        }
        if (!this.isLight()) {
            result.append(",ValueRecords[");
            Iterator<DynamicRecord> recIt = this.valueRecords.iterator();
            while (recIt.hasNext()) {
                result.append(recIt.next());
                if (!recIt.hasNext()) continue;
                result.append(',');
            }
            result.append(']');
        }
        result.append(']');
        return result.toString();
    }

    public PropertyBlock clone() {
        PropertyBlock result = new PropertyBlock();
        if (this.valueBlocks != null) {
            result.valueBlocks = (long[])this.valueBlocks.clone();
        }
        for (DynamicRecord valueRecord : this.valueRecords) {
            result.valueRecords.add(valueRecord.clone());
        }
        return result;
    }

    public boolean hasSameContentsAs(PropertyBlock other) {
        return Arrays.equals(this.valueBlocks, other.valueBlocks);
    }

    public DefinedProperty newPropertyData(PropertyStore propertyStore) {
        return this.getType().readProperty(this.getKeyIndexId(), this, propertyStore);
    }
}

