/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;

public class PropertyNotFoundException
extends KernelException {
    private final String entity;
    private final int propertyKeyId;

    public PropertyNotFoundException(int propertyKeyId, EntityType entityType, long entityId) {
        this(entityType == EntityType.GRAPH ? "GraphProperties" : entityType.name() + "[" + entityId + "]", propertyKeyId);
    }

    private PropertyNotFoundException(String entity, int propertyKeyId) {
        super("%s has no property with propertyKeyId=%s.", entity, propertyKeyId);
        this.entity = entity;
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("%s has no property with propertyKey=\"%s\".", this.entity, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }
}

