/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public class SchemaStorage
implements SchemaRuleAccess {
    private final RecordStore<DynamicRecord> schemaStore;

    public SchemaStorage(RecordStore<DynamicRecord> schemaStore) {
        this.schemaStore = schemaStore;
    }

    public IndexRule constraintIndexRule(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(labelId, propertyKeyId);
        if (rule.isConstraintIndex()) {
            return rule;
        }
        throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "is not a constraint index");
    }

    public IndexRule indexRule(int labelId, final int propertyKeyId) throws SchemaRuleNotFoundException {
        Iterator<IndexRule> rules = this.schemaRules(IndexRule.class, labelId, new Predicate<IndexRule>(){

            @Override
            public boolean accept(IndexRule item) {
                return item.getPropertyKey() == propertyKeyId;
            }
        });
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "not found");
        }
        IndexRule rule = rules.next();
        if (rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, String.format("found more than one matching index rule, %s and %s", rule, rules.next()));
        }
        return rule;
    }

    public Iterator<IndexRule> allIndexRules() {
        return this.schemaRules(IndexRule.class);
    }

    public <T extends SchemaRule> Iterator<T> schemaRules(Class<T> type, int labelId, Predicate<T> predicate) {
        return this.schemaRules(Functions.cast(type), type, labelId, predicate);
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final Class<R> ruleType, final int labelId, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind().getRuleClass() == ruleType && predicate.accept(rule);
            }
        }, this.loadAllSchemaRules()));
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final SchemaRule.Kind kind, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getKind() == kind && predicate.accept(rule);
            }
        }, this.loadAllSchemaRules()));
    }

    public <R extends SchemaRule> Iterator<R> schemaRules(final Class<R> ruleClass) {
        Iterator<SchemaRule> result = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return ruleClass.isInstance(rule);
            }
        }, this.loadAllSchemaRules());
        return result;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return new PrefetchingIterator<SchemaRule>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            {
                this.highestId = SchemaStorage.this.schemaStore.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStorage.this.newRecordBuffer();
            }

            @Override
            protected SchemaRule fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    DynamicRecord record = (DynamicRecord)SchemaStorage.this.schemaStore.forceGetRecord(id);
                    if (!record.inUse() || !record.isStartRecord()) continue;
                    try {
                        return SchemaStorage.this.getSchemaRule(id, this.scratchData);
                    }
                    catch (MalformedSchemaRuleException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
        return this.getSchemaRule(ruleId, this.newRecordBuffer());
    }

    private byte[] newRecordBuffer() {
        return new byte[this.schemaStore.getRecordSize() * 4];
    }

    private SchemaRule getSchemaRule(long id, byte[] buffer) throws MalformedSchemaRuleException {
        Collection<DynamicRecord> records;
        try {
            records = this.schemaStore.getRecords(id);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e.getMessage(), e);
        }
        return SchemaStore.readSchemaRule(id, records, buffer);
    }

    public long newRuleId() {
        return this.schemaStore.nextId();
    }

    public UniquenessConstraintRule uniquenessConstraint(int labelId, final int propertyKeyId) throws SchemaRuleNotFoundException {
        Iterator<UniquenessConstraintRule> rules = this.schemaRules(UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule item) {
                return item.containsPropertyKeyId(propertyKeyId);
            }
        });
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "not found");
        }
        UniquenessConstraintRule rule = rules.next();
        if (rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "found more than one matching index");
        }
        return rule;
    }
}

