/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.DuplicateIndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.impl.api.DiffSets;

public abstract class UniquePropertyIndexUpdater
implements IndexUpdater {
    private final Lookup lookup;
    private final Map<Object, DiffSets<Long>> referenceCount = new HashMap<Object, DiffSets<Long>>();
    private final ArrayList<NodePropertyUpdate> updates = new ArrayList();

    public UniquePropertyIndexUpdater(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void process(NodePropertyUpdate update) {
        switch (update.getUpdateMode()) {
            case ADDED: {
                UniquePropertyIndexUpdater.propertyValueDiffSet(this.referenceCount, update.getValueAfter()).add(update.getNodeId());
                break;
            }
            case CHANGED: {
                UniquePropertyIndexUpdater.propertyValueDiffSet(this.referenceCount, update.getValueBefore()).remove(update.getNodeId());
                UniquePropertyIndexUpdater.propertyValueDiffSet(this.referenceCount, update.getValueAfter()).add(update.getNodeId());
                break;
            }
            case REMOVED: {
                UniquePropertyIndexUpdater.propertyValueDiffSet(this.referenceCount, update.getValueBefore()).remove(update.getNodeId());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.updates.add(update);
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        for (Map.Entry<Object, DiffSets<Long>> entry : this.referenceCount.entrySet()) {
            Object value = entry.getKey();
            int delta = entry.getValue().delta();
            if (delta > 1) {
                throw new DuplicateIndexEntryConflictException(value, IteratorUtil.asSet(entry.getValue().getAdded()));
            }
            if (delta != 1) continue;
            Long addedNode = Iterables.single(entry.getValue().getAdded());
            Long existingNode = this.lookup.currentlyIndexedNode(value);
            if (existingNode == null || addedNode.equals(existingNode)) continue;
            throw new PreexistingIndexEntryConflictException(value, existingNode, addedNode);
        }
        this.flushUpdates(this.updates);
    }

    protected abstract void flushUpdates(Iterable<NodePropertyUpdate> var1) throws IOException, IndexEntryConflictException;

    private static DiffSets<Long> propertyValueDiffSet(Map<Object, DiffSets<Long>> referenceCount, Object value) {
        DiffSets<Long> diffSets = referenceCount.get(value);
        if (diffSets == null) {
            diffSets = new DiffSets();
            referenceCount.put(value, diffSets);
        }
        return diffSets;
    }

    public static interface Lookup {
        public Long currentlyIndexedNode(Object var1) throws IOException;
    }
}

