/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.List;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;

public class IndexUpdaterSupport {
    private IndexUpdaterSupport() {
    }

    public static void updatePopulator(IndexPopulator populator, Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = populator.newPopulatingUpdater();){
            for (NodePropertyUpdate update : updates) {
                updater.process(update);
            }
        }
    }

    public static void updateAccessor(IndexAccessor accessor, List<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (NodePropertyUpdate update : updates) {
                updater.process(update);
            }
        }
    }
}

