/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.kernel.api.operations.TokenNameLookup;

public class IndexDescriptor {
    private final int labelId;
    private final int propertyKeyId;

    public IndexDescriptor(int labelId, int propertyKeyId) {
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            IndexDescriptor that = (IndexDescriptor)obj;
            return this.labelId == that.labelId && this.propertyKeyId == that.propertyKeyId;
        }
        return false;
    }

    public int hashCode() {
        int result = this.labelId;
        result = 31 * result + this.propertyKeyId;
        return result;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public int getPropertyKeyId() {
        return this.propertyKeyId;
    }

    public String toString() {
        return String.format(":label[%d](property[%d])", this.labelId, this.propertyKeyId);
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(":%s(%s)", tokenNameLookup.labelGetName(this.labelId), tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }
}

