/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.KernelStatement;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.CacheLoader;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.PrimitiveIntIterator;
import org.neo4j.kernel.impl.api.PrimitiveIntIteratorForArray;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class CachingStatementOperations
implements EntityReadOperations,
SchemaReadOperations {
    private static final Function<? super SchemaRule, IndexDescriptor> TO_INDEX_RULE = new Function<SchemaRule, IndexDescriptor>(){

        @Override
        public IndexDescriptor apply(SchemaRule from) {
            IndexRule rule = (IndexRule)from;
            return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> nodePropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(KernelStatement state, long id) throws EntityNotFoundException {
            return CachingStatementOperations.this.entityReadDelegate.nodeGetAllProperties(state, id);
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> relationshipPropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(KernelStatement state, long id) throws EntityNotFoundException {
            return CachingStatementOperations.this.entityReadDelegate.relationshipGetAllProperties(state, id);
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> graphPropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(KernelStatement state, long id) throws EntityNotFoundException {
            return CachingStatementOperations.this.entityReadDelegate.graphGetAllProperties(state);
        }
    };
    private final CacheLoader<int[]> nodeLabelLoader = new CacheLoader<int[]>(){

        @Override
        public int[] load(KernelStatement state, long id) throws EntityNotFoundException {
            return PrimitiveIntIteratorForArray.primitiveIntIteratorToIntArray(CachingStatementOperations.this.entityReadDelegate.nodeGetLabels(state, id));
        }
    };
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final EntityReadOperations entityReadDelegate;
    private final SchemaReadOperations schemaReadDelegate;

    public CachingStatementOperations(EntityReadOperations entityReadDelegate, SchemaReadOperations schemaReadDelegate, PersistenceCache persistenceCache, SchemaCache schemaCache) {
        this.entityReadDelegate = entityReadDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.persistenceCache.nodeHasLabel(state, nodeId, labelId, this.nodeLabelLoader);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return new PrimitiveIntIteratorForArray(this.persistenceCache.nodeGetLabels(state, nodeId, this.nodeLabelLoader));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, final SchemaRule.Kind kind) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == kind;
            }
        }, rules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getId();
        }
        return this.schemaReadDelegate.indexGetCommittedId(state, index);
    }

    private IndexRule indexRule(IndexDescriptor index) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(index.getLabelId())) {
            IndexRule indexRule;
            if (!(rule instanceof IndexRule) || (indexRule = (IndexRule)rule).getPropertyKey() != index.getPropertyKeyId()) continue;
            return indexRule;
        }
        return null;
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetPropertyKeys(state, nodeId, this.nodePropertyLoader);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperty(state, nodeId, propertyKeyId, this.nodePropertyLoader);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperties(state, nodeId, this.nodePropertyLoader);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperty(state, relationshipId, propertyKeyId, this.relationshipPropertyLoader);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperties(state, nodeId, this.relationshipPropertyLoader);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        return this.persistenceCache.graphGetPropertyKeys(state, this.graphPropertyLoader);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        return this.persistenceCache.graphGetProperty(state, this.graphPropertyLoader, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        return this.persistenceCache.graphGetProperties(state, this.graphPropertyLoader);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        return this.schemaCache.constraintsForLabelAndProperty(labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.schemaCache.constraints();
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.entityReadDelegate.nodeGetUniqueFromIndexLookup(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.entityReadDelegate.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.entityReadDelegate.nodesGetFromIndexLookup(state, index, value);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        return this.schemaReadDelegate.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }
}

