/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Listeners;

public class AvailabilityGuard {
    private Iterable<AvailabilityListener> listeners = Listeners.newListeners();
    private final Clock clock;
    private final AtomicInteger available;

    public AvailabilityGuard(Clock clock, int conditionCount) {
        this.clock = clock;
        this.available = new AtomicInteger(conditionCount);
    }

    public void deny() {
        int val;
        do {
            if ((val = this.available.get()) != -1) continue;
            return;
        } while (!this.available.compareAndSet(val, val + 1));
        if (val == 0) {
            Listeners.notifyListeners(this.listeners, new Listeners.Notification<AvailabilityListener>(){

                @Override
                public void notify(AvailabilityListener listener) {
                    listener.unavailable();
                }
            });
        }
    }

    public void grant() {
        int val;
        do {
            if ((val = this.available.get()) != -1) continue;
            return;
        } while (!this.available.compareAndSet(val, val - 1));
        if (val == 1) {
            Listeners.notifyListeners(this.listeners, new Listeners.Notification<AvailabilityListener>(){

                @Override
                public void notify(AvailabilityListener listener) {
                    listener.available();
                }
            });
        }
    }

    public void shutdown() {
        int val = this.available.getAndSet(-1);
        if (val == 0) {
            Listeners.notifyListeners(this.listeners, new Listeners.Notification<AvailabilityListener>(){

                @Override
                public void notify(AvailabilityListener listener) {
                    listener.unavailable();
                }
            });
        }
    }

    public boolean isAvailable(long millis) {
        int val = this.available.get();
        if (val == 0) {
            return true;
        }
        if (val == -1) {
            return false;
        }
        long start = this.clock.currentTimeMillis();
        while (this.clock.currentTimeMillis() < start + millis) {
            val = this.available.get();
            if (val == 0) {
                return true;
            }
            if (val == -1) {
                return false;
            }
            Thread.yield();
        }
        return false;
    }

    public void addListener(AvailabilityListener listener) {
        this.listeners = Listeners.addListener(listener, this.listeners);
    }

    public void removeListener(AvailabilityListener listener) {
        this.listeners = Listeners.removeListener(listener, this.listeners);
    }

    public static interface AvailabilityListener {
        public void available();

        public void unavailable();
    }
}

