/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.FunctionFromPrimitiveInt;
import org.neo4j.helpers.FunctionFromPrimitiveLong;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.CombiningResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.api.PrimitiveIntIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;

public final class Iterables {
    private static Iterable EMPTY = new Iterable(){
        Iterator iterator = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };

        public Iterator iterator() {
            return this.iterator;
        }
    };

    public static <T> Iterable<T> empty() {
        return EMPTY;
    }

    public static <T> Iterable<T> limit(final int limitItems, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){
                    int count;

                    @Override
                    public boolean hasNext() {
                        return this.count < limitItems && iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        ++this.count;
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Function<Iterable<T>, Iterable<T>> limit(final int limitItems) {
        return new Function<Iterable<T>, Iterable<T>>(){

            @Override
            public Iterable<T> apply(Iterable<T> ts) {
                return Iterables.limit(limitItems, ts);
            }
        };
    }

    public static <T> Iterable<T> unique(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){
                    Set<T> items = new HashSet();
                    T nextItem;

                    @Override
                    public boolean hasNext() {
                        while (iterator.hasNext()) {
                            this.nextItem = iterator.next();
                            if (!this.items.add(this.nextItem)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (this.nextItem == null && !this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.nextItem;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <T, C extends Collection<T>> C addAll(C collection, Iterable<? extends T> iterable) {
        for (T item : iterable) {
            collection.add(item);
        }
        return collection;
    }

    public static long count(Iterable<?> iterable) {
        long c = 0L;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++c;
            iterator.next();
        }
        return c;
    }

    public static <X> Iterable<X> filter(Predicate<? super X> specification, Iterable<X> i) {
        return new FilterIterable<X>(i, specification);
    }

    public static <X> Iterator<X> filter(Predicate<? super X> specification, Iterator<X> i) {
        return new FilterIterable.FilterIterator<X>(i, specification);
    }

    public static <X> X first(Iterable<? extends X> i) {
        Iterator<X> iter = i.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static <X> X single(Iterable<? extends X> i) {
        return IteratorUtil.single(i);
    }

    public static <X> Iterable<X> skip(final int skip, final Iterable<X> iterable) {
        return new Iterable<X>(){

            @Override
            public Iterator<X> iterator() {
                Iterator iterator = iterable.iterator();
                for (int i = 0; i < skip; ++i) {
                    if (!iterator.hasNext()) {
                        return Iterables.empty().iterator();
                    }
                    iterator.next();
                }
                return iterator;
            }
        };
    }

    public static <X> X last(Iterable<? extends X> i) {
        Iterator<X> iter = i.iterator();
        X item = null;
        while (iter.hasNext()) {
            item = iter.next();
        }
        return item;
    }

    public static <X> Iterable<X> reverse(Iterable<X> iterable) {
        List<X> list = Iterables.toList(iterable);
        Collections.reverse(list);
        return list;
    }

    @SafeVarargs
    public static <X, I extends Iterable<? extends X>> Iterable<X> flatten(I ... multiIterator) {
        return new FlattenIterable(Arrays.asList(multiIterator));
    }

    @SafeVarargs
    public static <T> Iterable<T> mix(final Iterable<T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final List iterators = Iterables.toList(Iterables.map(new Function<Iterable<T>, Iterator<T>>(){

                    @Override
                    public Iterator<T> apply(Iterable<T> iterable) {
                        return iterable.iterator();
                    }
                }, Arrays.asList(iterables)));
                return new Iterator<T>(){
                    Iterator<Iterator<T>> iterator;
                    Iterator<T> iter;

                    @Override
                    public boolean hasNext() {
                        for (Iterator iterator : iterators) {
                            if (!iterator.hasNext()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (this.iterator == null) {
                            this.iterator = iterators.iterator();
                        }
                        while (this.iterator.hasNext()) {
                            this.iter = this.iterator.next();
                            if (!this.iter.hasNext()) continue;
                            return this.iter.next();
                        }
                        this.iterator = null;
                        return this.next();
                    }

                    @Override
                    public void remove() {
                        if (this.iter != null) {
                            this.iter.remove();
                        }
                    }
                };
            }
        };
    }

    public static <FROM, TO> Iterable<TO> map(Function<? super FROM, ? extends TO> function, Iterable<FROM> from) {
        return new MapIterable<FROM, TO>(from, function);
    }

    public static <FROM, TO> Iterator<TO> map(Function<? super FROM, ? extends TO> function, Iterator<FROM> from) {
        return new MapIterable.MapIterator<FROM, TO>(from, function);
    }

    public static <FROM, TO> Iterator<TO> flatMap(Function<? super FROM, ? extends Iterator<TO>> function, Iterator<FROM> from) {
        return new CombiningIterator(Iterables.map(function, from));
    }

    public static <T> Iterator<T> map(final FunctionFromPrimitiveLong<T> mapFunction, final PrimitiveLongIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> map(final FunctionFromPrimitiveInt<T> mapFunction, final PrimitiveIntIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @SafeVarargs
    public static <T, C extends T> Iterable<T> iterable(C ... items) {
        return Arrays.asList(items);
    }

    public static <T, C> Iterable<T> cast(Iterable<C> iterable) {
        return iterable;
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<Iterable<T>> iterables) {
        return new CombiningIterable<T>(iterables);
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables).iterator());
    }

    public static <T> ResourceIterator<T> concatResourceIterators(Iterator<ResourceIterator<T>> iterators) {
        return new CombiningResourceIterator<T>(iterators);
    }

    public static <T> Iterator<T> concat(Iterator<Iterator<T>> iterators) {
        return new CombiningIterator<T>(iterators);
    }

    public static <FROM, TO> Function<FROM, TO> cast() {
        return new Function<FROM, TO>(){

            @Override
            public TO apply(FROM from) {
                return from;
            }
        };
    }

    public static <T, C extends T> Iterable<T> prepend(final C item, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T first;
                    Iterator<T> iterator;
                    {
                        this.first = item;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.first != null) {
                            return true;
                        }
                        if (this.iterator == null) {
                            this.iterator = iterable.iterator();
                        }
                        return this.iterator.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        if (this.first != null) {
                            try {
                                Object t = this.first;
                                return t;
                            }
                            finally {
                                this.first = null;
                            }
                        }
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <T, C extends T> Iterable<T> append(final C item, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){
                    T last;
                    {
                        this.last = item;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext() || this.last != null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        if (iterator.hasNext()) {
                            return iterator.next();
                        }
                        try {
                            Object t = this.last;
                            return t;
                        }
                        finally {
                            this.last = null;
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> cache(Iterable<T> iterable) {
        return new CacheIterable(iterable);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static Object[] toArray(Iterable<Object> iterable) {
        return Iterables.toArray(Object.class, iterable);
    }

    public static <T> T[] toArray(Class<T> componentType, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        List<Object> list = Iterables.toList(iterable);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public static <T> ResourceIterable<T> asResourceIterable(final Iterable<T> labels) {
        return new ResourceIterable<T>(){

            @Override
            public ResourceIterator<T> iterator() {
                return IteratorUtil.asResourceIterator(labels.iterator());
            }
        };
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        return Iterables.addAll(new HashSet(), iterable);
    }

    public static <T> int indexOf(T itemToFind, Iterable<T> iterable) {
        if (itemToFind == null) {
            int index = 0;
            for (T item : iterable) {
                if (item == null) {
                    return index;
                }
                ++index;
            }
        } else {
            int index = 0;
            for (T item : iterable) {
                if (itemToFind.equals(item)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <T> Iterable<T> option(final T item) {
        if (item == null) {
            return Collections.emptyList();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PrefetchingIterator<T>(){
                    private boolean returned;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected T fetchNextOrNull() {
                        try {
                            Object object = !this.returned ? item : null;
                            return object;
                        }
                        finally {
                            this.returned = true;
                        }
                    }
                };
            }
        };
    }

    public static <T, S extends Comparable> Iterable<T> sort(Iterable<T> iterable, final Function<T, S> compareFunction) {
        List<T> list = Iterables.toList(iterable);
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)compareFunction.apply(o1)).compareTo(compareFunction.apply(o2));
            }
        });
        return list;
    }

    private static class CacheIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;
        private Iterable<T> cache;

        private CacheIterable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.cache != null) {
                return this.cache.iterator();
            }
            final Iterator<T> source = this.iterable.iterator();
            return new Iterator<T>(){
                List<T> iteratorCache = new ArrayList();

                @Override
                public boolean hasNext() {
                    boolean hasNext = source.hasNext();
                    if (!hasNext) {
                        CacheIterable.this.cache = this.iteratorCache;
                    }
                    return hasNext;
                }

                @Override
                public T next() {
                    Object next = source.next();
                    this.iteratorCache.add(next);
                    return next;
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    private static class FlattenIterable<T, I extends Iterable<? extends T>>
    implements Iterable<T> {
        private final Iterable<I> iterable;

        public FlattenIterable(Iterable<I> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new FlattenIterator(this.iterable.iterator());
        }

        static class FlattenIterator<T, I extends Iterable<? extends T>>
        implements Iterator<T> {
            private final Iterator<I> iterator;
            private Iterator<? extends T> currentIterator;

            public FlattenIterator(Iterator<I> iterator) {
                this.iterator = iterator;
                this.currentIterator = null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    if (this.iterator.hasNext()) {
                        Iterable next = (Iterable)this.iterator.next();
                        this.currentIterator = next.iterator();
                    } else {
                        return false;
                    }
                }
                while (!this.currentIterator.hasNext() && this.iterator.hasNext()) {
                    this.currentIterator = ((Iterable)this.iterator.next()).iterator();
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public T next() {
                return this.currentIterator.next();
            }

            @Override
            public void remove() {
                if (this.currentIterator == null) {
                    throw new IllegalStateException();
                }
                this.currentIterator.remove();
            }
        }
    }

    private static class FilterIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;
        private final Predicate<? super T> specification;

        public FilterIterable(Iterable<T> iterable, Predicate<? super T> specification) {
            this.iterable = iterable;
            this.specification = specification;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator<T>(this.iterable.iterator(), this.specification);
        }

        static class FilterIterator<T>
        implements Iterator<T> {
            private final Iterator<T> iterator;
            private final Predicate<? super T> specification;
            private T currentValue;
            boolean finished = false;
            boolean nextConsumed = true;

            public FilterIterator(Iterator<T> iterator, Predicate<? super T> specification) {
                this.specification = specification;
                this.iterator = iterator;
            }

            public boolean moveToNextValid() {
                boolean found = false;
                while (!found && this.iterator.hasNext()) {
                    T currentValue = this.iterator.next();
                    boolean satisfies = this.specification.accept(currentValue);
                    if (!satisfies) continue;
                    found = true;
                    this.currentValue = currentValue;
                    this.nextConsumed = false;
                }
                if (!found) {
                    this.finished = true;
                }
                return found;
            }

            @Override
            public T next() {
                if (!this.nextConsumed) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                if (!this.finished && this.moveToNextValid()) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                throw new NoSuchElementException("This iterator is exhausted.");
            }

            @Override
            public boolean hasNext() {
                return !this.finished && (!this.nextConsumed || this.moveToNextValid());
            }

            @Override
            public void remove() {
            }
        }
    }

    private static class MapIterable<FROM, TO>
    implements Iterable<TO> {
        private final Iterable<FROM> from;
        private final Function<? super FROM, ? extends TO> function;

        public MapIterable(Iterable<FROM> from, Function<? super FROM, ? extends TO> function) {
            this.from = from;
            this.function = function;
        }

        @Override
        public Iterator<TO> iterator() {
            return new MapIterator<FROM, TO>(this.from.iterator(), this.function);
        }

        static class MapIterator<FROM, TO>
        implements Iterator<TO> {
            private final Iterator<FROM> fromIterator;
            private final Function<? super FROM, ? extends TO> function;

            public MapIterator(Iterator<FROM> fromIterator, Function<? super FROM, ? extends TO> function) {
                this.fromIterator = fromIterator;
                this.function = function;
            }

            @Override
            public boolean hasNext() {
                return this.fromIterator.hasNext();
            }

            @Override
            public TO next() {
                FROM from = this.fromIterator.next();
                return this.function.apply(from);
            }

            @Override
            public void remove() {
                this.fromIterator.remove();
            }
        }
    }
}

