/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;

public enum ConstraintType {
    UNIQUENESS("Uniqueness");

    private final String prettyName;
    private final Predicate<ConstraintDefinition> predicate = new Predicate<ConstraintDefinition>(){

        @Override
        public boolean accept(ConstraintDefinition item) {
            return item.isConstraintType(ConstraintType.this);
        }
    };

    private ConstraintType(String prettyName) {
        this.prettyName = prettyName;
    }

    public String simpleName() {
        return this.prettyName;
    }

    public Iterable<ConstraintDefinition> filter(Iterable<ConstraintDefinition> input) {
        return Iterables.filter(this.predicate, input);
    }
}

