/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.FunctionFromPrimitiveLong;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.cleanup.CleanupService;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Token;

public class GlobalGraphOperations {
    private final NodeManager nodeManager;
    private final CleanupService cleanupService;
    private final ThreadToStatementContextBridge statementCtxProvider;

    private GlobalGraphOperations(GraphDatabaseService db) {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        DependencyResolver resolver = dbApi.getDependencyResolver();
        this.nodeManager = resolver.resolveDependency(NodeManager.class);
        this.cleanupService = resolver.resolveDependency(CleanupService.class);
        this.statementCtxProvider = resolver.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public static GlobalGraphOperations at(GraphDatabaseService db) {
        return new GlobalGraphOperations(db);
    }

    public Iterable<Node> getAllNodes() {
        this.assertInTransaction();
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllNodes();
            }
        };
    }

    public Iterable<Relationship> getAllRelationships() {
        this.assertInTransaction();
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllRelationships();
            }
        };
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        this.assertInTransaction();
        this.statementCtxProvider.assertInTransaction();
        return this.nodeManager.getRelationshipTypes();
    }

    public ResourceIterable<Label> getAllLabels() {
        this.assertInTransaction();
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                Statement statement = GlobalGraphOperations.this.statementCtxProvider.statement();
                return GlobalGraphOperations.this.cleanupService.resourceIterator(Iterables.map(new Function<Token, Label>(){

                    @Override
                    public Label apply(Token labelToken) {
                        return DynamicLabel.label(labelToken.name());
                    }
                }, statement.readOperations().labelsGetAllTokens()), statement);
            }
        };
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        this.assertInTransaction();
        return new ResourceIterable<String>(){

            @Override
            public ResourceIterator<String> iterator() {
                Statement statement = GlobalGraphOperations.this.statementCtxProvider.statement();
                return GlobalGraphOperations.this.cleanupService.resourceIterator(Iterables.map(new Function<Token, String>(){

                    @Override
                    public String apply(Token propertyToken) {
                        return propertyToken.name();
                    }
                }, statement.readOperations().propertyKeyGetAllTokens()), statement);
            }
        };
    }

    public ResourceIterable<Node> getAllNodesWithLabel(final Label label) {
        this.assertInTransaction();
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return GlobalGraphOperations.this.allNodesWithLabel(label.name());
            }
        };
    }

    private ResourceIterator<Node> allNodesWithLabel(String label) {
        Statement statement = this.statementCtxProvider.statement();
        int labelId = statement.readOperations().labelGetForName(label);
        if (labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        PrimitiveLongIterator nodeIds = statement.readOperations().nodesGetForLabel(labelId);
        return this.cleanupService.resourceIterator(Iterables.map(new FunctionFromPrimitiveLong<Node>(){

            @Override
            public Node apply(long nodeId) {
                return GlobalGraphOperations.this.nodeManager.getNodeById(nodeId);
            }
        }, nodeIds), statement);
    }

    private void assertInTransaction() {
        this.statementCtxProvider.assertInTransaction();
    }
}

