/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.Transaction;
import org.neo4j.kernel.impl.core.LockElement;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.LockManager;

public enum LockType {
    READ{

        @Override
        public LockElement acquire(TransactionState state, Object resource) {
            return state.acquireReadLock(resource);
        }

        @Override
        public void release(LockManager lockManager, Object resource, Transaction tx) {
            lockManager.releaseReadLock(resource, tx);
        }
    }
    ,
    WRITE{

        @Override
        public LockElement acquire(TransactionState state, Object resource) {
            return state.acquireWriteLock(resource);
        }

        @Override
        public void release(LockManager lockManager, Object resource, Transaction tx) {
            lockManager.releaseWriteLock(resource, tx);
        }
    };


    public abstract LockElement acquire(TransactionState var1, Object var2);

    public abstract void release(LockManager var1, Object var2, Transaction var3);
}

