/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.scan.LabelScanStore;
import org.neo4j.kernel.api.scan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.IntegrityValidator;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.RecordChanges;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

public class WriteTransaction
extends XaTransaction
implements NeoStoreTransaction {
    private final RecordChanges<Long, NodeRecord, Void> nodeRecords = new RecordChanges<Long, NodeRecord, Void>(new RecordChanges.Loader<Long, NodeRecord, Void>(){

        @Override
        public NodeRecord newUnused(Long key, Void additionalData) {
            return new NodeRecord(key, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }

        @Override
        public NodeRecord load(Long key, Void additionalData) {
            return WriteTransaction.this.getNodeStore().getRecord(key);
        }

        @Override
        public void ensureHeavy(NodeRecord record) {
            WriteTransaction.this.getNodeStore().ensureHeavy(record);
        }

        @Override
        public NodeRecord clone(NodeRecord nodeRecord) {
            return nodeRecord.clone();
        }
    }, true);
    private final RecordChanges<Long, PropertyRecord, PrimitiveRecord> propertyRecords = new RecordChanges<Long, PropertyRecord, PrimitiveRecord>(new RecordChanges.Loader<Long, PropertyRecord, PrimitiveRecord>(){

        @Override
        public PropertyRecord newUnused(Long key, PrimitiveRecord additionalData) {
            PropertyRecord record = new PropertyRecord(key);
            this.setOwner(record, additionalData);
            return record;
        }

        private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
            if (owner != null) {
                owner.setIdTo(record);
            }
        }

        @Override
        public PropertyRecord load(Long key, PrimitiveRecord additionalData) {
            PropertyRecord record = WriteTransaction.this.getPropertyStore().getRecord(key);
            this.setOwner(record, additionalData);
            return record;
        }

        @Override
        public void ensureHeavy(PropertyRecord record) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                WriteTransaction.this.getPropertyStore().ensureHeavy(block);
            }
        }

        @Override
        public PropertyRecord clone(PropertyRecord propertyRecord) {
            return propertyRecord.clone();
        }
    }, true);
    private final RecordChanges<Long, RelationshipRecord, Void> relRecords = new RecordChanges<Long, RelationshipRecord, Void>(new RecordChanges.Loader<Long, RelationshipRecord, Void>(){

        @Override
        public RelationshipRecord newUnused(Long key, Void additionalData) {
            return new RelationshipRecord(key);
        }

        @Override
        public RelationshipRecord load(Long key, Void additionalData) {
            return WriteTransaction.this.getRelationshipStore().getRecord(key);
        }

        @Override
        public void ensureHeavy(RelationshipRecord record) {
        }

        @Override
        public RelationshipRecord clone(RelationshipRecord relationshipRecord) {
            throw new UnsupportedOperationException("Unexpected call to clone on a relationshipRecord");
        }
    }, false);
    private final RecordChanges<Long, Collection<DynamicRecord>, SchemaRule> schemaRuleChanges = new RecordChanges<Long, Collection<DynamicRecord>, SchemaRule>(new RecordChanges.Loader<Long, Collection<DynamicRecord>, SchemaRule>(){

        @Override
        public Collection<DynamicRecord> newUnused(Long key, SchemaRule additionalData) {
            return WriteTransaction.this.getSchemaStore().allocateFrom(additionalData);
        }

        @Override
        public Collection<DynamicRecord> load(Long key, SchemaRule additionalData) {
            return WriteTransaction.this.getSchemaStore().getRecords(key);
        }

        @Override
        public void ensureHeavy(Collection<DynamicRecord> dynamicRecords) {
            SchemaStore schemaStore = WriteTransaction.this.getSchemaStore();
            for (DynamicRecord record : dynamicRecords) {
                schemaStore.ensureHeavy(record);
            }
        }

        @Override
        public Collection<DynamicRecord> clone(Collection<DynamicRecord> dynamicRecords) {
            ArrayList<DynamicRecord> list = new ArrayList<DynamicRecord>(dynamicRecords.size());
            for (DynamicRecord record : dynamicRecords) {
                list.add(record.clone());
            }
            return list;
        }
    }, true);
    private Map<Integer, RelationshipTypeTokenRecord> relationshipTypeTokenRecords;
    private Map<Integer, LabelTokenRecord> labelTokenRecords;
    private Map<Integer, PropertyKeyTokenRecord> propertyKeyTokenRecords;
    private RecordChanges<Long, NeoStoreRecord, Void> neoStoreRecord;
    private final Map<Long, Command.NodeCommand> nodeCommands = new TreeMap<Long, Command.NodeCommand>();
    private final ArrayList<Command.PropertyCommand> propCommands = new ArrayList();
    private final ArrayList<Command.RelationshipCommand> relCommands = new ArrayList();
    private final ArrayList<Command.SchemaRuleCommand> schemaRuleCommands = new ArrayList();
    private ArrayList<Command.RelationshipTypeTokenCommand> relationshipTypeTokenCommands;
    private ArrayList<Command.LabelTokenCommand> labelTokenCommands;
    private ArrayList<Command.PropertyKeyTokenCommand> propertyKeyTokenCommands;
    private Command.NeoStoreCommand neoStoreCommand;
    private boolean committed = false;
    private boolean prepared = false;
    private XaConnection xaConnection;
    private final long lastCommittedTxWhenTransactionStarted;
    private final TransactionState state;
    private final CacheAccessBackDoor cacheAccess;
    private final IndexingService indexes;
    private final NeoStore neoStore;
    private final LabelScanStore labelScanStore;
    private final IntegrityValidator integrityValidator;

    WriteTransaction(int identifier, long lastCommittedTxWhenTransactionStarted, XaLogicalLog log, TransactionState state, NeoStore neoStore, CacheAccessBackDoor cacheAccess, IndexingService indexingService, LabelScanStore labelScanStore, IntegrityValidator integrityValidator) {
        super(identifier, log, state);
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.neoStore = neoStore;
        this.state = state;
        this.cacheAccess = cacheAccess;
        this.indexes = indexingService;
        this.labelScanStore = labelScanStore;
        this.integrityValidator = integrityValidator;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isRecovered()) {
            return this.nodeCommands.size() == 0 && this.propCommands.size() == 0 && this.relCommands.size() == 0 && this.schemaRuleCommands.size() == 0 && this.relationshipTypeTokenCommands == null && this.labelTokenCommands == null && this.propertyKeyTokenCommands == null;
        }
        return this.nodeRecords.changeSize() == 0 && this.relRecords.changeSize() == 0 && this.schemaRuleChanges.changeSize() == 0 && this.propertyRecords.changeSize() == 0 && this.relationshipTypeTokenRecords == null && this.labelTokenRecords == null && this.propertyKeyTokenRecords == null;
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
    }

    @Override
    public void doAddCommand(XaCommand command) {
    }

    @Override
    protected void doPrepare() throws XAException {
        Command command;
        int noOfCommands = this.nodeRecords.changeSize() + this.relRecords.changeSize() + this.propertyRecords.changeSize() + this.schemaRuleChanges.changeSize() + (this.propertyKeyTokenRecords != null ? this.propertyKeyTokenRecords.size() : 0) + (this.relationshipTypeTokenRecords != null ? this.relationshipTypeTokenRecords.size() : 0) + (this.labelTokenRecords != null ? this.labelTokenRecords.size() : 0);
        ArrayList<Command> commands = new ArrayList<Command>(noOfCommands);
        if (this.committed) {
            throw new XAException("Cannot prepare committed transaction[" + this.getIdentifier() + "]");
        }
        if (this.prepared) {
            throw new XAException("Cannot prepare prepared transaction[" + this.getIdentifier() + "]");
        }
        this.prepared = true;
        if (this.relationshipTypeTokenRecords != null) {
            this.relationshipTypeTokenCommands = new ArrayList();
            for (RelationshipTypeTokenRecord relationshipTypeTokenRecord : this.relationshipTypeTokenRecords.values()) {
                command = new Command.RelationshipTypeTokenCommand(this.neoStore.getRelationshipTypeStore(), relationshipTypeTokenRecord);
                this.relationshipTypeTokenCommands.add((Command.RelationshipTypeTokenCommand)command);
                commands.add(command);
            }
        }
        if (this.labelTokenRecords != null) {
            this.labelTokenCommands = new ArrayList();
            for (LabelTokenRecord labelTokenRecord : this.labelTokenRecords.values()) {
                command = new Command.LabelTokenCommand(this.neoStore.getLabelTokenStore(), labelTokenRecord);
                this.labelTokenCommands.add((Command.LabelTokenCommand)command);
                commands.add(command);
            }
        }
        for (RecordChanges.RecordChange recordChange : this.nodeRecords.changes()) {
            NodeRecord record = (NodeRecord)recordChange.forReadingLinkage();
            this.integrityValidator.validateNodeRecord(record);
            Command.NodeCommand command2 = new Command.NodeCommand(this.neoStore.getNodeStore(), (NodeRecord)recordChange.getBefore(), record);
            this.nodeCommands.put(record.getId(), command2);
            commands.add(command2);
        }
        for (RecordChanges.RecordChange recordChange : this.relRecords.changes()) {
            command = new Command.RelationshipCommand(this.neoStore.getRelationshipStore(), (RelationshipRecord)recordChange.forReadingLinkage());
            this.relCommands.add((Command.RelationshipCommand)command);
            commands.add(command);
        }
        if (this.neoStoreRecord != null) {
            for (RecordChanges.RecordChange recordChange : this.neoStoreRecord.changes()) {
                this.neoStoreCommand = new Command.NeoStoreCommand(this.neoStore, (NeoStoreRecord)recordChange.forReadingData());
                this.addCommand(this.neoStoreCommand);
            }
        }
        if (this.propertyKeyTokenRecords != null) {
            this.propertyKeyTokenCommands = new ArrayList();
            for (PropertyKeyTokenRecord propertyKeyTokenRecord : this.propertyKeyTokenRecords.values()) {
                command = new Command.PropertyKeyTokenCommand(this.neoStore.getPropertyStore().getPropertyKeyTokenStore(), propertyKeyTokenRecord);
                this.propertyKeyTokenCommands.add((Command.PropertyKeyTokenCommand)command);
                commands.add(command);
            }
        }
        for (RecordChanges.RecordChange recordChange : this.propertyRecords.changes()) {
            command = new Command.PropertyCommand(this.neoStore.getPropertyStore(), (PropertyRecord)recordChange.getBefore(), (PropertyRecord)recordChange.forReadingLinkage());
            this.propCommands.add((Command.PropertyCommand)command);
            commands.add(command);
        }
        for (RecordChanges.RecordChange recordChange : this.schemaRuleChanges.changes()) {
            this.integrityValidator.validateSchemaRule((SchemaRule)recordChange.getAdditionalData());
            command = new Command.SchemaRuleCommand(this.neoStore, this.neoStore.getSchemaStore(), this.indexes, (Collection)recordChange.getBefore(), (Collection)recordChange.forChangingData(), (SchemaRule)recordChange.getAdditionalData(), -1L);
            this.schemaRuleCommands.add((Command.SchemaRuleCommand)command);
            commands.add(command);
        }
        assert (commands.size() == noOfCommands) : "Expected " + noOfCommands + " final commands, got " + commands.size() + " instead";
        this.intercept(commands);
        for (Command command2 : commands) {
            this.addCommand(command2);
        }
        this.integrityValidator.validateTransactionStartKnowledge(this.lastCommittedTxWhenTransactionStarted);
    }

    protected void intercept(List<Command> commands) {
    }

    @Override
    protected void injectCommand(XaCommand xaCommand) {
        if (xaCommand instanceof Command.NodeCommand) {
            Command.NodeCommand nodeCommand = (Command.NodeCommand)xaCommand;
            this.nodeCommands.put(nodeCommand.getKey(), nodeCommand);
        } else if (xaCommand instanceof Command.RelationshipCommand) {
            this.relCommands.add((Command.RelationshipCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyCommand) {
            this.propCommands.add((Command.PropertyCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyKeyTokenCommand) {
            if (this.propertyKeyTokenCommands == null) {
                this.propertyKeyTokenCommands = new ArrayList();
            }
            this.propertyKeyTokenCommands.add((Command.PropertyKeyTokenCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipTypeTokenCommand) {
            if (this.relationshipTypeTokenCommands == null) {
                this.relationshipTypeTokenCommands = new ArrayList();
            }
            this.relationshipTypeTokenCommands.add((Command.RelationshipTypeTokenCommand)xaCommand);
        } else if (xaCommand instanceof Command.LabelTokenCommand) {
            if (this.labelTokenCommands == null) {
                this.labelTokenCommands = new ArrayList();
            }
            this.labelTokenCommands.add((Command.LabelTokenCommand)xaCommand);
        } else if (xaCommand instanceof Command.NeoStoreCommand) {
            assert (this.neoStoreCommand == null);
            this.neoStoreCommand = (Command.NeoStoreCommand)xaCommand;
        } else if (xaCommand instanceof Command.SchemaRuleCommand) {
            this.schemaRuleCommands.add((Command.SchemaRuleCommand)xaCommand);
        } else {
            throw new IllegalArgumentException("Unknown command " + xaCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRollback() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot rollback partialy commited transaction[" + this.getIdentifier() + "]. Recover and " + "commit");
        }
        try {
            boolean freeIds = this.neoStore.freeIdsDuringRollback();
            if (this.relationshipTypeTokenRecords != null) {
                for (RelationshipTypeTokenRecord relationshipTypeTokenRecord : this.relationshipTypeTokenRecords.values()) {
                    if (relationshipTypeTokenRecord.isCreated()) {
                        if (freeIds) {
                            this.getRelationshipTypeStore().freeId(relationshipTypeTokenRecord.getId());
                        }
                        for (DynamicRecord dynamicRecord : relationshipTypeTokenRecord.getNameRecords()) {
                            if (!dynamicRecord.isCreated()) continue;
                            this.getRelationshipTypeStore().freeId((int)dynamicRecord.getId());
                        }
                    }
                    this.removeRelationshipTypeFromCache(relationshipTypeTokenRecord.getId());
                }
            }
            for (RecordChanges.RecordChange recordChange : this.nodeRecords.changes()) {
                NodeRecord record = (NodeRecord)recordChange.forReadingLinkage();
                if (freeIds && record.isCreated()) {
                    this.getNodeStore().freeId(record.getId());
                }
                this.removeNodeFromCache(record.getId());
            }
            for (RecordChanges.RecordChange recordChange : this.relRecords.changes()) {
                long id = (Long)recordChange.getKey();
                RelationshipRecord record = (RelationshipRecord)recordChange.forReadingLinkage();
                if (freeIds && recordChange.isCreated()) {
                    this.getRelationshipStore().freeId(id);
                }
                this.removeRelationshipFromCache(id);
                this.patchDeletedRelationshipNodes(id, record.getFirstNode(), record.getFirstNextRel(), record.getSecondNode(), record.getSecondNextRel());
            }
            if (this.neoStoreRecord != null) {
                this.removeGraphPropertiesFromCache();
            }
            if (this.propertyKeyTokenRecords != null) {
                for (PropertyKeyTokenRecord propertyKeyTokenRecord : this.propertyKeyTokenRecords.values()) {
                    if (!propertyKeyTokenRecord.isCreated()) continue;
                    if (freeIds) {
                        this.getPropertyStore().getPropertyKeyTokenStore().freeId(propertyKeyTokenRecord.getId());
                    }
                    for (DynamicRecord dynamicRecord : propertyKeyTokenRecord.getNameRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        this.getPropertyStore().getPropertyKeyTokenStore().freeId((int)dynamicRecord.getId());
                    }
                }
            }
            for (RecordChanges.RecordChange recordChange : this.propertyRecords.changes()) {
                PropertyRecord record = (PropertyRecord)recordChange.forReadingLinkage();
                if (record.getNodeId() != -1L) {
                    this.removeNodeFromCache(record.getNodeId());
                } else if (record.getRelId() != -1L) {
                    this.removeRelationshipFromCache(record.getRelId());
                }
                if (!record.isCreated()) continue;
                if (freeIds) {
                    this.getPropertyStore().freeId(record.getId());
                }
                for (PropertyBlock block : record.getPropertyBlocks()) {
                    for (DynamicRecord dynamicRecord : block.getValueRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        if (dynamicRecord.getType() == PropertyType.STRING.intValue()) {
                            this.getPropertyStore().freeStringBlockId(dynamicRecord.getId());
                            continue;
                        }
                        if (dynamicRecord.getType() == PropertyType.ARRAY.intValue()) {
                            this.getPropertyStore().freeArrayBlockId(dynamicRecord.getId());
                            continue;
                        }
                        throw new InvalidRecordException("Unknown type on " + dynamicRecord);
                    }
                }
            }
            for (RecordChanges.RecordChange recordChange : this.schemaRuleChanges.changes()) {
                long id = -1L;
                for (DynamicRecord record : (Collection)recordChange.forChangingData()) {
                    if (id == -1L) {
                        id = record.getId();
                    }
                    if (!freeIds || !record.isCreated()) continue;
                    this.getSchemaStore().freeId(record.getId());
                }
            }
        }
        finally {
            this.clear();
        }
    }

    private void removeRelationshipTypeFromCache(int id) {
        this.cacheAccess.removeRelationshipTypeFromCache(id);
    }

    private void patchDeletedRelationshipNodes(long id, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNextRelId) {
        this.cacheAccess.patchDeletedRelationshipNodes(id, firstNodeId, firstNodeNextRelId, secondNodeId, secondNextRelId);
    }

    private void removeRelationshipFromCache(long id) {
        this.cacheAccess.removeRelationshipFromCache(id);
    }

    private void removeNodeFromCache(long id) {
        this.cacheAccess.removeNodeFromCache(id);
    }

    private void removeGraphPropertiesFromCache() {
        this.cacheAccess.removeGraphPropertiesFromCache();
    }

    private void addRelationshipType(int id) {
        this.setRecovered();
        Token type = this.isRecovered() ? this.neoStore.getRelationshipTypeStore().getToken(id, true) : this.neoStore.getRelationshipTypeStore().getToken(id);
        this.cacheAccess.addRelationshipTypeToken(type);
    }

    private void addLabel(int id) {
        Token labelId = this.isRecovered() ? this.neoStore.getLabelTokenStore().getToken(id, true) : this.neoStore.getLabelTokenStore().getToken(id);
        this.cacheAccess.addLabelToken(labelId);
    }

    private void addPropertyKey(int id) {
        Token index = this.isRecovered() ? this.neoStore.getPropertyStore().getPropertyKeyTokenStore().getToken(id, true) : this.neoStore.getPropertyStore().getPropertyKeyTokenStore().getToken(id);
        this.cacheAccess.addPropertyKeyToken(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit() throws XAException {
        if (!this.isRecovered() && !this.prepared) {
            throw new XAException("Cannot commit non prepared transaction[" + this.getIdentifier() + "]");
        }
        if (this.isRecovered()) {
            boolean wasInRecovery = this.neoStore.isInRecoveryMode();
            this.neoStore.setRecoveredStatus(true);
            try {
                this.applyCommit(true);
                return;
            }
            finally {
                this.neoStore.setRecoveredStatus(wasInRecovery);
            }
        }
        if (this.getCommitTxId() != this.neoStore.getLastCommittedTx() + 1L) {
            throw new RuntimeException("Tx id: " + this.getCommitTxId() + " not next transaction (" + this.neoStore.getLastCommittedTx() + ")");
        }
        this.applyCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCommit(boolean isRecovered) {
        try {
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            if (this.relationshipTypeTokenCommands != null) {
                Collections.sort(this.relationshipTypeTokenCommands, sorter);
                for (Command.RelationshipTypeTokenCommand relationshipTypeTokenCommand : this.relationshipTypeTokenCommands) {
                    relationshipTypeTokenCommand.execute();
                    if (!isRecovered) continue;
                    this.addRelationshipType((int)relationshipTypeTokenCommand.getKey());
                }
            }
            if (this.labelTokenCommands != null) {
                Collections.sort(this.labelTokenCommands, sorter);
                for (Command.LabelTokenCommand labelTokenCommand : this.labelTokenCommands) {
                    labelTokenCommand.execute();
                    if (!isRecovered) continue;
                    this.addLabel((int)labelTokenCommand.getKey());
                }
            }
            if (this.propertyKeyTokenCommands != null) {
                Collections.sort(this.propertyKeyTokenCommands, sorter);
                for (Command.PropertyKeyTokenCommand propertyKeyTokenCommand : this.propertyKeyTokenCommands) {
                    propertyKeyTokenCommand.execute();
                    if (!isRecovered) continue;
                    this.addPropertyKey((int)propertyKeyTokenCommand.getKey());
                }
            }
            Collections.sort(this.relCommands, sorter);
            Collections.sort(this.propCommands, sorter);
            this.executeCreated(isRecovered, this.propCommands, this.relCommands, this.nodeCommands.values());
            this.executeModified(isRecovered, this.propCommands, this.relCommands, this.nodeCommands.values());
            this.executeDeleted(this.propCommands, this.relCommands, this.nodeCommands.values());
            HashSet<NodePropertyUpdate> propertyUpdates = new HashSet<NodePropertyUpdate>();
            ArrayList<NodeLabelUpdate> arrayList = new ArrayList<NodeLabelUpdate>();
            this.gatherPropertyAndLabelUpdates(propertyUpdates, arrayList);
            this.indexes.updateIndexes(propertyUpdates);
            this.updateLabelScanStore(arrayList);
            block9: for (Command.SchemaRuleCommand command : this.schemaRuleCommands) {
                command.setTxId(this.getCommitTxId());
                command.execute();
                switch (command.getMode()) {
                    case DELETE: {
                        this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                        continue block9;
                    }
                }
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
            if (this.neoStoreCommand != null) {
                this.neoStoreCommand.execute();
                if (isRecovered) {
                    this.removeGraphPropertiesFromCache();
                }
            }
            if (!isRecovered) {
                this.updateFirstRelationships();
                this.state.commitCows();
            }
            this.neoStore.setLastCommittedTx(this.getCommitTxId());
            if (isRecovered) {
                this.neoStore.updateIdGenerators();
            }
        }
        finally {
            this.clear();
        }
    }

    private void updateLabelScanStore(Iterable<NodeLabelUpdate> labelUpdates) {
        try {
            this.labelScanStore.updateAndCommit(labelUpdates.iterator());
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void gatherPropertyAndLabelUpdates(Collection<NodePropertyUpdate> propertyUpdates, Collection<NodeLabelUpdate> labelUpdates) {
        this.gatherUpdatesFromPropertyCommands(propertyUpdates);
        this.gatherUpdatesFromNodeCommands(propertyUpdates, labelUpdates);
    }

    private void gatherUpdatesFromPropertyCommands(Collection<NodePropertyUpdate> updates) {
        PropertyStore propertyStore = this.getPropertyStore();
        NodeStore nodeStore = this.getNodeStore();
        for (Command.PropertyCommand propertyCommand : this.propCommands) {
            long[] nodeLabelsAfter;
            long[] nodeLabelsBefore;
            PropertyRecord after = propertyCommand.getAfter();
            if (!after.isNodeSet()) continue;
            Command.NodeCommand nodeChanges = this.nodeCommands.get(after.getNodeId());
            if (nodeChanges != null) {
                nodeLabelsBefore = NodeLabelsField.parseLabelsField(nodeChanges.getBefore()).get(nodeStore);
                nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeChanges.getAfter()).get(nodeStore);
            } else {
                nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeStore.getRecord(after.getNodeId())).get(nodeStore);
            }
            for (NodePropertyUpdate update : propertyStore.toLogicalUpdates(propertyCommand.getBefore(), nodeLabelsBefore, after, nodeLabelsAfter)) {
                updates.add(update);
            }
        }
    }

    private void gatherUpdatesFromNodeCommands(Collection<NodePropertyUpdate> propertyUpdates, Collection<NodeLabelUpdate> labelUpdates) {
        NodeStore nodeStore = this.getNodeStore();
        for (Command.NodeCommand nodeCommand : this.nodeCommands.values()) {
            long nodeId = nodeCommand.getKey();
            long[] labelsBefore = NodeLabelsField.parseLabelsField(nodeCommand.getBefore()).get(nodeStore);
            long[] labelsAfter = NodeLabelsField.parseLabelsField(nodeCommand.getAfter()).get(nodeStore);
            labelUpdates.add(NodeLabelUpdate.labelChanges(nodeId, labelsBefore, labelsAfter));
            if (nodeCommand.getMode() != Command.Mode.UPDATE) continue;
            LabelChangeSummary summary = new LabelChangeSummary(labelsBefore, labelsAfter);
            Iterator<DefinedProperty> properties = this.nodeFullyLoadProperties(nodeId);
            while (properties.hasNext()) {
                DefinedProperty property = properties.next();
                if (summary.hasAddedLabels()) {
                    propertyUpdates.add(NodePropertyUpdate.add(nodeId, property.propertyKeyId(), property.value(), summary.getAddedLabels()));
                }
                if (!summary.hasRemovedLabels()) continue;
                propertyUpdates.add(NodePropertyUpdate.remove(nodeId, property.propertyKeyId(), property.value(), summary.getRemovedLabels()));
            }
        }
    }

    @Override
    public boolean delistResource(Transaction tx, int tmsuccess) throws SystemException {
        return this.xaConnection.delistResource(tx, tmsuccess);
    }

    private void updateFirstRelationships() {
        for (RecordChanges.RecordChange<Long, NodeRecord, Void> change : this.nodeRecords.changes()) {
            NodeRecord record = change.forReadingLinkage();
            this.state.setFirstIds(record.getId(), record.getNextRel(), record.getNextProp());
        }
    }

    @SafeVarargs
    private final void executeCreated(boolean removeFromCache, Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.CREATE) continue;
                command.execute();
                if (!removeFromCache) continue;
                command.removeFromCache(this.cacheAccess);
            }
        }
    }

    @SafeVarargs
    private final void executeModified(boolean removeFromCache, Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.UPDATE) continue;
                command.execute();
                if (!removeFromCache) continue;
                command.removeFromCache(this.cacheAccess);
            }
        }
    }

    @SafeVarargs
    private final void executeDeleted(Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.DELETE) continue;
                command.execute();
                command.removeFromCache(this.cacheAccess);
            }
        }
    }

    private void clear() {
        this.nodeRecords.clear();
        this.propertyRecords.clear();
        this.relRecords.clear();
        this.schemaRuleChanges.clear();
        this.relationshipTypeTokenRecords = null;
        this.propertyKeyTokenRecords = null;
        this.neoStoreRecord = null;
        this.nodeCommands.clear();
        this.propCommands.clear();
        this.propertyKeyTokenCommands = null;
        this.relCommands.clear();
        this.schemaRuleCommands.clear();
        this.relationshipTypeTokenCommands = null;
        this.labelTokenCommands = null;
        this.neoStoreCommand = null;
    }

    private RelationshipTypeTokenStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private LabelTokenStore getLabelTokenStore() {
        return this.neoStore.getLabelTokenStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private SchemaStore getSchemaStore() {
        return this.neoStore.getSchemaStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    @Override
    public NodeRecord nodeLoadLight(long nodeId) {
        try {
            return this.nodeRecords.getOrLoad(nodeId, null).forReadingLinkage();
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }

    @Override
    public RelationshipRecord relLoadLight(long id) {
        try {
            return this.relRecords.getOrLoad(id, null).forReadingLinkage();
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        nodeRecord.setLabelField(0L, Collections.emptyList());
        return this.getAndDeletePropertyChain(nodeRecord);
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> relDelete(long id) {
        RelationshipRecord record = this.relRecords.getOrLoad(id, null).forChangingLinkage();
        if (!record.inUse()) {
            throw new IllegalStateException("Unable to delete relationship[" + id + "] since it is already deleted.");
        }
        ArrayMap<Integer, DefinedProperty> propertyMap = this.getAndDeletePropertyChain(record);
        this.disconnectRelationship(record);
        this.updateNodes(record);
        record.setInUse(false);
        return propertyMap;
    }

    private ArrayMap<Integer, DefinedProperty> getAndDeletePropertyChain(PrimitiveRecord primitive) {
        ArrayMap<Integer, DefinedProperty> result = new ArrayMap<Integer, DefinedProperty>(9, false, true);
        long nextProp = primitive.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordChanges.RecordChange<Long, PropertyRecord, PrimitiveRecord> propertyChange = this.propertyRecords.getOrLoad(nextProp, primitive);
            PropertyRecord propRecord = propertyChange.forChangingData();
            PropertyRecord before = propertyChange.getBefore();
            for (PropertyBlock block : before.getPropertyBlocks()) {
                result.put(block.getKeyIndexId(), block.newPropertyData(this.getPropertyStore()));
            }
            for (PropertyBlock block : propRecord.getPropertyBlocks()) {
                for (DynamicRecord valueRecord : block.getValueRecords()) {
                    assert (valueRecord.inUse());
                    valueRecord.setInUse(false);
                    propRecord.addDeletedRecord(valueRecord);
                }
            }
            nextProp = propRecord.getNextProp();
            propRecord.setInUse(false);
            propRecord.setChanged(primitive);
            propRecord.getPropertyBlocks().clear();
        }
        return result;
    }

    private void disconnectRelationship(RelationshipRecord rel) {
        RelationshipRecord nextRel;
        boolean changed;
        RelationshipRecord prevRel;
        LockableRelationship lockableRel;
        if (rel.getFirstPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.relRecords.getOrLoad(rel.getFirstPrevRel(), null).forChangingLinkage();
            changed = false;
            if (prevRel.getFirstNode() == rel.getFirstNode()) {
                prevRel.setFirstNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getFirstNode()) {
                prevRel.setSecondNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getFirstNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.relRecords.getOrLoad(rel.getFirstNextRel(), null).forChangingLinkage();
            changed = false;
            if (nextRel.getFirstNode() == rel.getFirstNode()) {
                nextRel.setFirstPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getFirstNode()) {
                nextRel.setSecondPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
        if (rel.getSecondPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.relRecords.getOrLoad(rel.getSecondPrevRel(), null).forChangingLinkage();
            changed = false;
            if (prevRel.getFirstNode() == rel.getSecondNode()) {
                prevRel.setFirstNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getSecondNode()) {
                prevRel.setSecondNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getSecondNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.relRecords.getOrLoad(rel.getSecondNextRel(), null).forChangingLinkage();
            changed = false;
            if (nextRel.getFirstNode() == rel.getSecondNode()) {
                nextRel.setFirstPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getSecondNode()) {
                nextRel.setSecondPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
    }

    private void getWriteLock(Relationship lockableRel) {
        this.state.acquireWriteLock(lockableRel);
    }

    @Override
    public long getRelationshipChainPosition(long nodeId) {
        return this.nodeRecords.getOrLoad(nodeId, null).getBefore().getNextRel();
    }

    @Override
    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return ReadTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), this.getRelationshipStore());
    }

    private void updateNodes(RelationshipRecord rel) {
        if (rel.getFirstPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord firstNode = this.nodeRecords.getOrLoad(rel.getFirstNode(), null).forChangingLinkage();
            firstNode.setNextRel(rel.getFirstNextRel());
        }
        if (rel.getSecondPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord secondNode = this.nodeRecords.getOrLoad(rel.getSecondNode(), null).forChangingLinkage();
            secondNode.setNextRel(rel.getSecondNextRel());
        }
    }

    @Override
    public void relRemoveProperty(long relId, int propertyKey) {
        RecordChanges.RecordChange<Long, RelationshipRecord, Object> rel = this.relRecords.getOrLoad(relId, null);
        RelationshipRecord relRecord = rel.forReadingLinkage();
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property remove on relationship[" + relId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(relRecord));
        this.removeProperty(relRecord, rel, propertyKey);
    }

    @Override
    public void relLoadProperties(long relId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        RelationshipRecord relRecord;
        RecordChanges.RecordChange<Long, RelationshipRecord, Void> rel = this.relRecords.getIfLoaded(relId);
        if (rel != null) {
            if (rel.isCreated()) {
                return;
            }
            if (!rel.forReadingLinkage().inUse() && !light) {
                throw new IllegalStateException("Relationship[" + relId + "] has been deleted in this tx");
            }
        }
        if (!(relRecord = this.relRecords.getOrLoad(relId, null).forReadingLinkage()).inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        ReadTransaction.loadProperties(this.getPropertyStore(), relRecord.getNextProp(), receiver);
    }

    private Iterator<DefinedProperty> nodeFullyLoadProperties(long nodeId) {
        IteratingPropertyReceiver properties = new IteratingPropertyReceiver();
        this.nodeLoadProperties(nodeId, this.committed, properties);
        return properties;
    }

    @Override
    public void nodeLoadProperties(long nodeId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        NodeRecord nodeRecord;
        RecordChanges.RecordChange<Long, NodeRecord, Void> node = this.nodeRecords.getIfLoaded(nodeId);
        if (node != null) {
            if (node.isCreated()) {
                return;
            }
            if (!node.forReadingLinkage().inUse() && !light) {
                throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
            }
        }
        if (!(nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forReadingLinkage()).inUse()) {
            throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
        }
        ReadTransaction.loadProperties(this.getPropertyStore(), nodeRecord.getNextProp(), receiver);
    }

    @Override
    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        RecordChanges.RecordChange<Long, NodeRecord, Object> node = this.nodeRecords.getOrLoad(nodeId, null);
        NodeRecord nodeRecord = node.forReadingLinkage();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property remove on node[" + nodeId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(nodeRecord));
        this.removeProperty(nodeRecord, node, propertyKey);
    }

    private <P extends PrimitiveRecord> void removeProperty(P primitive, RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange, int propertyKey) {
        long propertyId = this.findPropertyRecordContaining(primitive, propertyKey);
        RecordChanges.RecordChange<Long, PropertyRecord, PrimitiveRecord> recordChange = this.propertyRecords.getOrLoad(propertyId, (PrimitiveRecord)primitiveRecordChange.forReadingLinkage());
        PropertyRecord propRecord = recordChange.forChangingData();
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        PropertyBlock block = propRecord.removePropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        for (DynamicRecord valueRecord : block.getValueRecords()) {
            assert (valueRecord.inUse());
            valueRecord.setInUse(false, block.getType().intValue());
            propRecord.addDeletedRecord(valueRecord);
        }
        if (propRecord.size() > 0) {
            propRecord.setChanged((PrimitiveRecord)primitiveRecordChange.forReadingLinkage());
            assert (this.assertPropertyChain((PrimitiveRecord)primitiveRecordChange.forReadingLinkage()));
        } else {
            this.unlinkPropertyRecord(propRecord, primitiveRecordChange);
        }
    }

    private <P extends PrimitiveRecord> void unlinkPropertyRecord(PropertyRecord propRecord, RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.assertPropertyChain(primitive));
        assert (propRecord.size() == 0);
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(nextProp);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.propertyRecords.getOrLoad(prevProp, primitive).forChangingLinkage();
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            prevPropRecord.setChanged(primitive);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.propertyRecords.getOrLoad(nextProp, primitive).forChangingLinkage();
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            nextPropRecord.setChanged(primitive);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        propRecord.setChanged(primitive);
        assert (this.assertPropertyChain(primitive));
    }

    @Override
    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        RecordChanges.RecordChange<Long, RelationshipRecord, Object> rel = this.relRecords.getOrLoad(relId, null);
        if (!rel.forReadingLinkage().inUse()) {
            throw new IllegalStateException("Property change on relationship[" + relId + "] illegal since it has been deleted.");
        }
        return this.primitiveChangeProperty(rel, propertyKey, value);
    }

    @Override
    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        RecordChanges.RecordChange<Long, NodeRecord, Object> node = this.nodeRecords.getOrLoad(nodeId, null);
        if (!node.forReadingLinkage().inUse()) {
            throw new IllegalStateException("Property change on node[" + nodeId + "] illegal since it has been deleted.");
        }
        return this.primitiveChangeProperty(node, propertyKey, value);
    }

    private long findPropertyRecordContaining(PrimitiveRecord primitive, int propertyKey) {
        long propertyRecordId = primitive.getNextProp();
        while (!Record.NO_NEXT_PROPERTY.is(propertyRecordId)) {
            PropertyRecord propertyRecord = this.propertyRecords.getOrLoad(propertyRecordId, primitive).forReadingLinkage();
            if (propertyRecord.getPropertyBlock(propertyKey) != null) {
                return propertyRecordId;
            }
            propertyRecordId = propertyRecord.getNextProp();
        }
        throw new IllegalStateException("No property record in property chain for " + primitive + " contained property with key " + propertyKey);
    }

    private <P extends PrimitiveRecord> DefinedProperty primitiveChangeProperty(RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange, int propertyKey, Object value) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.assertPropertyChain(primitive));
        long propertyId = this.findPropertyRecordContaining(primitive, propertyKey);
        PropertyRecord propertyRecord = this.propertyRecords.getOrLoad(propertyId, primitive).forChangingData();
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it has been deleted.");
        }
        PropertyBlock block = propertyRecord.getPropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        propertyRecord.setChanged(primitive);
        for (DynamicRecord record : block.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, block.getType().intValue());
            propertyRecord.addDeletedRecord(record);
        }
        this.getPropertyStore().encodeValue(block, propertyKey, value);
        if (propertyRecord.size() > PropertyType.getPayloadSize()) {
            propertyRecord.removePropertyBlock(propertyKey);
            this.addPropertyBlockToPrimitive(block, primitiveRecordChange);
        }
        assert (this.assertPropertyChain(primitive));
        return Property.property(propertyKey, value);
    }

    private <P extends PrimitiveRecord> DefinedProperty addPropertyToPrimitive(RecordChanges.RecordChange<Long, P, Void> node, int propertyKey, Object value) {
        PrimitiveRecord record = (PrimitiveRecord)node.forReadingLinkage();
        assert (this.assertPropertyChain(record));
        PropertyBlock block = new PropertyBlock();
        this.getPropertyStore().encodeValue(block, propertyKey, value);
        this.addPropertyBlockToPrimitive(block, node);
        assert (this.assertPropertyChain(record));
        return Property.property(propertyKey, value);
    }

    @Override
    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        RecordChanges.RecordChange<Long, RelationshipRecord, Object> rel = this.relRecords.getOrLoad(relId, null);
        RelationshipRecord relRecord = rel.forReadingLinkage();
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property add on relationship[" + relId + "] illegal since it has been deleted.");
        }
        return this.addPropertyToPrimitive(rel, propertyKey, value);
    }

    @Override
    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        RecordChanges.RecordChange<Long, NodeRecord, Object> node = this.nodeRecords.getOrLoad(nodeId, null);
        NodeRecord nodeRecord = node.forReadingLinkage();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property add on node[" + nodeId + "] illegal since it has been deleted.");
        }
        return this.addPropertyToPrimitive(node, propertyKey, value);
    }

    private <P extends PrimitiveRecord> void addPropertyBlockToPrimitive(PropertyBlock block, RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.assertPropertyChain(primitive));
        int newBlockSizeInBytes = block.getSize();
        PropertyRecord host = null;
        long firstProp = primitive.getNextProp();
        if (firstProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordChanges.RecordChange<Long, PropertyRecord, PrimitiveRecord> change = this.propertyRecords.getOrLoad(firstProp, primitive);
            PropertyRecord propRecord = change.forReadingLinkage();
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            assert (propRecord.inUse()) : propRecord;
            int propSize = propRecord.size();
            assert (propSize > 0) : propRecord;
            if (propSize + newBlockSizeInBytes <= PropertyType.getPayloadSize()) {
                host = propRecord = change.forChangingData();
                host.addPropertyBlock(block);
                host.setChanged(primitive);
            }
        }
        if (host == null) {
            host = this.propertyRecords.create(this.getPropertyStore().nextId(), primitive).forChangingData();
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = this.propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(host.getId());
                host.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(host.getId());
            host.addPropertyBlock(block);
            host.setInUse(true);
        }
        assert (this.assertPropertyChain(primitive));
    }

    @Override
    public void relationshipCreate(long id, int type, long firstNodeId, long secondNodeId) {
        NodeRecord firstNode = this.nodeRecords.getOrLoad(firstNodeId, null).forChangingLinkage();
        if (!firstNode.inUse()) {
            throw new IllegalStateException("First node[" + firstNodeId + "] is deleted and cannot be used to create a relationship");
        }
        NodeRecord secondNode = this.nodeRecords.getOrLoad(secondNodeId, null).forChangingLinkage();
        if (!secondNode.inUse()) {
            throw new IllegalStateException("Second node[" + secondNodeId + "] is deleted and cannot be used to create a relationship");
        }
        RelationshipRecord record = this.relRecords.create(id, null).forChangingLinkage();
        record.setLinks(firstNodeId, secondNodeId, type);
        record.setInUse(true);
        record.setCreated();
        this.connectRelationship(firstNode, secondNode, record);
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel) {
        assert (firstNode.getNextRel() != rel.getId());
        assert (secondNode.getNextRel() != rel.getId());
        rel.setFirstNextRel(firstNode.getNextRel());
        rel.setSecondNextRel(secondNode.getNextRel());
        this.connect(firstNode, rel);
        this.connect(secondNode, rel);
        firstNode.setNextRel(rel.getId());
        secondNode.setNextRel(rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel) {
        if (node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            LockableRelationship lockableRel = new LockableRelationship(node.getNextRel());
            this.getWriteLock(lockableRel);
            RelationshipRecord nextRel = this.relRecords.getOrLoad(node.getNextRel(), null).forChangingLinkage();
            boolean changed = false;
            if (nextRel.getFirstNode() == node.getId()) {
                nextRel.setFirstPrevRel(rel.getId());
                changed = true;
            }
            if (nextRel.getSecondNode() == node.getId()) {
                nextRel.setSecondPrevRel(rel.getId());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(node + " dont match " + nextRel);
            }
        }
    }

    @Override
    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    @Override
    public Token[] loadAllPropertyKeyTokens() {
        PropertyKeyTokenStore indexStore = this.getPropertyStore().getPropertyKeyTokenStore();
        return indexStore.getTokens(Integer.MAX_VALUE);
    }

    @Override
    public Token[] loadAllLabelTokens() {
        return this.neoStore.getLabelTokenStore().getTokens(Integer.MAX_VALUE);
    }

    @Override
    public void createPropertyKeyToken(String key, int id) {
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        PropertyKeyTokenStore propIndexStore = this.getPropertyStore().getPropertyKeyTokenStore();
        Collection<DynamicRecord> nameRecords = propIndexStore.allocateNameRecords(PropertyStore.encodeString(key));
        record.setNameId((int)IteratorUtil.first(nameRecords).getId());
        record.addNameRecords(nameRecords);
        this.addPropertyKeyTokenRecord(record);
    }

    @Override
    public void createLabelToken(String name, int id) {
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        LabelTokenStore labelTokenStore = this.getLabelTokenStore();
        Collection<DynamicRecord> nameRecords = labelTokenStore.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)IteratorUtil.first(nameRecords).getId());
        record.addNameRecords(nameRecords);
        this.addLabelIdRecord(record);
    }

    @Override
    public void createRelationshipTypeToken(int id, String name) {
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> typeNameRecords = this.getRelationshipTypeStore().allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)IteratorUtil.first(typeNameRecords).getId());
        record.addNameRecords(typeNameRecords);
        this.addRelationshipTypeRecord(record);
    }

    void addRelationshipTypeRecord(RelationshipTypeTokenRecord record) {
        if (this.relationshipTypeTokenRecords == null) {
            this.relationshipTypeTokenRecords = new HashMap<Integer, RelationshipTypeTokenRecord>();
        }
        this.relationshipTypeTokenRecords.put(record.getId(), record);
    }

    void addLabelIdRecord(LabelTokenRecord record) {
        if (this.labelTokenRecords == null) {
            this.labelTokenRecords = new HashMap<Integer, LabelTokenRecord>();
        }
        this.labelTokenRecords.put(record.getId(), record);
    }

    void addPropertyKeyTokenRecord(PropertyKeyTokenRecord record) {
        if (this.propertyKeyTokenRecords == null) {
            this.propertyKeyTokenRecords = new HashMap<Integer, PropertyKeyTokenRecord>();
        }
        this.propertyKeyTokenRecords.put(record.getId(), record);
    }

    @Override
    public void destroy() {
        this.xaConnection.destroy();
    }

    @Override
    public void setXaConnection(XaConnection connection) {
        this.xaConnection = connection;
    }

    @Override
    public Token[] loadRelationshipTypes() {
        Token[] relTypeData = this.neoStore.getRelationshipTypeStore().getTokens(Integer.MAX_VALUE);
        Token[] rawRelTypeData = new Token[relTypeData.length];
        for (int i = 0; i < relTypeData.length; ++i) {
            rawRelTypeData[i] = new Token(relTypeData[i].name(), relTypeData[i].id());
        }
        return rawRelTypeData;
    }

    private boolean assertPropertyChain(PrimitiveRecord primitive) {
        LinkedList<PropertyRecord> toCheck = new LinkedList<PropertyRecord>();
        long nextIdToFetch = primitive.getNextProp();
        while (nextIdToFetch != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.propertyRecords.getOrLoad(nextIdToFetch, primitive).forReadingLinkage();
            toCheck.add(propRecord);
            assert (propRecord.inUse()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            nextIdToFetch = propRecord.getNextProp();
        }
        if (toCheck.isEmpty()) {
            assert (primitive.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive;
            return true;
        }
        PropertyRecord first = (PropertyRecord)toCheck.get(0);
        PropertyRecord last = (PropertyRecord)toCheck.get(toCheck.size() - 1);
        assert (first.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        assert (last.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        PropertyRecord previous = first;
        for (int i = 1; i < toCheck.size(); ++i) {
            PropertyRecord current = (PropertyRecord)toCheck.get(i);
            assert (current.getPrevProp() == previous.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            assert (previous.getNextProp() == current.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            previous = current;
        }
        return true;
    }

    private RecordChanges.RecordChange<Long, NeoStoreRecord, Void> getOrLoadNeoStoreRecord() {
        if (this.neoStoreRecord == null) {
            this.neoStoreRecord = new RecordChanges<Long, NeoStoreRecord, Void>(new RecordChanges.Loader<Long, NeoStoreRecord, Void>(){

                @Override
                public NeoStoreRecord newUnused(Long key, Void additionalData) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NeoStoreRecord load(Long key, Void additionalData) {
                    return WriteTransaction.this.neoStore.asRecord();
                }

                @Override
                public void ensureHeavy(NeoStoreRecord record) {
                }

                @Override
                public NeoStoreRecord clone(NeoStoreRecord neoStoreRecord) {
                    throw new UnsupportedOperationException("Clone on NeoStoreRecord");
                }
            }, false);
        }
        return this.neoStoreRecord.getOrLoad(0L, null);
    }

    @Override
    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        PropertyBlock block = new PropertyBlock();
        this.getPropertyStore().encodeValue(block, propertyKey, value);
        RecordChanges.RecordChange<Long, NeoStoreRecord, Void> change = this.getOrLoadNeoStoreRecord();
        this.addPropertyBlockToPrimitive(block, change);
        assert (this.assertPropertyChain(change.forReadingLinkage()));
        return Property.property(propertyKey, value);
    }

    @Override
    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        return this.primitiveChangeProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value);
    }

    @Override
    public void graphRemoveProperty(int propertyKey) {
        RecordChanges.RecordChange<Long, NeoStoreRecord, Void> recordChange = this.getOrLoadNeoStoreRecord();
        this.removeProperty((PrimitiveRecord)recordChange.forReadingLinkage(), recordChange, propertyKey);
    }

    @Override
    public void graphLoadProperties(boolean light, NeoStoreTransaction.PropertyReceiver records) {
        ReadTransaction.loadProperties(this.getPropertyStore(), this.getOrLoadNeoStoreRecord().forReadingLinkage().getNextProp(), records);
    }

    @Override
    public void createSchemaRule(SchemaRule schemaRule) {
        for (DynamicRecord change : this.schemaRuleChanges.create(schemaRule.getId(), schemaRule).forChangingData()) {
            change.setInUse(true);
            change.setCreated();
        }
    }

    @Override
    public void dropSchemaRule(SchemaRule rule) {
        RecordChanges.RecordChange<Long, Collection<DynamicRecord>, SchemaRule> change = this.schemaRuleChanges.getOrLoad(rule.getId(), rule);
        Collection<DynamicRecord> records = change.forChangingData();
        for (DynamicRecord record : records) {
            record.setInUse(false);
        }
    }

    @Override
    public void addLabelToNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).add(labelId, this.getNodeStore());
    }

    @Override
    public void removeLabelFromNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).remove(labelId, this.getNodeStore());
    }

    @Override
    public PrimitiveLongIterator getLabelsForNode(long nodeId) {
        NodeRecord node = this.getNodeStore().getRecord(nodeId);
        return IteratorUtil.asPrimitiveIterator(NodeLabelsField.parseLabelsField(node).get(this.getNodeStore()));
    }

    @Override
    public void setConstraintIndexOwner(IndexRule indexRule, long constraintId) {
        RecordChanges.RecordChange<Long, Collection<DynamicRecord>, SchemaRule> change = this.schemaRuleChanges.getOrLoad(indexRule.getId(), indexRule);
        Collection<DynamicRecord> records = change.forChangingData();
        indexRule = indexRule.withOwningConstraint(constraintId);
        records.clear();
        records.addAll(this.getSchemaStore().allocateFrom(indexRule));
    }

    private static class LockableRelationship
    implements Relationship {
        private final long id;

        LockableRelationship(long id) {
            this.id = id;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getEndNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node[] getNodes() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getOtherNode(Node node) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getStartNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public RelationshipType getType() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean isType(RelationshipType type) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean hasProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object removeProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public void setProperty(String key, Object value) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        public boolean equals(Object o) {
            return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public String toString() {
            return "Lockable relationship #" + this.getId();
        }
    }

    static class CommandSorter
    implements Comparator<Command>,
    Serializable {
        CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }

    private static class LabelChangeSummary {
        private static final long[] NO_LABELS = new long[0];
        private final long[] addedLabels;
        private final long[] removedLabels;

        LabelChangeSummary(long[] labelsBefore, long[] labelsAfter) {
            long[] addedLabels = new long[labelsAfter.length];
            long[] removedLabels = new long[labelsBefore.length];
            int addedLabelsCursor = 0;
            int removedLabelsCursor = 0;
            for (long labelAfter : labelsAfter) {
                if (Arrays.binarySearch(labelsBefore, labelAfter) >= 0) continue;
                addedLabels[addedLabelsCursor++] = labelAfter;
            }
            for (long labelBefore : labelsBefore) {
                if (Arrays.binarySearch(labelsAfter, labelBefore) >= 0) continue;
                removedLabels[removedLabelsCursor++] = labelBefore;
            }
            this.addedLabels = this.shrink(addedLabels, addedLabelsCursor);
            this.removedLabels = this.shrink(removedLabels, removedLabelsCursor);
        }

        private long[] shrink(long[] array, int toLength) {
            if (toLength == 0) {
                return NO_LABELS;
            }
            return array.length == toLength ? array : Arrays.copyOf(array, toLength);
        }

        public boolean hasAddedLabels() {
            return this.addedLabels.length > 0;
        }

        public boolean hasRemovedLabels() {
            return this.removedLabels.length > 0;
        }

        public long[] getAddedLabels() {
            return this.addedLabels;
        }

        public long[] getRemovedLabels() {
            return this.removedLabels;
        }
    }
}

