/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.PrimitiveIntPredicate;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.scan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    public NeoStoreIndexStoreView(NeoStore neoStore) {
        this.propertyStore = neoStore.getPropertyStore();
        this.nodeStore = neoStore.getNodeStore();
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodesWithPropertyAndLabel(IndexDescriptor descriptor, Visitor<NodePropertyUpdate, FAILURE> visitor) {
        LabelsReference labelsReference = new LabelsReference();
        NodePropertyUpdateProcessor<FAILURE> processor = new NodePropertyUpdateProcessor<FAILURE>(this.propertyStore, NeoStoreIndexStoreView.singleIntPredicate(descriptor.getPropertyKeyId()), labelsReference, visitor);
        NodeLabelFilterPredicate predicate = new NodeLabelFilterPredicate(this.nodeStore, NeoStoreIndexStoreView.singleIntPredicate(descriptor.getLabelId()), labelsReference);
        return new ProcessStoreScan<FAILURE>(processor, predicate);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, int[] propertyKeyIds, Visitor<NodePropertyUpdate, FAILURE> propertyUpdateVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor) {
        LabelsReference labelsReference = new LabelsReference();
        NodePropertyUpdateProcessor<FAILURE> propertyUpdateProcessor = new NodePropertyUpdateProcessor<FAILURE>(this.propertyStore, NeoStoreIndexStoreView.multipleIntPredicate(propertyKeyIds), labelsReference, propertyUpdateVisitor);
        NodeLabelFilterPredicate predicate = new NodeLabelFilterPredicate(this.nodeStore, NeoStoreIndexStoreView.multipleIntPredicate(labelIds), labelsReference);
        NodeProcessor<FAILURE> processor = new NodeProcessor<FAILURE>(propertyUpdateProcessor, predicate, labelsReference, labelUpdateVisitor);
        return new ProcessStoreScan<FAILURE>(processor, Predicates.TRUE());
    }

    private static PrimitiveIntPredicate singleIntPredicate(final int acceptedValue) {
        return new PrimitiveIntPredicate(){

            @Override
            public boolean accept(int value) {
                return value == acceptedValue;
            }
        };
    }

    private static PrimitiveIntPredicate multipleIntPredicate(final int ... acceptedValues) {
        return new PrimitiveIntPredicate(){

            @Override
            public boolean accept(int value) {
                for (int acceptedValue : acceptedValues) {
                    if (value != acceptedValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Predicate<Pair<Integer, Object>> notNull() {
        return new Predicate<Pair<Integer, Object>>(){

            @Override
            public boolean accept(Pair<Integer, Object> item) {
                return item != null;
            }
        };
    }

    private Function<PropertyBlock, Pair<Integer, Object>> propertiesThatAreIn(final Set<Integer> propertyKeys) {
        return new Function<PropertyBlock, Pair<Integer, Object>>(){

            @Override
            public Pair<Integer, Object> apply(PropertyBlock property) {
                int keyId = property.getKeyIndexId();
                if (propertyKeys.contains(keyId)) {
                    NeoStoreIndexStoreView.this.propertyStore.ensureHeavy(property);
                    Object propertyValue = property.getType().getValue(property, NeoStoreIndexStoreView.this.propertyStore);
                    return Pair.of(property.getKeyIndexId(), propertyValue);
                }
                return null;
            }
        };
    }

    private class ProcessStoreScan<FAILURE extends Exception>
    implements StoreScan<FAILURE> {
        private final RecordStore.Processor<FAILURE> processor;
        private final Predicate<NodeRecord> predicate;

        public ProcessStoreScan(RecordStore.Processor<FAILURE> processor, Predicate<NodeRecord> predicate) {
            this.processor = processor;
            this.predicate = predicate;
        }

        @Override
        public void run() throws FAILURE {
            this.processor.applyFiltered(NeoStoreIndexStoreView.this.nodeStore, this.predicate);
        }

        @Override
        public void stop() {
            this.processor.stopScanning();
        }
    }

    private class NodeLabelFilterPredicate
    implements Predicate<NodeRecord> {
        private final NodeStore nodeStore;
        private final PrimitiveIntPredicate labelPredicate;
        private final LabelsReference labelsReference;

        public NodeLabelFilterPredicate(NodeStore nodeStore, PrimitiveIntPredicate labelPredicate, LabelsReference labelsReference) {
            this.nodeStore = nodeStore;
            this.labelPredicate = labelPredicate;
            this.labelsReference = labelsReference;
        }

        @Override
        public boolean accept(NodeRecord node) {
            if (node.inUse()) {
                long[] labelsForNode = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
                this.labelsReference.set(labelsForNode);
                for (long nodeLabelId : labelsForNode) {
                    if (!this.labelPredicate.accept(IoPrimitiveUtils.safeCastLongToInt(nodeLabelId))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class NodePropertyUpdateProcessor<FAILURE extends Exception>
    extends RecordStore.Processor<FAILURE> {
        private final PropertyStore propertyStore;
        private final Visitor<NodePropertyUpdate, FAILURE> visitor;
        private final PrimitiveIntPredicate propertyKeyPredicate;
        private final LabelsReference labelsReference;

        public NodePropertyUpdateProcessor(PropertyStore propertyStore, PrimitiveIntPredicate propertyKeyPredicate, LabelsReference labelsReference, Visitor<NodePropertyUpdate, FAILURE> visitor) {
            this.propertyStore = propertyStore;
            this.propertyKeyPredicate = propertyKeyPredicate;
            this.labelsReference = labelsReference;
            this.visitor = visitor;
        }

        @Override
        public void processNode(RecordStore<NodeRecord> nodeStore, NodeRecord node) throws FAILURE {
            long firstPropertyId = node.getCommittedNextProp();
            if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
                return;
            }
            for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
                for (PropertyBlock property : propertyRecord.getPropertyBlocks()) {
                    int propertyKeyId = property.getKeyIndexId();
                    if (!this.propertyKeyPredicate.accept(propertyKeyId)) continue;
                    this.propertyStore.ensureHeavy(property);
                    Object propertyValue = property.getType().getValue(property, this.propertyStore);
                    this.visitor.visit(NodePropertyUpdate.add(node.getId(), propertyKeyId, propertyValue, this.labelsReference.get()));
                }
            }
        }
    }

    private class NodeProcessor<FAILURE extends Exception>
    extends RecordStore.Processor<FAILURE> {
        private final NodePropertyUpdateProcessor<FAILURE> propertyUpdateProcessor;
        private final Predicate<NodeRecord> propertyUpdateFilter;
        private final LabelsReference labelsReference;
        private final Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor;

        NodeProcessor(NodePropertyUpdateProcessor<FAILURE> propertyUpdateProcessor, Predicate<NodeRecord> propertyUpdateFilter, LabelsReference labelsReference, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor) {
            this.propertyUpdateProcessor = propertyUpdateProcessor;
            this.propertyUpdateFilter = propertyUpdateFilter;
            this.labelsReference = labelsReference;
            this.labelUpdateVisitor = labelUpdateVisitor;
        }

        @Override
        public void processNode(RecordStore<NodeRecord> nodeStore, NodeRecord node) throws FAILURE {
            if (!node.inUse()) {
                return;
            }
            boolean processPropertyUpdates = this.propertyUpdateFilter.accept(node);
            this.labelUpdateVisitor.visit(NodeLabelUpdate.labelChanges(node.getId(), NodePropertyUpdate.EMPTY_LONG_ARRAY, this.labelsReference.get()));
            if (processPropertyUpdates) {
                this.propertyUpdateProcessor.processNode(nodeStore, node);
            }
        }
    }

    private static class LabelsReference {
        private long[] labels;

        private LabelsReference() {
        }

        long[] get() {
            return this.labels;
        }

        void set(long[] labels) {
            this.labels = labels;
        }
    }
}

