/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store.labels;

import java.util.Collection;
import java.util.Collections;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.LabelIdArray;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.util.Bits;

public class InlineNodeLabels
implements NodeLabels {
    private static final long[] NO_LABELS = new long[0];
    private static final int LABEL_BITS = 36;
    private final long labelField;
    private final NodeRecord node;

    public InlineNodeLabels(long labelField, NodeRecord node) {
        this.labelField = labelField;
        this.node = node;
    }

    @Override
    public long[] get(NodeStore nodeStore) {
        return InlineNodeLabels.parseInlined(this.labelField);
    }

    @Override
    public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore) {
        if (this.tryInlineInNodeRecord(labelIds, Collections.emptyList())) {
            return Collections.emptyList();
        }
        return new DynamicNodeLabels(0L, this.node).put(labelIds, nodeStore);
    }

    @Override
    public Collection<DynamicRecord> add(long labelId, NodeStore nodeStore) {
        long[] lArray;
        if (InlineNodeLabels.labelCount(this.labelField) == 0) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = labelId;
        } else {
            lArray = LabelIdArray.concatAndSort(InlineNodeLabels.parseInlined(this.labelField), labelId);
        }
        long[] augmentedLabelIds = lArray;
        return this.put(augmentedLabelIds, nodeStore);
    }

    @Override
    public Collection<DynamicRecord> remove(long labelId, NodeStore nodeStore) {
        long[] newLabelIds = LabelIdArray.filter(InlineNodeLabels.parseInlined(this.labelField), labelId);
        boolean inlined = this.tryInlineInNodeRecord(newLabelIds, Collections.emptyList());
        assert (inlined);
        return Collections.emptyList();
    }

    @Override
    public void ensureHeavy(NodeStore nodeStore) {
    }

    boolean tryInlineInNodeRecord(long[] ids, Collection<DynamicRecord> changedDynamicRecords) {
        if (ids.length > 7) {
            return false;
        }
        byte bitsPerLabel = (byte)(ids.length > 0 ? 36 / ids.length : 36);
        long limit = 1L << bitsPerLabel;
        Bits bits = Bits.bits(5);
        for (long id : ids) {
            if (Long.highestOneBit(id) >= limit) {
                return false;
            }
            bits.put(id, (int)bitsPerLabel);
        }
        this.node.setLabelField(InlineNodeLabels.combineLabelCountAndLabelStorage((byte)ids.length, bits.getLongs()[0]), changedDynamicRecords);
        return true;
    }

    private static long[] parseInlined(long labelField) {
        byte numberOfLabels = InlineNodeLabels.labelCount(labelField);
        if (numberOfLabels == 0) {
            return NO_LABELS;
        }
        long existingLabelsField = NodeLabelsField.parseLabelsBody(labelField);
        byte bitsPerLabel = (byte)(36 / numberOfLabels);
        Bits bits = Bits.bitsFromLongs(new long[]{existingLabelsField});
        long[] result = new long[numberOfLabels];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bits.getLong(bitsPerLabel);
        }
        return result;
    }

    private static long combineLabelCountAndLabelStorage(byte labelCount, long labelBits) {
        long labelCountAsLong = labelCount;
        return labelCountAsLong << 36 | labelBits;
    }

    private static byte labelCount(long labelField) {
        return (byte)((labelField & 0xF000000000L) >>> 36);
    }
}

