/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.constraints.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;

public interface IndexProxy {
    public void start() throws IOException;

    public void update(Iterable<NodePropertyUpdate> var1) throws IOException;

    public void recover(Iterable<NodePropertyUpdate> var1) throws IOException;

    public Future<Void> drop() throws IOException;

    public Future<Void> close() throws IOException;

    public IndexDescriptor getDescriptor();

    public SchemaIndexProvider.Descriptor getProviderDescriptor();

    public InternalIndexState getState();

    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException;

    public void force() throws IOException;

    public IndexReader newReader() throws IndexNotFoundKernelException;

    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException;

    public void activate() throws IndexActivationFailedKernelException;

    public void validate() throws ConstraintVerificationFailedKernelException, IndexPopulationFailedKernelException;

    public static class Adapter
    implements IndexProxy {
        public static final Adapter EMPTY = new Adapter();

        @Override
        public void start() {
        }

        @Override
        public void update(Iterable<NodePropertyUpdate> updates) {
        }

        @Override
        public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
        }

        @Override
        public Future<Void> drop() {
            return FutureAdapter.VOID;
        }

        @Override
        public InternalIndexState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void force() {
        }

        @Override
        public Future<Void> close() {
            return FutureAdapter.VOID;
        }

        @Override
        public IndexDescriptor getDescriptor() {
            return null;
        }

        @Override
        public SchemaIndexProvider.Descriptor getProviderDescriptor() {
            return null;
        }

        @Override
        public IndexReader newReader() {
            return IndexReader.EMPTY;
        }

        @Override
        public boolean awaitStoreScanCompleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void activate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
            throw new IllegalStateException("This index isn't failed");
        }
    }
}

