/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public class SchemaStorage {
    private final SchemaStore schemaStore;

    public SchemaStorage(SchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    public IndexRule constraintIndexRule(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(labelId, propertyKeyId);
        if (rule.isConstraintIndex()) {
            return rule;
        }
        throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "is not a constraint index");
    }

    public IndexRule indexRule(int labelId, final int propertyKeyId) throws SchemaRuleNotFoundException {
        Iterator<IndexRule> rules = this.schemaRules(IndexRule.class, labelId, new Predicate<IndexRule>(){

            @Override
            public boolean accept(IndexRule item) {
                return item.getPropertyKey() == propertyKeyId;
            }
        });
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "not found");
        }
        IndexRule rule = rules.next();
        if (rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "found more than one matching index");
        }
        return rule;
    }

    public <T extends SchemaRule> Iterator<T> schemaRules(Class<T> type, int labelId, Predicate<T> predicate) {
        return this.schemaRules(Functions.cast(type), type, labelId, predicate);
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final Class<R> ruleType, final int labelId, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind().getRuleClass() == ruleType && predicate.accept(rule);
            }
        }, this.schemaStore.loadAllSchemaRules()));
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final SchemaRule.Kind kind, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getKind() == kind && predicate.accept(rule);
            }
        }, this.schemaStore.loadAllSchemaRules()));
    }

    public long newRuleId() {
        return this.schemaStore.nextId();
    }

    public UniquenessConstraintRule uniquenessConstraint(int labelId, final int propertyKeyId) throws SchemaRuleNotFoundException {
        Iterator<UniquenessConstraintRule> rules = this.schemaRules(UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule item) {
                return item.containsPropertyKeyId(propertyKeyId);
            }
        });
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "not found");
        }
        UniquenessConstraintRule rule = rules.next();
        if (rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "found more than one matching index");
        }
        return rule;
    }
}

