/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.api.exceptions.ReleaseLocksFailedKernelException;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.SchemaLock;
import org.neo4j.kernel.impl.locking.IndexEntryLock;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;

public class LockHolderImpl
implements LockHolder {
    private final LockManager lockManager;
    private final Transaction tx;
    private final List<LockReleaseCallback> locks = new ArrayList<LockReleaseCallback>();
    private final NodeManager nodeManager;

    public LockHolderImpl(LockManager lockManager, Transaction tx, NodeManager nodeManager) {
        this.lockManager = lockManager;
        this.tx = tx;
        this.nodeManager = nodeManager;
    }

    @Override
    public void acquireNodeReadLock(long nodeId) {
        NodeLock resource = new NodeLock(nodeId);
        this.lockManager.getReadLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.READ, resource));
    }

    @Override
    public void acquireNodeWriteLock(long nodeId) {
        NodeLock resource = new NodeLock(nodeId);
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.WRITE, resource));
    }

    @Override
    public void acquireRelationshipReadLock(long relationshipId) {
        RelationshipLock resource = new RelationshipLock(relationshipId);
        this.lockManager.getReadLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.READ, resource));
    }

    @Override
    public void acquireRelationshipWriteLock(long relationshipId) {
        RelationshipLock resource = new RelationshipLock(relationshipId);
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.WRITE, resource));
    }

    @Override
    public void acquireGraphWriteLock() {
        GraphLock resource = new GraphLock();
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.WRITE, resource));
    }

    @Override
    public void acquireSchemaReadLock() {
        SchemaLock resource = new SchemaLock();
        this.lockManager.getReadLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.READ, resource));
    }

    @Override
    public void acquireSchemaWriteLock() {
        SchemaLock resource = new SchemaLock();
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.WRITE, resource));
    }

    @Override
    public void acquireIndexEntryReadLock(int labelId, int propertyKeyId, String propertyValue) {
        IndexEntryLock resource = new IndexEntryLock(labelId, propertyKeyId, propertyValue);
        this.lockManager.getReadLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.READ, resource));
    }

    @Override
    public void acquireIndexEntryWriteLock(int labelId, int propertyKeyId, String propertyValue) {
        IndexEntryLock resource = new IndexEntryLock(labelId, propertyKeyId, propertyValue);
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(new LockReleaseCallback(LockType.WRITE, resource));
    }

    @Override
    public void releaseLocks() throws ReleaseLocksFailedKernelException {
        ArrayList<LockReleaseCallback> releaseFailures = null;
        Exception releaseException = null;
        for (LockReleaseCallback lockElement : this.locks) {
            try {
                lockElement.release();
            }
            catch (Exception e) {
                releaseException = e;
                if (releaseFailures == null) {
                    releaseFailures = new ArrayList<LockReleaseCallback>();
                }
                releaseFailures.add(lockElement);
            }
        }
        if (releaseException != null) {
            throw new ReleaseLocksFailedKernelException("Unable to release locks: " + releaseFailures + ".", releaseException);
        }
    }

    private class GraphLock
    extends EntityLock
    implements GraphProperties {
        public GraphLock() {
            super(-1L);
        }

        @Override
        public NodeManager getNodeManager() {
            return LockHolderImpl.this.nodeManager;
        }

        public boolean equals(Object o) {
            return o instanceof GraphProperties && this.getNodeManager().equals(((GraphProperties)o).getNodeManager());
        }
    }

    private class RelationshipLock
    extends EntityLock
    implements Relationship {
        public RelationshipLock(long id) {
            super(id);
        }

        @Override
        public Node getStartNode() {
            throw this.unsupportedOperation();
        }

        @Override
        public Node getEndNode() {
            throw this.unsupportedOperation();
        }

        @Override
        public Node getOtherNode(Node node) {
            throw this.unsupportedOperation();
        }

        @Override
        public Node[] getNodes() {
            throw this.unsupportedOperation();
        }

        @Override
        public RelationshipType getType() {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean isType(RelationshipType type) {
            throw this.unsupportedOperation();
        }

        public boolean equals(Object o) {
            return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
        }
    }

    private class NodeLock
    extends EntityLock
    implements Node {
        public NodeLock(long id) {
            super(id);
        }

        @Override
        public Iterable<Relationship> getRelationships() {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship() {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(RelationshipType type, Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            throw this.unsupportedOperation();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
            throw this.unsupportedOperation();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
            throw this.unsupportedOperation();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
            throw this.unsupportedOperation();
        }

        @Override
        public void addLabel(Label label) {
            throw this.unsupportedOperation();
        }

        @Override
        public void removeLabel(Label label) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasLabel(Label label) {
            throw this.unsupportedOperation();
        }

        @Override
        public ResourceIterable<Label> getLabels() {
            throw this.unsupportedOperation();
        }

        public boolean equals(Object o) {
            return o instanceof Node && this.getId() == ((Node)o).getId();
        }
    }

    private abstract class EntityLock
    implements PropertyContainer {
        private final long id;

        public EntityLock(long id) {
            this.id = id;
        }

        public String toString() {
            return String.format("%s[id=%d]", this.getClass().getSimpleName(), this.id);
        }

        public long getId() {
            return this.id;
        }

        public void delete() {
            throw this.unsupportedOperation();
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasProperty(String key) {
            throw this.unsupportedOperation();
        }

        @Override
        public Object getProperty(String key) {
            throw this.unsupportedOperation();
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw this.unsupportedOperation();
        }

        @Override
        public void setProperty(String key, Object value) {
            throw this.unsupportedOperation();
        }

        @Override
        public Object removeProperty(String key) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw this.unsupportedOperation();
        }

        @Override
        @Deprecated
        public Iterable<Object> getPropertyValues() {
            throw this.unsupportedOperation();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        protected UnsupportedOperationException unsupportedOperation() {
            return new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support this operation.");
        }
    }

    private final class LockReleaseCallback {
        private final LockType lockType;
        private final Object lock;

        public LockReleaseCallback(LockType lockType, Object lock) {
            this.lockType = lockType;
            this.lock = lock;
        }

        public void release() {
            this.lockType.release(LockHolderImpl.this.lockManager, this.lock, LockHolderImpl.this.tx);
        }

        public String toString() {
            return String.format("%s_LOCK(%s)", this.lockType.name(), this.lock);
        }
    }
}

