/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionImplementation;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.Transactor;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.api.scan.LabelScanStore;
import org.neo4j.kernel.impl.api.CachingStatementOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.DefaultLegacyKernelOperations;
import org.neo4j.kernel.impl.api.LegacyAutoIndexAuxStoreOps;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StoreStatementOperations;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final AbstractTransactionManager transactionManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final PersistenceManager persistenceManager;
    private final XaDataSourceManager dataSourceManager;
    private final LockManager lockManager;
    private final DependencyResolver dependencyResolver;
    private final UpdateableSchemaState schemaState;
    private final boolean readOnly;
    private final SchemaWriteGuard schemaWriteGuard;
    private IndexingService indexService;
    private NeoStore neoStore;
    private NodeManager nodeManager;
    private PersistenceCache persistenceCache;
    private StatementOperationParts statementOperations;
    private SchemaCache schemaCache;
    private SchemaIndexProviderMap providerMap = null;
    private LegacyKernelOperations legacyKernelOperations;
    private LabelScanStore labelScanStore;
    private boolean isShutdown = false;

    public Kernel(AbstractTransactionManager transactionManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, PersistenceManager persistenceManager, XaDataSourceManager dataSourceManager, LockManager lockManager, UpdateableSchemaState schemaState, DependencyResolver dependencyResolver, boolean readOnly, SchemaWriteGuard schemaWriteGuard) {
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.persistenceManager = persistenceManager;
        this.dataSourceManager = dataSourceManager;
        this.lockManager = lockManager;
        this.dependencyResolver = dependencyResolver;
        this.schemaState = schemaState;
        this.readOnly = readOnly;
        this.schemaWriteGuard = schemaWriteGuard;
    }

    @Override
    public void start() {
        this.nodeManager = this.dependencyResolver.resolveDependency(NodeManager.class);
        this.dataSourceManager.addDataSourceRegistrationListener(XaDataSourceManager.neoStoreListener(new DataSourceRegistrationListener(){

            @Override
            public void registeredDataSource(XaDataSource ds) {
                NeoStoreXaDataSource neoDataSource = (NeoStoreXaDataSource)ds;
                Kernel.this.neoStore = neoDataSource.getNeoStore();
                Kernel.this.indexService = neoDataSource.getIndexService();
                Kernel.this.labelScanStore = neoDataSource.getLabelScanStore();
                Kernel.this.providerMap = neoDataSource.getProviderMap();
                Kernel.this.persistenceCache = neoDataSource.getPersistenceCache();
                Kernel.this.schemaCache = neoDataSource.getSchemaCache();
                for (SchemaRule schemaRule : IteratorUtil.loop(Kernel.this.neoStore.getSchemaStore().loadAllSchemaRules())) {
                    Kernel.this.schemaCache.addSchemaRule(schemaRule);
                }
            }

            @Override
            public void unregisteredDataSource(XaDataSource ds) {
                Kernel.this.neoStore = null;
            }
        }));
    }

    @Override
    public void bootstrapAfterRecovery() {
        this.statementOperations = this.buildStatementOperations();
        this.legacyKernelOperations = new DefaultLegacyKernelOperations(this.nodeManager);
    }

    @Override
    public void stop() {
        this.isShutdown = true;
    }

    @Override
    public KernelTransaction newTransaction() {
        this.checkIfShutdown();
        return new KernelTransactionImplementation(this.statementOperations, this.legacyKernelOperations, this.readOnly, this.schemaWriteGuard, this.labelScanStore, this.indexService, this.lockManager, this.transactionManager, this.nodeManager, this.persistenceCache, this.schemaState, this.persistenceManager, this.providerMap, this.neoStore);
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    private StatementOperationParts buildStatementOperations() {
        StoreStatementOperations context = new StoreStatementOperations(this.propertyKeyTokenHolder, this.labelTokenHolder, this.relationshipTypeTokenHolder, new SchemaStorage(this.neoStore.getSchemaStore()), this.neoStore, this.persistenceManager, this.indexService);
        StatementOperationParts parts = new StatementOperationParts(context, context, context, context, context, null, null).additionalPart(AuxiliaryStoreOperations.class, context);
        CachingStatementOperations cachingContext = new CachingStatementOperations(parts.entityReadOperations(), parts.schemaReadOperations(), this.persistenceCache, this.schemaCache);
        parts = parts.override(null, null, cachingContext, null, cachingContext, null, null, new Object[0]);
        AuxiliaryStoreOperations auxStoreOperations = parts.resolve(AuxiliaryStoreOperations.class);
        auxStoreOperations = new LegacyAutoIndexAuxStoreOps(auxStoreOperations, this.propertyKeyTokenHolder, this.nodeManager.getNodePropertyTrackers(), this.nodeManager.getRelationshipPropertyTrackers(), this.nodeManager);
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(parts.entityReadOperations(), parts.schemaReadOperations(), auxStoreOperations, new ConstraintIndexCreator(new Transactor(this.transactionManager), this.indexService));
        parts = parts.override(null, null, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(this.schemaState), new Object[0]);
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations());
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, new Object[0]);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, new Object[0]);
        return parts;
    }
}

