/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.cache.SizeOfObject;

public abstract class DefinedProperty
extends Property
implements SizeOfObject {
    private static final ArrayUtil.ArrayEquality PROPERTY_EQUALITY = new ArrayUtil.ArrayEquality(){

        @Override
        public boolean typeEquals(Class<?> firstType, Class<?> otherType) {
            return true;
        }

        @Override
        public boolean itemEquals(Object lhs, Object rhs) {
            return DefinedProperty.compareValues(lhs, rhs);
        }
    };

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public abstract Object value();

    @Override
    public Object value(Object defaultValue) {
        return this.value();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[propertyKeyId=" + this.propertyKeyId() + ", value=" + this.valueAsString() + "]";
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DefinedProperty that = (DefinedProperty)o;
            return this.propertyKeyId == that.propertyKeyId && this.hasEqualValue(that);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.propertyKeyId ^ this.valueHash();
    }

    abstract int valueHash();

    abstract boolean hasEqualValue(DefinedProperty var1);

    @Override
    public String valueAsString() {
        Object value = this.value();
        if (value.getClass().isArray()) {
            return ArrayUtil.toString(value);
        }
        return value.toString();
    }

    @Override
    public String stringValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a String", value, value.getClass().getSimpleName()));
    }

    @Override
    public String stringValue(String defaultValue) {
        return this.stringValue();
    }

    @Override
    public Number numberValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a Number", value, value.getClass().getSimpleName()));
    }

    @Override
    public Number numberValue(Number defaultValue) {
        return this.numberValue();
    }

    @Override
    public int intValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not an int", value, value.getClass().getSimpleName()));
    }

    @Override
    public int intValue(int defaultValue) {
        return this.intValue();
    }

    @Override
    public long longValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a long", value, value.getClass().getSimpleName()));
    }

    @Override
    public long longValue(long defaultValue) {
        return this.longValue();
    }

    @Override
    public boolean booleanValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a boolean", value, value.getClass().getSimpleName()));
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return this.booleanValue();
    }

    DefinedProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    protected boolean valueCompare(Object lhs, Object rhs) {
        return DefinedProperty.compareValues(lhs, rhs);
    }

    private static boolean compareValues(Object lhs, Object rhs) {
        if (lhs instanceof Number && rhs instanceof Number) {
            return DefinedProperty.compareNumbers((Number)lhs, (Number)rhs);
        }
        if ((lhs instanceof String || lhs instanceof Character) && (rhs instanceof String || rhs instanceof Character)) {
            return lhs.toString().equals(rhs.toString());
        }
        if (lhs.getClass().isArray() && rhs.getClass().isArray()) {
            return ArrayUtil.equals(lhs, rhs, PROPERTY_EQUALITY);
        }
        return false;
    }

    private static boolean compareNumbers(Number aNumber, Number bNumber) {
        if (aNumber instanceof Float || bNumber instanceof Float || aNumber instanceof Double || bNumber instanceof Double) {
            double b = bNumber.doubleValue();
            double a = aNumber.doubleValue();
            return a == b;
        }
        return aNumber.longValue() == bNumber.longValue();
    }
}

