/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;

public class QuickReadPerformanceTest {
    private static final Timer timer = new Timer("Background writer", true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        File storeDir = new File("/tmp/mydb");
        if (storeDir.exists()) {
            FileUtils.deleteRecursively(storeDir);
        }
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir.getAbsolutePath());
        try {
            BulkReaderWorker reader = new BulkReaderWorker(db);
            QuickReadPerformanceTest.startBackgroundInsert(db);
            long totalReads = 0L;
            long totalTime = 0L;
            long iterations = 30000L;
            while (iterations-- > 0L) {
                int[] result = (int[])reader.call();
                totalReads += (long)result[0];
                totalTime += (long)result[2];
            }
            System.out.println("Did " + totalReads + " in " + totalTime + "ms.");
            System.out.println(totalReads / totalTime + "reads/ms");
        }
        finally {
            timer.cancel();
            db.shutdown();
        }
    }

    private static void startBackgroundInsert(final GraphDatabaseService db) {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try (Transaction tx = db.beginTx();){
                    Node node1 = db.createNode();
                    Node node2 = db.createNode();
                    node1.setProperty("name", "Bob");
                    node2.setProperty("name", "Ashton");
                    Relationship rel = node1.createRelationshipTo(node2, DynamicRelationshipType.withName("LIKES"));
                    rel.setProperty("since", 12);
                    tx.success();
                }
            }
        }, 10L, 200L);
    }

    static class BulkReaderWorker
    implements Callable<int[]> {
        private final GraphDatabaseService graphDb;

        public BulkReaderWorker(GraphDatabaseService graphDb) {
            this.graphDb = graphDb;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int[] call() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

