/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.PrimitiveLongPredicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    public NeoStoreIndexStoreView(NeoStore neoStore) {
        this.propertyStore = neoStore.getPropertyStore();
        this.nodeStore = neoStore.getNodeStore();
    }

    @Override
    public Iterator<Pair<Integer, Object>> nodeProperties(long nodeId, Iterator<Long> propertyKeysIterator) {
        long firstPropertyId = this.nodeStore.forceGetRecord(nodeId).getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return IteratorUtil.emptyIterator();
        }
        final Set<Long> propertyKeys = IteratorUtil.asSet(IteratorUtil.asIterable(propertyKeysIterator));
        return Iterables.flatMap(new Function<PropertyRecord, Iterator<Pair<Integer, Object>>>(){

            @Override
            public Iterator<Pair<Integer, Object>> apply(PropertyRecord propertyRecord) {
                return Iterables.filter(NeoStoreIndexStoreView.this.notNull(), Iterables.map(NeoStoreIndexStoreView.this.propertiesThatAreIn(propertyKeys), propertyRecord.getPropertyBlocks().iterator()));
            }
        }, this.propertyStore.getPropertyRecordChain(firstPropertyId).iterator());
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodesWithPropertyAndLabel(IndexDescriptor descriptor, Visitor<NodePropertyUpdate, FAILURE> visitor) {
        return this.visitNodes(NeoStoreIndexStoreView.singleLongPredicate(descriptor.getPropertyKeyId()), NeoStoreIndexStoreView.singleLongPredicate(descriptor.getLabelId()), visitor);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(long[] labelIds, long[] propertyKeyIds, Visitor<NodePropertyUpdate, FAILURE> visitor) {
        return this.visitNodes(NeoStoreIndexStoreView.multipleLongPredicate(propertyKeyIds), NeoStoreIndexStoreView.multipleLongPredicate(labelIds), visitor);
    }

    private <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(PrimitiveLongPredicate propertyKeyPredicate, PrimitiveLongPredicate labelPredicate, Visitor<NodePropertyUpdate, FAILURE> visitor) {
        LabelsReference labelsReference = new LabelsReference();
        NodeIndexingProcessor<FAILURE> processor = new NodeIndexingProcessor<FAILURE>(this.propertyStore, propertyKeyPredicate, labelsReference, visitor);
        NodeLabelFilterPredicate predicate = new NodeLabelFilterPredicate(this.nodeStore, labelPredicate, labelsReference);
        return new ProcessStoreScan<FAILURE>(processor, predicate);
    }

    private static PrimitiveLongPredicate singleLongPredicate(final long acceptedValue) {
        return new PrimitiveLongPredicate(){

            @Override
            public boolean accept(long value) {
                return value == acceptedValue;
            }
        };
    }

    private static PrimitiveLongPredicate multipleLongPredicate(final long ... acceptedValues) {
        return new PrimitiveLongPredicate(){

            @Override
            public boolean accept(long value) {
                for (int i = 0; i < acceptedValues.length; ++i) {
                    if (value != acceptedValues[i]) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Predicate<Pair<Integer, Object>> notNull() {
        return new Predicate<Pair<Integer, Object>>(){

            @Override
            public boolean accept(Pair<Integer, Object> item) {
                return item != null;
            }
        };
    }

    private Function<PropertyBlock, Pair<Integer, Object>> propertiesThatAreIn(final Set<Long> propertyKeys) {
        return new Function<PropertyBlock, Pair<Integer, Object>>(){

            @Override
            public Pair<Integer, Object> apply(PropertyBlock property) {
                int keyId = property.getKeyIndexId();
                if (propertyKeys.contains(keyId)) {
                    NeoStoreIndexStoreView.this.propertyStore.ensureHeavy(property);
                    Object propertyValue = property.getType().getValue(property, NeoStoreIndexStoreView.this.propertyStore);
                    return Pair.of(property.getKeyIndexId(), propertyValue);
                }
                return null;
            }
        };
    }

    private class ProcessStoreScan<FAILURE extends Exception>
    implements StoreScan<FAILURE> {
        private final RecordStore.Processor<FAILURE> processor;
        private final Predicate<NodeRecord> predicate;

        public ProcessStoreScan(RecordStore.Processor<FAILURE> processor, Predicate<NodeRecord> predicate) {
            this.processor = processor;
            this.predicate = predicate;
        }

        @Override
        public void run() throws FAILURE {
            this.processor.applyFiltered(NeoStoreIndexStoreView.this.nodeStore, this.predicate);
        }

        @Override
        public void stop() {
            this.processor.stopScanning();
        }
    }

    private class NodeLabelFilterPredicate
    implements Predicate<NodeRecord> {
        private final NodeStore nodeStore;
        private final PrimitiveLongPredicate labelPredicate;
        private final LabelsReference labelsReference;

        public NodeLabelFilterPredicate(NodeStore nodeStore, PrimitiveLongPredicate labelPredicate, LabelsReference labelsReference) {
            this.nodeStore = nodeStore;
            this.labelPredicate = labelPredicate;
            this.labelsReference = labelsReference;
        }

        @Override
        public boolean accept(NodeRecord node) {
            if (node.inUse()) {
                long[] labelsForNode = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
                this.labelsReference.set(labelsForNode);
                for (long nodeLabelId : labelsForNode) {
                    if (!this.labelPredicate.accept(nodeLabelId)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class NodeIndexingProcessor<FAILURE extends Exception>
    extends RecordStore.Processor<FAILURE> {
        private final PropertyStore propertyStore;
        private final Visitor<NodePropertyUpdate, FAILURE> visitor;
        private final PrimitiveLongPredicate propertyKeyPredicate;
        private final LabelsReference labelsReference;

        public NodeIndexingProcessor(PropertyStore propertyStore, PrimitiveLongPredicate propertyKeyPredicate, LabelsReference labelsReference, Visitor<NodePropertyUpdate, FAILURE> visitor) {
            this.propertyStore = propertyStore;
            this.propertyKeyPredicate = propertyKeyPredicate;
            this.labelsReference = labelsReference;
            this.visitor = visitor;
        }

        @Override
        public void processNode(RecordStore<NodeRecord> nodeStore, NodeRecord node) throws FAILURE {
            long firstPropertyId = node.getCommittedNextProp();
            if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
                return;
            }
            for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
                for (PropertyBlock property : propertyRecord.getPropertyBlocks()) {
                    long propertyKeyId = property.getKeyIndexId();
                    if (!this.propertyKeyPredicate.accept(propertyKeyId)) continue;
                    this.propertyStore.ensureHeavy(property);
                    Object propertyValue = property.getType().getValue(property, this.propertyStore);
                    this.visitor.visit(NodePropertyUpdate.add(node.getId(), propertyKeyId, propertyValue, this.labelsReference.get()));
                }
            }
        }
    }

    private static class LabelsReference {
        private long[] labels;

        private LabelsReference() {
        }

        long[] get() {
            return this.labels;
        }

        void set(long[] labels) {
            this.labels = labels;
        }
    }
}

