/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.DataStatement;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class GraphPropertiesImpl
extends Primitive
implements GraphProperties {
    private final NodeManager nodeManager;
    private Map<Integer, SafeProperty> properties;
    private final ThreadToStatementContextBridge statementCtxProvider;

    GraphPropertiesImpl(NodeManager nodeManager, ThreadToStatementContextBridge statementCtxProvider) {
        super(false);
        this.nodeManager = nodeManager;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeManager.getGraphDbService();
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return 0;
    }

    @Override
    protected boolean hasLoadedProperties() {
        return this.properties != null;
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager) {
        return nodeManager.loadGraphProperties(false);
    }

    @Override
    protected Object loadPropertyValue(NodeManager nodeManager, int propertyKey) {
        return nodeManager.graphLoadPropertyValue(propertyKey);
    }

    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyId = statement.propertyKeyGetForName(key);
            boolean bl = statement.graphGetProperty(propertyId).isDefined();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyId = statement.propertyKeyGetForName(key);
            if (propertyId == -1L) {
                Boolean bl = false;
                return bl;
            }
            Object object = statement.graphGetProperty(propertyId).value();
            return object;
        }
        catch (PropertyNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyId = statement.propertyKeyGetForName(key);
            if (propertyId == -1L) {
                Boolean bl = false;
                return bl;
            }
            Object object = statement.graphGetProperty(propertyId).value(defaultValue);
            return object;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        boolean success = false;
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long propertyKeyId = statement.propertyKeyGetOrCreateForName(key);
            statement.graphSetProperty(Property.property(propertyKeyId, value));
            success = true;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long propertyId = statement.propertyKeyGetOrCreateForName(key);
            Object object = statement.graphRemoveProperty(propertyId).value(null);
            return object;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<SafeProperty> properties = statement.graphGetAllProperties();
            while (properties.hasNext()) {
                keys.add(statement.propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<SafeProperty, Object>(){

                @Override
                public Object apply(SafeProperty prop) {
                    return prop.value();
                }
            }, statement.graphGetAllProperties()));
            return set;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GraphProperties && ((GraphProperties)obj).getNodeManager().equals(this.nodeManager);
    }

    @Override
    public int hashCode() {
        return this.nodeManager.hashCode();
    }

    @Override
    public long getId() {
        return -1L;
    }

    @Override
    protected void setEmptyProperties() {
        this.properties = new HashMap<Integer, SafeProperty>();
    }

    @Override
    protected Iterator<SafeProperty> getCachedProperties() {
        return this.properties.values().iterator();
    }

    @Override
    protected PrimitiveLongIterator getCachedPropertyKeys() {
        return new PropertyKeyIdIterator(this.getCachedProperties());
    }

    @Override
    protected Property getCachedProperty(int key) {
        Property property = this.properties.get(key);
        return property != null ? property : Property.noGraphProperty(key);
    }

    @Override
    protected PropertyData getPropertyForIndex(int keyId) {
        Property property = this.properties.get(keyId);
        return property != null ? property.asPropertyDataJustForIntegration() : null;
    }

    @Override
    protected void setProperties(Iterator<SafeProperty> loadedProperties) {
        if (loadedProperties != null && loadedProperties.hasNext()) {
            HashMap<Integer, SafeProperty> newProperties = new HashMap<Integer, SafeProperty>();
            while (loadedProperties.hasNext()) {
                SafeProperty property = loadedProperties.next();
                newProperties.put((int)property.propertyKeyId(), property);
            }
            this.properties = newProperties;
        } else {
            this.properties = new HashMap<Integer, SafeProperty>();
        }
    }

    @Override
    public WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement element, boolean create) {
        return element.graphElement(create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return this;
    }

    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap, long firstProp) {
        if (cowPropertyAddMap != null) {
            for (Map.Entry<Integer, PropertyData> entry : cowPropertyAddMap.entrySet()) {
                this.properties.put(entry.getKey(), Property.property(entry.getKey().intValue(), entry.getValue().getValue()));
            }
        }
        if (cowPropertyRemoveMap != null) {
            for (Map.Entry<Integer, PropertyData> entry : cowPropertyRemoveMap.entrySet()) {
                this.properties.remove(entry.getKey());
            }
        }
    }
}

