/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;

public class LockStripedCache<E extends EntityWithSizeObject>
implements Cache<E> {
    private final ReentrantLock[] locks;
    private final Cache<E> actual;
    private final Loader<E> loader;

    public LockStripedCache(Cache<E> actual, int stripeCount, Loader<E> loader) {
        this.loader = loader;
        this.locks = new ReentrantLock[stripeCount];
        this.actual = actual;
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public String getName() {
        return this.actual.getName();
    }

    @Override
    public void put(E value) {
        this.actual.put(value);
    }

    @Override
    public E remove(long key) {
        return this.actual.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(long key) {
        Object result = this.actual.get(key);
        if (result != null) {
            return result;
        }
        ReentrantLock lock = this.lockId(key);
        try {
            result = (EntityWithSizeObject)this.loader.loadById(key);
            if (result == null) {
                E e = null;
                return e;
            }
            this.actual.put(result);
            Object object = result;
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    public E getIfCached(long key) {
        return this.actual.get(key);
    }

    private ReentrantLock lockId(long id) {
        int stripe = (int)(id / 32768L) % this.locks.length;
        if (stripe < 0) {
            stripe *= -1;
        }
        ReentrantLock lock = this.locks[stripe];
        lock.lock();
        return lock;
    }

    @Override
    public void clear() {
        this.actual.clear();
    }

    @Override
    public long size() {
        return this.actual.size();
    }

    @Override
    public void putAll(Collection values) {
        this.actual.putAll(values);
    }

    @Override
    public long hitCount() {
        return this.actual.hitCount();
    }

    @Override
    public long missCount() {
        return this.actual.missCount();
    }

    @Override
    public void updateSize(E entity, int newSize) {
        this.actual.updateSize(entity, newSize);
    }

    @Override
    public void printStatistics() {
        this.actual.printStatistics();
    }

    public static interface Loader<E> {
        public E loadById(long var1);
    }
}

