/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.Collections;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.Transactor;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.constraints.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class ConstraintIndexCreator {
    private final Transactor transactor;
    private final IndexingService indexingService;

    public ConstraintIndexCreator(Transactor transactor, IndexingService indexingService) {
        this.transactor = transactor;
        this.indexingService = indexingService;
    }

    public long createUniquenessConstraintIndex(Statement state, SchemaReadOperations schema, long labelId, long propertyKeyId) throws ConstraintVerificationFailedKernelException, TransactionalException, CreateConstraintFailureException, DropIndexFailureException {
        long indexId;
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        IndexDescriptor descriptor = this.transactor.execute(ConstraintIndexCreator.createConstraintIndex(labelId, propertyKeyId));
        try {
            indexId = schema.indexGetCommittedId(state, descriptor);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor));
        }
        boolean success = false;
        try {
            this.awaitIndexPopulation(constraint, indexId);
            success = true;
        }
        catch (InterruptedException exception) {
            throw new ConstraintVerificationFailedKernelException(constraint, (Throwable)exception);
        }
        finally {
            if (!success) {
                this.dropUniquenessConstraintIndex(descriptor);
            }
        }
        return indexId;
    }

    public void validateConstraintIndex(UniquenessConstraint constraint, long indexId) throws CreateConstraintFailureException {
        try {
            this.indexingService.validateIndex(indexId);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException(String.format("Index (indexId=%d) that we just created does not exist.", indexId));
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable failure = e.getCause();
            if (failure instanceof ConstraintVerificationFailedKernelException) {
                throw new CreateConstraintFailureException(constraint, failure);
            }
            if (failure instanceof IndexEntryConflictException) {
                IndexEntryConflictException conflict = (IndexEntryConflictException)failure;
                throw new CreateConstraintFailureException(constraint, (Throwable)new ConstraintVerificationFailedKernelException(constraint, Collections.singleton(new ConstraintVerificationFailedKernelException.Evidence(conflict))));
            }
            throw new CreateConstraintFailureException(constraint, failure);
        }
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor descriptor) throws TransactionalException, DropIndexFailureException {
        this.transactor.execute(ConstraintIndexCreator.dropConstraintIndex(descriptor));
    }

    private void awaitIndexPopulation(UniquenessConstraint constraint, long indexId) throws InterruptedException, ConstraintVerificationFailedKernelException {
        try {
            this.indexingService.getProxyForRule(indexId).awaitStoreScanCompleted();
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException(String.format("Index (indexId=%d) that we just created does not exist.", indexId));
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new ConstraintVerificationFailedKernelException(constraint, Collections.singleton(new ConstraintVerificationFailedKernelException.Evidence((IndexEntryConflictException)cause)));
            }
            throw new ConstraintVerificationFailedKernelException(constraint, cause);
        }
    }

    public static Transactor.Work<IndexDescriptor, CreateConstraintFailureException> createConstraintIndex(final long labelId, final long propertyKeyId) {
        return new Transactor.Work<IndexDescriptor, CreateConstraintFailureException>(){

            @Override
            public IndexDescriptor perform(StatementOperationParts statement, Statement kernelStatement) {
                IndexDescriptor rule = new IndexDescriptor(labelId, propertyKeyId);
                kernelStatement.txState().constraintIndexRuleDoAdd(rule);
                return rule;
            }
        };
    }

    private static Transactor.Work<Void, DropIndexFailureException> dropConstraintIndex(final IndexDescriptor descriptor) {
        return new Transactor.Work<Void, DropIndexFailureException>(){

            @Override
            public Void perform(StatementOperationParts statement, Statement kernelStatement) {
                kernelStatement.txState().constraintIndexDoDrop(descriptor);
                return null;
            }
        };
    }
}

