/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.KeyReadOperations;
import org.neo4j.kernel.api.operations.KeyWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class StoreStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityReadOperations,
EntityWriteOperations,
SchemaReadOperations,
AuxiliaryStoreOperations {
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        @Override
        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final SchemaStorage schemaStorage;
    private final PersistenceManager persistenceManager;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public StoreStatementOperations(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, SchemaStorage schemaStorage, NeoStore neoStore, PersistenceManager persistenceManager, IndexingService indexService) {
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.schemaStorage = schemaStorage;
        assert (neoStore != null) : "No neoStore provided";
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
        this.relationshipStore = neoStore.getRelationshipStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.persistenceManager = persistenceManager;
    }

    private UnsupportedOperationException shouldNotManipulateStoreDirectly() {
        throw new UnsupportedOperationException("The storage layer can not be written to directly, you have to go through a transaction.");
    }

    private UnsupportedOperationException shouldNotHaveReachedAllTheWayHere() {
        throw new UnsupportedOperationException("This call should not reach all the way here");
    }

    private UnsupportedOperationException shouldCallAuxiliaryInstead() {
        return new UnsupportedOperationException("This shouldn't be called directly, but instead to an appropriate method in the " + AuxiliaryStoreOperations.class.getSimpleName() + " interface");
    }

    @Override
    public long labelGetOrCreateForName(Statement state, String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public long labelGetForName(Statement state, String label) {
        int id = this.labelTokenHolder.getIdByName(label);
        if (id == -1) {
            return -1L;
        }
        return id;
    }

    @Override
    public boolean nodeHasLabel(Statement state, long nodeId, long labelId) {
        try {
            return IteratorUtil.contains(this.nodeGetLabels(state, nodeId), labelId);
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public PrimitiveLongIterator nodeGetLabels(Statement state, long nodeId) {
        try {
            return IteratorUtil.asPrimitiveIterator(NodeLabelsField.parseLabelsField(this.nodeStore.getRecord(nodeId)).get(this.nodeStore));
        }
        catch (InvalidRecordException e) {
            return IteratorUtil.emptyPrimitiveLongIterator();
        }
    }

    @Override
    public String labelGetName(Statement state, long labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById((int)labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(Statement state, long labelId) {
        return state.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public long relationshipTypeGetForName(Statement state, String relationshipType) {
        return this.relationshipTypeTokenHolder.getIdByName(relationshipType);
    }

    @Override
    public String relationshipTypeGetName(Statement state, long relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((Token)this.relationshipTypeTokenHolder.getTokenById((int)relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(Statement state, long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        return StoreStatementOperations.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(Statement state, long labelId) {
        return this.getIndexDescriptorsFor(StoreStatementOperations.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(Statement state) {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(Statement state, long labelId) {
        return this.getIndexDescriptorsFor(StoreStatementOperations.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(Statement state) {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final long labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final long labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            @Override
            public IndexDescriptor apply(SchemaRule from) {
                return StoreStatementOperations.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(Statement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public long indexGetCommittedId(Statement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getState();
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getPopulationFailure().asString();
    }

    private long indexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try {
            return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IndexNotFoundKernelException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(Statement state, long labelId, final long propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(Statement state, long labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.TRUE());
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(Statement state) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.TRUE());
    }

    @Override
    public long propertyKeyGetOrCreateForName(Statement state, String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public long relationshipTypeGetOrCreateForName(Statement state, String relationshipType) {
        return this.relationshipTypeTokenHolder.getOrCreateId(relationshipType);
    }

    @Override
    public long propertyKeyGetForName(Statement state, String propertyKey) {
        int id = this.propertyKeyTokenHolder.getIdByName(propertyKey);
        if (id == -1) {
            return -1L;
        }
        return id;
    }

    @Override
    public String propertyKeyGetName(Statement state, long propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById((int)propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    @Override
    public Iterator<SafeProperty> nodeGetAllProperties(Statement state, long nodeId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.nodeStore.getRecord(nodeId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId, e);
        }
    }

    @Override
    public Iterator<SafeProperty> relationshipGetAllProperties(Statement state, long relationshipId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.relationshipStore.getRecord(relationshipId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId, e);
        }
    }

    @Override
    public Iterator<SafeProperty> graphGetAllProperties(Statement state) {
        return this.loadAllPropertiesOf(this.neoStore.asRecord());
    }

    private Iterator<SafeProperty> loadAllPropertiesOf(PrimitiveRecord primitiveRecord) {
        Collection<PropertyRecord> records = this.propertyStore.getPropertyRecordChain(primitiveRecord.getNextProp());
        if (null == records) {
            return IteratorUtil.emptyIterator();
        }
        ArrayList<SafeProperty> properties = new ArrayList<SafeProperty>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                properties.add(block.getType().readProperty(block.getKeyIndexId(), block, this.propertyStore));
            }
        }
        return properties.iterator();
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(Statement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return state.getIndexReader(this.indexId(index)).lookup(value);
    }

    @Override
    public void nodeAddStoreProperty(long nodeId, SafeProperty property) {
        this.persistenceManager.nodeAddProperty(nodeId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void relationshipAddStoreProperty(long relationshipId, SafeProperty property) {
        this.persistenceManager.relAddProperty(relationshipId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void graphAddStoreProperty(SafeProperty property) {
        this.persistenceManager.graphAddProperty((int)property.propertyKeyId(), property.value());
    }

    @Override
    public void nodeChangeStoreProperty(long nodeId, SafeProperty previousProperty, SafeProperty property) {
        this.persistenceManager.nodeChangeProperty(nodeId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void relationshipChangeStoreProperty(long relationshipId, SafeProperty previousProperty, SafeProperty property) {
        this.persistenceManager.relChangeProperty(relationshipId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void graphChangeStoreProperty(SafeProperty previousProperty, SafeProperty property) {
        this.persistenceManager.graphChangeProperty((int)property.propertyKeyId(), property.value());
    }

    @Override
    public void nodeRemoveStoreProperty(long nodeId, SafeProperty property) {
        this.persistenceManager.nodeRemoveProperty(nodeId, (int)property.propertyKeyId());
    }

    @Override
    public void relationshipRemoveStoreProperty(long relationshipId, SafeProperty property) {
        this.persistenceManager.relRemoveProperty(relationshipId, (int)property.propertyKeyId());
    }

    @Override
    public void graphRemoveStoreProperty(SafeProperty property) {
        this.persistenceManager.graphRemoveProperty((int)property.propertyKeyId());
    }

    @Override
    public Property nodeSetProperty(Statement state, long nodeId, SafeProperty property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property relationshipSetProperty(Statement state, long relationshipId, SafeProperty property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property graphSetProperty(Statement state, SafeProperty property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property nodeRemoveProperty(Statement state, long nodeId, long propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property relationshipRemoveProperty(Statement state, long relationshipId, long propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property graphRemoveProperty(Statement state, long propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void nodeDelete(Statement state, long nodeId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void relationshipDelete(Statement state, long relationshipId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void nodeDelete(long nodeId) {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public void relationshipDelete(long relationshipId) {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public boolean nodeAddLabel(Statement state, long nodeId, long labelId) throws EntityNotFoundException {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public boolean nodeRemoveLabel(Statement state, long nodeId, long labelId) throws EntityNotFoundException {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public Property nodeGetProperty(Statement state, long nodeId, long propertyKeyId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public Property relationshipGetProperty(Statement state, long relationshipId, long propertyKeyId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public Property graphGetProperty(Statement state, long propertyKeyId) {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(Statement state, long nodeId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(Statement state, long relationshipId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(Statement state) {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }
}

