/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.NumberPropertyWithin4Bytes;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class SmallLongProperty
extends NumberPropertyWithin4Bytes {
    private final int value;
    private final long propertyKeyId;

    SmallLongProperty(long propertyKeyId, int value) {
        this.value = value;
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Integer) {
            return this.value == (Integer)other;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    boolean hasEqualValue(NumberPropertyWithin4Bytes that) {
        return this.value == ((SmallLongProperty)that).value;
    }

    @Override
    public Long value() {
        return this.longValue();
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forLong((int)this.propertyKeyId, -1L, this.value);
    }
}

