/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.FullSizeProperty;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class DoubleProperty
extends FullSizeProperty {
    private final double value;

    DoubleProperty(long propertyKeyId, double value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Double) {
            return this.value == (Double)other;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Override
    int valueHash() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Double.compare(this.value, ((DoubleProperty)that).value) == 0;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forDouble((int)this.propertyKeyId, -1L, this.value);
    }
}

