/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

class BooleanArrayProperty
extends FullSizeProperty {
    private final boolean[] value;

    BooleanArrayProperty(long propertyKeyId, boolean[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public boolean[] value() {
        return (boolean[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof boolean[]) {
            return Arrays.equals(this.value, (boolean[])value);
        }
        if (value instanceof Boolean[]) {
            Boolean[] otherValue = (Boolean[])value;
            if (this.value.length != otherValue.length) {
                return false;
            }
            for (int i = 0; i < otherValue.length; ++i) {
                if (otherValue[i] != null && this.value[i] == otherValue[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((BooleanArrayProperty)that).value);
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forStringOrArray((int)this.propertyKeyId, -1L, this.value);
    }
}

