/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.operations;

import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.operations.TokenNameLookup;

public final class StatementTokenNameLookup
implements TokenNameLookup {
    private final ReadStatement statement;

    public StatementTokenNameLookup(ReadStatement statement) {
        this.statement = statement;
    }

    @Override
    public String labelGetName(long labelId) {
        try {
            return this.statement.labelGetName(labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    @Override
    public String propertyKeyGetName(long propertyKeyId) {
        try {
            return this.statement.propertyKeyGetName(propertyKeyId);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            return "[" + propertyKeyId + "]";
        }
    }
}

