/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.DataRead;
import org.neo4j.kernel.api.KernelTransactionImplementation;
import org.neo4j.kernel.api.SchemaRead;
import org.neo4j.kernel.api.SchemaState;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenRead;
import org.neo4j.kernel.api.TokenWrite;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.KeyReadOperations;
import org.neo4j.kernel.api.operations.KeyWriteOperations;
import org.neo4j.kernel.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.SchemaStateOperations;
import org.neo4j.kernel.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.Token;

public class ReadStatement
implements TokenRead,
TokenWrite,
DataRead,
SchemaRead,
SchemaState,
AutoCloseable {
    private final KernelTransactionImplementation transaction;
    private boolean closed;
    final Statement state;

    ReadStatement(KernelTransactionImplementation transaction, Statement state) {
        this.transaction = transaction;
        this.state = state;
    }

    void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("The statement has been closed.");
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.transaction.releaseStatement(this.state);
        }
    }

    final KeyReadOperations tokenRead() {
        return this.transaction.operations.keyReadOperations();
    }

    final KeyWriteOperations tokenWrite() {
        return this.transaction.operations.keyWriteOperations();
    }

    final EntityReadOperations dataRead() {
        return this.transaction.operations.entityReadOperations();
    }

    final EntityWriteOperations dataWrite() {
        return this.transaction.operations.entityWriteOperations();
    }

    final SchemaReadOperations schemaRead() {
        return this.transaction.operations.schemaReadOperations();
    }

    final SchemaWriteOperations schemaWrite() {
        return this.transaction.operations.schemaWriteOperations();
    }

    final SchemaStateOperations schemaState() {
        return this.transaction.operations.schemaStateOperations();
    }

    final LegacyKernelOperations legacyOps() {
        return this.transaction.legacyKernelOperations;
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(long labelId) {
        this.assertOpen();
        if (labelId == -1L) {
            return IteratorUtil.emptyPrimitiveLongIterator();
        }
        return this.dataRead().nodesGetForLabel(this.state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.assertOpen();
        return this.dataRead().nodesGetFromIndexLookup(this.state, index, value);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.assertOpen();
        return labelId != -1L && this.dataRead().nodeHasLabel(this.state, nodeId, labelId);
    }

    @Override
    public PrimitiveLongIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataRead().nodeGetLabels(this.state, nodeId);
    }

    @Override
    public Property nodeGetProperty(long nodeId, long propertyKeyId) throws EntityNotFoundException {
        this.assertOpen();
        if (propertyKeyId == -1L) {
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.dataRead().nodeGetProperty(this.state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, long propertyKeyId) throws EntityNotFoundException {
        this.assertOpen();
        if (propertyKeyId == -1L) {
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.dataRead().relationshipGetProperty(this.state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphGetProperty(long propertyKeyId) {
        this.assertOpen();
        if (propertyKeyId == -1L) {
            return Property.noGraphProperty(propertyKeyId);
        }
        return this.dataRead().graphGetProperty(this.state, propertyKeyId);
    }

    @Override
    public Iterator<SafeProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataRead().nodeGetAllProperties(this.state, nodeId);
    }

    @Override
    public Iterator<SafeProperty> relationshipGetAllProperties(long relationshipId) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataRead().relationshipGetAllProperties(this.state, relationshipId);
    }

    @Override
    public Iterator<SafeProperty> graphGetAllProperties() {
        this.assertOpen();
        return this.dataRead().graphGetAllProperties(this.state);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        this.assertOpen();
        return this.schemaRead().indexesGetForLabelAndPropertyKey(this.state, labelId, propertyKey);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(long labelId) {
        this.assertOpen();
        return this.schemaRead().indexesGetForLabel(this.state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.assertOpen();
        return this.schemaRead().indexesGetAll(this.state);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(long labelId) {
        this.assertOpen();
        return this.schemaRead().uniqueIndexesGetForLabel(this.state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        this.assertOpen();
        return this.schemaRead().uniqueIndexesGetAll(this.state);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.assertOpen();
        return this.schemaRead().indexGetState(this.state, descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.assertOpen();
        return this.schemaRead().indexGetFailure(this.state, descriptor);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(long labelId, long propertyKeyId) {
        this.assertOpen();
        return this.schemaRead().constraintsGetForLabelAndPropertyKey(this.state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(long labelId) {
        this.assertOpen();
        return this.schemaRead().constraintsGetForLabel(this.state, labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        this.assertOpen();
        return this.schemaRead().constraintsGetAll(this.state);
    }

    @Override
    public long labelGetForName(String labelName) {
        this.assertOpen();
        return this.tokenRead().labelGetForName(this.state, labelName);
    }

    @Override
    public String labelGetName(long labelId) throws LabelNotFoundKernelException {
        this.assertOpen();
        return this.tokenRead().labelGetName(this.state, labelId);
    }

    @Override
    public long propertyKeyGetForName(String propertyKeyName) {
        this.assertOpen();
        return this.tokenRead().propertyKeyGetForName(this.state, propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(long propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.assertOpen();
        return this.tokenRead().propertyKeyGetName(this.state, propertyKeyId);
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        this.assertOpen();
        return this.tokenRead().labelsGetAllTokens(this.state);
    }

    @Override
    public long relationshipTypeGetForName(String relationshipTypeName) {
        this.assertOpen();
        return this.tokenRead().relationshipTypeGetForName(this.state, relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(long relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.assertOpen();
        return this.tokenRead().relationshipTypeGetName(this.state, relationshipTypeId);
    }

    @Override
    public long labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.assertOpen();
        return this.tokenWrite().labelGetOrCreateForName(this.state, labelName);
    }

    @Override
    public long propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.assertOpen();
        return this.tokenWrite().propertyKeyGetOrCreateForName(this.state, propertyKeyName);
    }

    @Override
    public long relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.assertOpen();
        return this.tokenWrite().relationshipTypeGetOrCreateForName(this.state, relationshipTypeName);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState().schemaStateGetOrCreate(this.state, key, creator);
    }
}

