/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.BaseConstraintCreator;
import org.neo4j.kernel.InternalSchemaActions;
import org.neo4j.kernel.PropertyUniqueConstraintCreator;

public class PropertyConstraintCreator
extends BaseConstraintCreator {
    protected final String propertyKey;

    PropertyConstraintCreator(InternalSchemaActions internalCreator, Label label, String propertyKeyOrNull) {
        super(internalCreator, label);
        this.propertyKey = propertyKeyOrNull;
    }

    @Override
    public final ConstraintCreator on(String propertyKey) {
        if (this.propertyKey == null) {
            return this.doOn(propertyKey);
        }
        throw new UnsupportedOperationException("Constraints on compound keys are not yet supported, only one property per constraint is allowed.");
    }

    @Override
    public ConstraintCreator unique() {
        return new PropertyUniqueConstraintCreator(this.actions, this.label, this.propertyKey);
    }

    @Override
    public final ConstraintDefinition create() {
        if (this.propertyKey == null) {
            super.create();
        }
        return this.doCreate();
    }

    protected ConstraintCreator doOn(String propertyKey) {
        return new PropertyConstraintCreator(this.actions, this.label, propertyKey);
    }

    protected ConstraintDefinition doCreate() {
        throw new IllegalStateException("Property key " + this.propertyKey + " specified, but not what it's for");
    }
}

