/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.kernel.info.LockingTransaction;
import org.neo4j.kernel.info.ResourceType;
import org.neo4j.kernel.info.WaitingThread;

class RWLock
implements Visitor<StringLogger.LineLogger, RuntimeException> {
    private int writeCount = 0;
    private int readCount = 0;
    private int marked = 0;
    private final Object resource;
    private final LinkedList<WaitElement> waitingThreadList = new LinkedList();
    private final ArrayMap<Transaction, TxLockElement> txLockElementMap = new ArrayMap(5, false, true);
    private final RagManager ragManager;

    RWLock(Object resource, RagManager ragManager) {
        this.resource = resource;
        this.ragManager = ragManager;
    }

    synchronized void mark() {
        ++this.marked;
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireReadLock(Transaction tx) throws DeadlockDetectedException {
        this.assertTransaction(tx);
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            tle = new TxLockElement(tx);
        }
        try {
            tle.movedOn = false;
            while (this.writeCount > tle.writeCount) {
                this.ragManager.checkWaitOn(this, tx);
                this.waitingThreadList.addFirst(new WaitElement(tle, LockType.READ, Thread.currentThread()));
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                this.ragManager.stopWaitOn(this, tx);
            }
            if (tle.readCount == 0 && tle.writeCount == 0) {
                this.ragManager.lockAcquired(this, tx);
            }
            ++this.readCount;
            ++tle.readCount;
            tle.movedOn = true;
            this.txLockElementMap.put(tx, tle);
        }
        finally {
            --this.marked;
        }
    }

    synchronized void releaseReadLock(Transaction tx) throws LockNotFoundException {
        this.assertTransaction(tx);
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        if (tle.readCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have readLock");
        }
        --this.readCount;
        --tle.readCount;
        if (tle.readCount == 0 && tle.writeCount == 0) {
            if (!this.isMarked()) {
                this.txLockElementMap.remove(tx);
            }
            this.ragManager.lockReleased(this, tx);
        }
        if (this.waitingThreadList.size() > 0) {
            WaitElement we = this.waitingThreadList.getLast();
            if (we.lockType == LockType.WRITE) {
                if (this.readCount == we.element.readCount) {
                    this.waitingThreadList.removeLast();
                    if (!we.element.movedOn) {
                        we.waitingThread.interrupt();
                    }
                } else {
                    ListIterator<WaitElement> listItr = this.waitingThreadList.listIterator(this.waitingThreadList.lastIndexOf(we));
                    while (listItr.hasPrevious()) {
                        we = listItr.previous();
                        if (we.lockType == LockType.WRITE && this.readCount == we.element.readCount) {
                            listItr.remove();
                            if (we.element.movedOn) continue;
                            we.waitingThread.interrupt();
                            break;
                        }
                        if (we.lockType != LockType.READ) continue;
                        listItr.remove();
                        if (we.element.movedOn) continue;
                        we.waitingThread.interrupt();
                    }
                }
            } else if (this.writeCount == 0) {
                this.waitingThreadList.removeLast();
                if (!we.element.movedOn) {
                    we.waitingThread.interrupt();
                }
            }
        }
    }

    private void assertTransaction(Transaction tx) {
        if (tx == null) {
            throw new IllegalArgumentException();
        }
    }

    void acquireWriteLock() throws DeadlockDetectedException {
        this.acquireWriteLock(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireWriteLock(Transaction tx) throws DeadlockDetectedException {
        this.assertTransaction(tx);
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            tle = new TxLockElement(tx);
        }
        try {
            tle.movedOn = false;
            while (this.writeCount > tle.writeCount || this.readCount > tle.readCount) {
                this.ragManager.checkWaitOn(this, tx);
                this.waitingThreadList.addFirst(new WaitElement(tle, LockType.WRITE, Thread.currentThread()));
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                this.ragManager.stopWaitOn(this, tx);
            }
            if (tle.readCount == 0 && tle.writeCount == 0) {
                this.ragManager.lockAcquired(this, tx);
            }
            ++this.writeCount;
            ++tle.writeCount;
            tle.movedOn = true;
            this.txLockElementMap.put(tx, tle);
        }
        finally {
            --this.marked;
        }
    }

    synchronized void releaseWriteLock(Transaction tx) throws LockNotFoundException {
        this.assertTransaction(tx);
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        if (tle.writeCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have writeLock");
        }
        --this.writeCount;
        --tle.writeCount;
        if (tle.readCount == 0 && tle.writeCount == 0) {
            if (!this.isMarked()) {
                this.txLockElementMap.remove(tx);
            }
            this.ragManager.lockReleased(this, tx);
        }
        if (this.writeCount == 0 && this.waitingThreadList.size() > 0) {
            do {
                WaitElement we = this.waitingThreadList.removeLast();
                if (we.element.movedOn) continue;
                we.waitingThread.interrupt();
                if (we.lockType == LockType.WRITE) break;
            } while (this.waitingThreadList.size() > 0);
        }
    }

    int getWriteCount() {
        return this.writeCount;
    }

    int getReadCount() {
        return this.readCount;
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    @Override
    public synchronized boolean visit(StringLogger.LineLogger logger) {
        logger.logLine("Total lock count: readCount=" + this.readCount + " writeCount=" + this.writeCount + " for " + this.resource);
        logger.logLine("Waiting list:");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            WaitElement we = (WaitElement)wElements.next();
            logger.logLine("[" + we.waitingThread + "(" + we.element.readCount + "r," + we.element.writeCount + "w)," + (Object)((Object)we.lockType) + "]");
            if (wElements.hasNext()) {
                logger.logLine(",");
                continue;
            }
            logger.logLine("");
        }
        logger.logLine("Locking transactions:");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            logger.logLine("" + tle.tx + "(" + tle.readCount + "r," + tle.writeCount + "w)");
        }
        return true;
    }

    synchronized LockInfo info() {
        String id;
        ResourceType type;
        HashSet<LockingTransaction> lockingTxs = new HashSet<LockingTransaction>();
        HashSet<WaitingThread> waitingTxs = new HashSet<WaitingThread>();
        for (TxLockElement tle : this.txLockElementMap.values()) {
            lockingTxs.add(new LockingTransaction(tle.tx.toString(), tle.readCount, tle.writeCount));
        }
        for (WaitElement thread : this.waitingThreadList) {
            waitingTxs.add(WaitingThread.create(thread.element.tx.toString(), thread.element.readCount, thread.element.writeCount, thread.waitingThread, thread.since, thread.lockType == LockType.WRITE));
        }
        if (this.resource instanceof Node) {
            type = ResourceType.NODE;
            id = Long.toString(((Node)this.resource).getId());
        } else if (this.resource instanceof Relationship) {
            type = ResourceType.NODE;
            id = Long.toString(((Relationship)this.resource).getId());
        } else {
            type = ResourceType.OTHER;
            id = this.resource.toString();
        }
        return new LockInfo(type, id, this.readCount, this.writeCount, new ArrayList<LockingTransaction>(lockingTxs), new ArrayList<WaitingThread>(waitingTxs));
    }

    synchronized boolean acceptVisitorIfWaitedSinceBefore(Visitor<LockInfo, RuntimeException> visitor, long waitStart) {
        for (WaitElement thread : this.waitingThreadList) {
            if (thread.since >= waitStart) continue;
            return visitor.visit(this.info());
        }
        return false;
    }

    public String toString() {
        return "RWLock[" + this.resource + "]";
    }

    private static class WaitElement {
        final TxLockElement element;
        final LockType lockType;
        final Thread waitingThread;
        final long since = System.currentTimeMillis();

        WaitElement(TxLockElement element, LockType lockType, Thread thread) {
            this.element = element;
            this.lockType = lockType;
            this.waitingThread = thread;
        }
    }

    private static class TxLockElement {
        final Transaction tx;
        int readCount = 0;
        int writeCount = 0;
        private boolean movedOn = false;

        TxLockElement(Transaction tx) {
            this.tx = tx;
        }
    }
}

