/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store.labels;

import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.InlineNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;

public class NodeLabelsField {
    public static NodeLabels parseLabelsField(NodeRecord node) {
        long labelField = node.getLabelField();
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField)) {
            return new DynamicNodeLabels(labelField, node);
        }
        return new InlineNodeLabels(labelField, node);
    }

    static long parseLabelsBody(long labelsField) {
        return labelsField & 0xFFFFFFFFFL;
    }

    private static boolean fieldPointsToDynamicRecordOfLabels(long labelField) {
        return (labelField & 0x8000000000L) != 0L;
    }

    public static Long fieldDynamicLabelRecordId(long labelField) {
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField)) {
            return NodeLabelsField.parseLabelsBody(labelField);
        }
        return null;
    }
}

