/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class RelationshipProxy
implements Relationship {
    private final long relId;
    private final RelationshipLookups relationshipLookups;
    private final ThreadToStatementContextBridge statementCtxProvider;

    RelationshipProxy(long relId, RelationshipLookups relationshipLookups, ThreadToStatementContextBridge statementCtxProvider) {
        this.relId = relId;
        this.relationshipLookups = relationshipLookups;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.relationshipLookups.getGraphDatabaseService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        StatementOperationParts ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            ctxForWriting.entityWriteOperations().relationshipDelete(state, this.getId());
        }
    }

    @Override
    public Node[] getNodes() {
        this.assertInTransaction();
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        return new Node[]{this.relationshipLookups.newNodeProxy(relationship.getStartNodeId()), this.relationshipLookups.newNodeProxy(relationship.getEndNodeId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        this.assertInTransaction();
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        if (relationship.getStartNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getEndNodeId());
        }
        if (relationship.getEndNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getStartNodeId());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        this.assertInTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getStartNodeId());
    }

    @Override
    public Node getEndNode() {
        this.assertInTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getEndNodeId());
    }

    @Override
    public RelationshipType getType() {
        this.assertInTransaction();
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            ArrayList<String> keys = new ArrayList<String>();
            PrimitiveLongIterator keyIds = context.entityReadOperations().relationshipGetPropertyKeys(state, this.getId());
            while (keyIds.hasNext()) {
                keys.add(context.keyReadOperations().propertyKeyGetName(state, keyIds.next()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<Property, Object>(){

                @Override
                public Object apply(Property prop) {
                    try {
                        return prop.value();
                    }
                    catch (PropertyNotFoundException e) {
                        throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
                    }
                }
            }, context.entityReadOperations().relationshipGetAllProperties(state, this.getId())));
            return set;
        }
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementOperationParts ctxForReading = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyId = ctxForReading.keyReadOperations().propertyKeyGetForName(state, key);
            Object object = ctxForReading.entityReadOperations().relationshipGetProperty(state, this.relId, propertyId).value();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementOperationParts ctxForReading = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyId = ctxForReading.keyReadOperations().propertyKeyGetForName(state, key);
            Object object = ctxForReading.entityReadOperations().relationshipGetProperty(state, this.relId, propertyId).value(defaultValue);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        StatementOperationParts ctxForReading = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyId = ctxForReading.keyReadOperations().propertyKeyGetForName(state, key);
            boolean bl = ctxForReading.entityReadOperations().relationshipHasProperty(state, this.relId, propertyId);
            return bl;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        StatementOperationParts ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        StatementState state = this.statementCtxProvider.statementForWriting();
        boolean success = false;
        try {
            long propertyKeyId = ctxForWriting.keyWriteOperations().propertyKeyGetOrCreateForName(state, key);
            ctxForWriting.entityWriteOperations().relationshipSetProperty(state, this.relId, Property.property(propertyKeyId, value));
            success = true;
        }
        catch (PropertyKeyIdNotFoundException e) {
            throw new ThisShouldNotHappenError("Stefan/Jake", "A property key id disappeared under our feet");
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            state.close();
            if (!success) {
                this.relationshipLookups.getNodeManager().setRollbackOnly();
            }
        }
    }

    @Override
    public Object removeProperty(String key) {
        StatementOperationParts ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            long propertyId = ctxForWriting.keyWriteOperations().propertyKeyGetOrCreateForName(state, key);
            Object object = ctxForWriting.entityWriteOperations().relationshipRemoveProperty(state, this.relId, propertyId).value(null);
            return object;
        }
    }

    @Override
    public boolean isType(RelationshipType type) {
        this.assertInTransaction();
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId()).name().equals(type.name());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    private void assertInTransaction() {
        this.statementCtxProvider.assertInTransaction();
    }

    public static interface RelationshipLookups {
        public Node newNodeProxy(long var1);

        public RelationshipImpl lookupRelationship(long var1);

        public GraphDatabaseService getGraphDatabaseService();

        public NodeManager getNodeManager();
    }
}

