/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class RelationshipImpl
extends ArrayBasedPrimitive {
    private final long idAndMore;
    private final int startNodeId;
    private final int endNodeId;

    RelationshipImpl(long id, long startNodeId, long endNodeId, int typeId, boolean newRel) {
        super(newRel);
        this.startNodeId = (int)startNodeId;
        this.endNodeId = (int)endNodeId;
        this.idAndMore = (long)typeId << 48 | (startNodeId & 0xF00000000L) << 12 | (endNodeId & 0xF00000000L) << 8 | id;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelationshipImpl && ((RelationshipImpl)obj).getId() == this.getId();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.idAndMore ^ this.idAndMore >>> 32);
        return result;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return super.sizeOfObjectInBytesIncludingOverhead() + 8 + 8;
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager) {
        return nodeManager.loadProperties(this, false);
    }

    @Override
    protected Object loadPropertyValue(NodeManager nodeManager, int propertyKey) {
        return nodeManager.relationshipLoadPropertyValue(this.getId(), propertyKey);
    }

    @Override
    public long getId() {
        return this.idAndMore & 0xFFFFFFFFFFL;
    }

    long getStartNodeId() {
        return (long)this.startNodeId & 0xFFFFFFFFL | (this.idAndMore & 0xF00000000000L) >> 12;
    }

    long getEndNodeId() {
        return (long)this.endNodeId & 0xFFFFFFFFL | (this.idAndMore & 0xF0000000000L) >> 8;
    }

    int getTypeId() {
        return (int)((this.idAndMore & 0xFFFF000000000000L) >>> 48);
    }

    public String toString() {
        return "RelationshipImpl #" + this.getId() + " of type " + this.getTypeId() + " between Node[" + this.getStartNodeId() + "] and Node[" + this.getEndNodeId() + "]";
    }

    @Override
    public WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement element, boolean create) {
        return element.relationshipElement(this.getId(), create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return nm.newRelationshipProxyById(this.getId());
    }

    @Override
    protected Property noProperty(long key) {
        return Property.noRelationshipProperty(this.getId(), key);
    }
}

