/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class GraphPropertiesImpl
extends Primitive
implements GraphProperties {
    private final NodeManager nodeManager;
    private Map<Integer, Property> properties;
    private final ThreadToStatementContextBridge statementCtxProvider;

    GraphPropertiesImpl(NodeManager nodeManager, ThreadToStatementContextBridge statementCtxProvider) {
        super(false);
        this.nodeManager = nodeManager;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeManager.getGraphDbService();
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return 0;
    }

    @Override
    protected boolean hasLoadedProperties() {
        return this.properties != null;
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager) {
        return nodeManager.loadGraphProperties(false);
    }

    @Override
    protected Object loadPropertyValue(NodeManager nodeManager, int propertyKey) {
        return nodeManager.graphLoadPropertyValue(propertyKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        StatementOperationParts ctxForReading = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyId = ctxForReading.keyReadOperations().propertyKeyGetForName(state, key);
            boolean bl = ctxForReading.entityReadOperations().graphHasProperty(state, propertyId);
            return bl;
        }
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementOperationParts ctxForReading = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyId = ctxForReading.keyReadOperations().propertyKeyGetForName(state, key);
            Object object = ctxForReading.entityReadOperations().graphGetProperty(state, propertyId).value();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementOperationParts ctxForReading = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyId = ctxForReading.keyReadOperations().propertyKeyGetForName(state, key);
            Object object = ctxForReading.entityReadOperations().graphGetProperty(state, propertyId).value(defaultValue);
            return object;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        StatementOperationParts ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        StatementState state = this.statementCtxProvider.statementForWriting();
        boolean success = false;
        try {
            long propertyKeyId = ctxForWriting.keyWriteOperations().propertyKeyGetOrCreateForName(state, key);
            ctxForWriting.entityWriteOperations().graphSetProperty(state, Property.property(propertyKeyId, value));
            success = true;
        }
        catch (PropertyKeyIdNotFoundException e) {
            throw new ThisShouldNotHappenError("Stefan/Jake", "A property key id disappeared under our feet");
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            state.close();
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    @Override
    public Object removeProperty(String key) {
        StatementOperationParts ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            long propertyId = ctxForWriting.keyWriteOperations().propertyKeyGetOrCreateForName(state, key);
            Object object = ctxForWriting.entityWriteOperations().graphRemoveProperty(state, propertyId).value(null);
            return object;
        }
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            ArrayList<String> keys = new ArrayList<String>();
            PrimitiveLongIterator keyIds = context.entityReadOperations().graphGetPropertyKeys(state);
            while (keyIds.hasNext()) {
                keys.add(context.keyReadOperations().propertyKeyGetName(state, keyIds.next()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Object> getPropertyValues() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<Property, Object>(){

                @Override
                public Object apply(Property prop) {
                    try {
                        return prop.value();
                    }
                    catch (PropertyNotFoundException e) {
                        throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
                    }
                }
            }, context.entityReadOperations().graphGetAllProperties(state)));
            return set;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GraphProperties && ((GraphProperties)obj).getNodeManager().equals(this.nodeManager);
    }

    @Override
    public int hashCode() {
        return this.nodeManager.hashCode();
    }

    @Override
    public long getId() {
        return -1L;
    }

    @Override
    protected void setEmptyProperties() {
        this.properties = new HashMap<Integer, Property>();
    }

    @Override
    protected Iterator<Property> getCachedProperties() {
        return this.properties.values().iterator();
    }

    @Override
    protected PrimitiveLongIterator getCachedPropertyKeys() {
        return new PropertyKeyIdIterator(this.getCachedProperties());
    }

    @Override
    protected Property getCachedProperty(int key) {
        Property property = this.properties.get(key);
        return property != null ? property : Property.noGraphProperty(key);
    }

    @Override
    protected PropertyData getPropertyForIndex(int keyId) {
        Property property = this.properties.get(keyId);
        return property != null ? property.asPropertyDataJustForIntegration() : null;
    }

    @Override
    protected void setProperties(Iterator<Property> loadedProperties) {
        if (loadedProperties != null && loadedProperties.hasNext()) {
            HashMap<Integer, Property> newProperties = new HashMap<Integer, Property>();
            while (loadedProperties.hasNext()) {
                Property property = loadedProperties.next();
                newProperties.put((int)property.propertyKeyId(), property);
            }
            this.properties = newProperties;
        } else {
            this.properties = new HashMap<Integer, Property>();
        }
    }

    @Override
    public WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement element, boolean create) {
        return element.graphElement(create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return this;
    }

    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap, long firstProp) {
        if (cowPropertyAddMap != null) {
            for (Map.Entry<Integer, PropertyData> entry : cowPropertyAddMap.entrySet()) {
                this.properties.put(entry.getKey(), Property.property(entry.getKey().intValue(), entry.getValue().getValue()));
            }
        }
        if (cowPropertyRemoveMap != null) {
            for (Map.Entry<Integer, PropertyData> entry : cowPropertyRemoveMap.entrySet()) {
                this.properties.remove(entry.getKey());
            }
        }
    }
}

