/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cleanup;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import org.neo4j.kernel.impl.cleanup.ReferenceQueueBasedCleanupService;

class CleanupReference
extends PhantomReference<Object> {
    private final ReferenceQueueBasedCleanupService cleanupService;
    private final String referenceDescription;
    private Closeable handler;
    CleanupReference prev;
    CleanupReference next;

    CleanupReference(Object referent, ReferenceQueueBasedCleanupService cleanupService, Closeable handler) {
        super(referent, cleanupService.collectedReferences.queue);
        this.referenceDescription = referent.toString();
        this.cleanupService = cleanupService;
        this.handler = handler;
    }

    public String description() {
        return this.referenceDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupNow(boolean explicit) throws IOException {
        boolean shouldUnlink = false;
        try {
            CleanupReference cleanupReference = this;
            synchronized (cleanupReference) {
                if (this.handler != null) {
                    shouldUnlink = true;
                    if (!explicit) {
                        this.cleanupService.logLeakedReference(this);
                    }
                    try {
                        this.handler.close();
                    }
                    finally {
                        this.handler = null;
                    }
                }
            }
        }
        finally {
            if (shouldUnlink) {
                this.cleanupService.unlink(this);
            }
        }
    }
}

