/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.ConstraintCreationException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintCreationKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.operations.WritableStatementState;
import org.neo4j.kernel.impl.api.CachingStatementOperations;
import org.neo4j.kernel.impl.api.DelegatingKernelTransaction;
import org.neo4j.kernel.impl.api.LegacyAutoIndexAuxStoreOps;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StoreKernelTransaction;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.OldTxStateBridgeImpl;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class StateHandlingKernelTransaction
extends DelegatingKernelTransaction
implements TxState.Holder {
    private final SchemaIndexProviderMap providerMap;
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final SchemaStorage schemaStorage;
    private final PersistenceManager persistenceManager;
    private final UpdateableSchemaState schemaState;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final NodeManager nodeManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final OldTxStateBridge legacyStateBridge;
    private TxState txState;

    public StateHandlingKernelTransaction(StoreKernelTransaction delegate, SchemaStorage schemaStorage, TransactionState legacyState, SchemaIndexProviderMap providerMap, PersistenceCache persistenceCache, SchemaCache schemaCache, PersistenceManager persistenceManager, UpdateableSchemaState schemaState, ConstraintIndexCreator constraintIndexCreator, PropertyKeyTokenHolder propertyKeyTokenHolder, NodeManager nodeManager) {
        super(delegate);
        this.schemaStorage = schemaStorage;
        this.providerMap = providerMap;
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
        this.persistenceManager = persistenceManager;
        this.schemaState = schemaState;
        this.constraintIndexCreator = constraintIndexCreator;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.nodeManager = nodeManager;
        this.legacyStateBridge = new OldTxStateBridgeImpl(nodeManager, legacyState);
    }

    @Override
    public StatementOperationParts newStatementOperations() {
        StatementOperationParts parts = this.delegate.newStatementOperations();
        CachingStatementOperations cachingContext = new CachingStatementOperations(parts.entityReadOperations(), parts.schemaReadOperations(), this.persistenceCache, this.schemaCache);
        parts = parts.override(null, null, cachingContext, null, cachingContext, null, null, new Object[0]);
        AuxiliaryStoreOperations auxStoreOperations = parts.resolve(AuxiliaryStoreOperations.class);
        auxStoreOperations = new LegacyAutoIndexAuxStoreOps(auxStoreOperations, this.propertyKeyTokenHolder, this.nodeManager.getNodePropertyTrackers(), this.nodeManager.getRelationshipPropertyTrackers(), this.nodeManager);
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(parts.entityReadOperations(), parts.schemaReadOperations(), auxStoreOperations, this.constraintIndexCreator);
        parts = parts.override(null, null, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(this.schemaState), new Object[0]);
        return parts;
    }

    @Override
    public StatementState newStatementState() {
        WritableStatementState statement = (WritableStatementState)super.newStatementState();
        statement.provide(this);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws TransactionFailureException {
        boolean success = false;
        try {
            this.createTransactionCommands();
            super.commit();
            success = true;
        }
        finally {
            if (!success) {
                this.dropCreatedConstraintIndexes();
            }
        }
        if (this.hasTxStateWithChanges()) {
            this.persistenceCache.apply(this.txState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws TransactionFailureException {
        try {
            this.dropCreatedConstraintIndexes();
        }
        finally {
            super.rollback();
        }
    }

    private void createTransactionCommands() {
        if (this.hasTxStateWithChanges()) {
            final AtomicBoolean clearState = new AtomicBoolean(false);
            this.txState().accept(new TxState.Visitor(){

                @Override
                public void visitNodeLabelChanges(long id, Set<Long> added, Set<Long> removed) {
                }

                @Override
                public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                    SchemaIndexProvider.Descriptor providerDescriptor = StateHandlingKernelTransaction.this.providerMap.getDefaultProvider().getProviderDescriptor();
                    IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(StateHandlingKernelTransaction.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(StateHandlingKernelTransaction.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
                    StateHandlingKernelTransaction.this.persistenceManager.createSchemaRule(rule);
                }

                @Override
                public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                    try {
                        IndexRule rule = StateHandlingKernelTransaction.this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId());
                        StateHandlingKernelTransaction.this.persistenceManager.dropSchemaRule(rule.getId());
                    }
                    catch (SchemaRuleNotFoundException e) {
                        throw new ThisShouldNotHappenError("Tobias Lindaaker", "Index to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                    }
                }

                @Override
                public void visitAddedConstraint(UniquenessConstraint element, long indexId) {
                    try {
                        StateHandlingKernelTransaction.this.constraintIndexCreator.validateConstraintIndex(element, indexId);
                    }
                    catch (ConstraintCreationKernelException e) {
                        throw new ConstraintCreationException(e);
                    }
                    clearState.set(true);
                    long constraintId = StateHandlingKernelTransaction.this.schemaStorage.newRuleId();
                    StateHandlingKernelTransaction.this.persistenceManager.createSchemaRule(UniquenessConstraintRule.uniquenessConstraintRule(constraintId, element.label(), element.property(), indexId));
                    StateHandlingKernelTransaction.this.persistenceManager.setConstraintIndexOwner(indexId, constraintId);
                }

                @Override
                public void visitRemovedConstraint(UniquenessConstraint element) {
                    try {
                        clearState.set(true);
                        UniquenessConstraintRule rule = StateHandlingKernelTransaction.this.schemaStorage.uniquenessConstraint(element.label(), element.property());
                        StateHandlingKernelTransaction.this.persistenceManager.dropSchemaRule(rule.getId());
                    }
                    catch (SchemaRuleNotFoundException e) {
                        throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                    }
                    this.visitRemovedIndex(new IndexDescriptor(element.label(), element.property()), true);
                }
            });
            if (clearState.get()) {
                this.schemaState.clear();
            }
        }
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                try {
                    this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                }
                catch (SchemaKernelException e) {
                    throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                }
                catch (TransactionFailureException e) {
                    throw e;
                }
                catch (TransactionalException e) {
                    throw new IllegalStateException("The transaction manager could not fulfill the transaction for dropping the constraint.", e);
                }
            }
        }
    }

    @Override
    public TxState txState() {
        if (!this.hasTxState()) {
            this.txState = new TxStateImpl(this.legacyStateBridge, this.persistenceManager, null);
        }
        return this.txState;
    }

    @Override
    public boolean hasTxState() {
        return null != this.txState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.legacyStateBridge.hasChanges() || this.hasTxState() && this.txState.hasChanges();
    }
}

